/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.parse;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.parse.PalssonParser;
import ch.javasoft.metabolic.parse.junit.AbstractParseTestCase;
import ch.javasoft.util.Arrays;
import java.io.File;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class SantosTest
extends AbstractParseTestCase {
    private static final File FOLDER_DATA = new File("../metabolic-data/santos/");

    public void test_P_putida_core() throws Exception {
        this.internalTest(new File(FOLDER_DATA, "P-putida/Ppu-070426-core.csv"));
    }

    public void test_P_putida_full() throws Exception {
        this.internalTest(new File(FOLDER_DATA, "P-putida/Ppu-070426-full.csv"));
    }

    public void test_P_aeruginosa_full() throws Exception {
        this.internalTest(new File(FOLDER_DATA, "P-aeruginosa/Pae-070426-full.csv"));
    }

    private void internalTest(File file) throws Exception {
        this.internalTest(file, null, null);
    }

    private void internalTest(File file, Pattern externalPattern, String[] excludeReactions) throws Exception {
        Reaction[] reacts = externalPattern == null ? new PalssonParser().parseReactions(file) : new PalssonParser().parseReactions(file, externalPattern);
        DefaultMetabolicNetwork metaNet = new DefaultMetabolicNetwork(reacts);
        System.out.println("parsed network: " + SantosTest.netSize(metaNet));
        Set<String> suppressedReacs = Arrays.asSet(excludeReactions);
        this.internalTestOrDelegate(metaNet, suppressedReacs);
    }

    private static String netSize(MetabolicNetwork net) {
        return String.valueOf(net.getMetabolites().length()) + " metabolites, " + net.getReactions().length() + " reactions";
    }
}

