/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.parse;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.ReactionConstraints;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.impl.DefaultReactionConstraints;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GamsParser {
    private static final Pattern BOUNDS_PTN = Pattern.compile("/\\((.*)\\)\\s+(.*)/");

    public static MetabolicNetwork parse(File folder, String filePrefix) throws IOException {
        return GamsParser.parse(new File(folder, String.valueOf(filePrefix) + ".metas"), new File(folder, String.valueOf(filePrefix) + ".reacts"), new File(folder, String.valueOf(filePrefix) + ".N"), new File(folder, String.valueOf(filePrefix) + ".lower"), new File(folder, String.valueOf(filePrefix) + ".upper"));
    }

    public static MetabolicNetwork parse(File metasFile, File reactsFile, File stoichFile, File lowerFile, File upperFile) throws IOException {
        List<String> metas = GamsParser.parseList(metasFile);
        List<String> reacts = GamsParser.parseList(reactsFile);
        double[][] stoich = GamsParser.parseStoich(metas, reacts, stoichFile);
        double[] lower = GamsParser.parseBounds(reacts, lowerFile);
        double[] upper = GamsParser.parseBounds(reacts, upperFile);
        return GamsParser.createMetabolicNetwork(metas, reacts, stoich, lower, upper);
    }

    private static List<String> parseList(File file) throws IOException {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            String[] split;
            if (line.startsWith("/")) {
                line = line.substring(1);
            }
            if (line.endsWith("/")) {
                line = line.substring(0, line.length() - 1);
            }
            String[] stringArray = split = line.split(",");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if ((str = str.trim()).length() > 0) {
                    result.add(str.trim());
                }
                ++n2;
            }
        }
        return result;
    }

    private static double[][] parseStoich(List<String> metas, List<String> reacts, File stoichFile) throws IOException {
        String line;
        double[][] result = new double[metas.size()][reacts.size()];
        Map<String, Integer> iMetas = GamsParser.createIndexMap(metas);
        Map<String, Integer> iReacts = GamsParser.createIndexMap(reacts);
        BufferedReader reader = new BufferedReader(new FileReader(stoichFile));
        while ((line = reader.readLine()) != null) {
            try {
                double coeff;
                int dotIndex = line.indexOf(46);
                int spaceIndex = line.indexOf(32, dotIndex + 1);
                String metaName = line.substring(0, dotIndex);
                String reacName = line.substring(dotIndex + 1, spaceIndex);
                String sCoeff = line.substring(spaceIndex + 1);
                int metaIndex = iMetas.get(metaName);
                int reacIndex = iReacts.get(reacName);
                result[metaIndex][reacIndex] = coeff = Double.parseDouble(sCoeff);
            }
            catch (Exception ex) {
                String msg = "cannot parse line: " + line;
                System.err.println(msg);
                ex.printStackTrace();
                throw new IOException(msg);
            }
        }
        return result;
    }

    private static double[] parseBounds(List<String> reactions, File file) throws IOException {
        String line;
        double[] result = new double[reactions.size()];
        Map<String, Integer> iReacts = GamsParser.createIndexMap(reactions);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            try {
                Matcher matcher = BOUNDS_PTN.matcher(line);
                if (!matcher.matches()) {
                    throw new IOException("syntac error in file '" + file.getAbsolutePath() + "': " + line);
                }
                String sReacts = matcher.group(1);
                String sValue = matcher.group(2);
                String[] reacts = sReacts.split(",");
                double value = Double.parseDouble(sValue);
                if (reacts.length == 1 && reacts[0].equals("*")) {
                    int ii = 0;
                    while (ii < result.length) {
                        result[ii] = value;
                        ++ii;
                    }
                    continue;
                }
                String[] stringArray = reacts;
                int n = reacts.length;
                int n2 = 0;
                while (n2 < n) {
                    String react = stringArray[n2];
                    int reactIndex = iReacts.get(react.trim());
                    result[reactIndex] = value;
                    ++n2;
                }
            }
            catch (Exception ex) {
                String msg = "cannot parse line: " + line;
                System.err.println(msg);
                ex.printStackTrace();
                throw new IOException(msg);
            }
        }
        return result;
    }

    private static MetabolicNetwork createMetabolicNetwork(List<String> metas, List<String> reacts, double[][] stoich, double[] lower, double[] upper) {
        String[] aMetas = new String[metas.size()];
        aMetas = metas.toArray(aMetas);
        String[] aReacts = new String[reacts.size()];
        aReacts = reacts.toArray(aReacts);
        return new DefaultMetabolicNetwork(aMetas, aReacts, stoich, GamsParser.createReactionConstraints(lower, upper));
    }

    private static ReactionConstraints[] createReactionConstraints(double[] lower, double[] upper) {
        HashMap<DefaultReactionConstraints, DefaultReactionConstraints> reuse = new HashMap<DefaultReactionConstraints, DefaultReactionConstraints>();
        ReactionConstraints[] constr = new ReactionConstraints[lower.length];
        int ii = 0;
        while (ii < constr.length) {
            ReactionConstraints instance = new DefaultReactionConstraints(lower[ii], upper[ii]);
            if (!reuse.containsKey(instance)) {
                reuse.put((DefaultReactionConstraints)instance, (DefaultReactionConstraints)instance);
            } else {
                instance = (ReactionConstraints)reuse.get(instance);
            }
            constr[ii] = instance;
            ++ii;
        }
        return constr;
    }

    private static Map<String, Integer> createIndexMap(List<String> list) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int index = 0;
        while (index < list.size()) {
            map.put(list.get(index), index);
            ++index;
        }
        return map;
    }

    private GamsParser() {
    }
}

