/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.generate;

import ch.javasoft.io.Print;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.fa.FaConstants;
import ch.javasoft.metabolic.generate.MatlabGenerator;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.impl.FilteredMetabolicNetwork;
import ch.javasoft.metabolic.parse.FluxAnalyserParser;
import ch.javasoft.metabolic.parse.GamsParser;
import ch.javasoft.metabolic.parse.PalssonParser;
import ch.javasoft.metabolic.parse.SbmlParser;
import ch.javasoft.util.logging.Loggers;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import junit.framework.TestCase;
import org.dom4j.DocumentException;

public class MatlabTest
extends TestCase {
    private static final File FOLDER_COMPRESS;
    private static final File FOLDER_MATLAB;

    static {
        try {
            Loggers.logToFile("/tmp/eclipse-console.log", Level.FINEST);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        FOLDER_COMPRESS = new File("../metabolic-data/palsson");
        FOLDER_MATLAB = new File(FOLDER_COMPRESS, "matlab");
    }

    public void testColi_All() throws IOException, DocumentException {
        this.internalTestFluxAnalyzer(FaConstants.SUBNET_ALL, new File(FOLDER_MATLAB, "fba_coli_all.m"), "mue");
    }

    public void testPalsson_coli_iJR904_sbml() throws IOException, DocumentException {
        this.internalTestSbml(new File(FOLDER_COMPRESS, "coli/Ec_iJR904.xml"), new File(FOLDER_MATLAB, "fba_iJR904_sbml.m"), "Extra_organism", "R_BiomassEcoli");
    }

    public void testPalsson_coli_iJR904_sbml_flux1() throws IOException, DocumentException {
        this.internalTestSbml(new File(FOLDER_COMPRESS, "coli/Ec_iJR904_flux1.xml"), new File(FOLDER_MATLAB, "fba_iJR904_sbml_flux1.m"), "Extra_organism", "R_BiomassEcoli");
    }

    public void testPalsson_coli_iJR904_gams() throws IOException, DocumentException {
        this.internalTestGams(new File(FOLDER_COMPRESS, "coli"), "EcoliiJR904.gms", new File(FOLDER_MATLAB, "fba_EcoliiJR904.m"), "BiomassEcoli");
    }

    public void testPalsson_coli_iJR904_xrev() throws IOException {
        this.internalTestPalsson(new File(FOLDER_COMPRESS, "coli/iJR904(7-28-04)-reacts-xrev.csv"), new File(FOLDER_MATLAB, "fba_iJR904_xrev.m"), "mue");
    }

    public void testPalsson_coli_iJR904_xspec() throws IOException {
        this.internalTestPalsson(new File(FOLDER_COMPRESS, "coli/iJR904(7-28-04)-reacts-xspec.csv"), new File(FOLDER_MATLAB, "fba_iJR904_xspec.m"), "mue");
    }

    public void testPalsson_coli_iJR904_xnone() throws IOException {
        this.internalTestPalsson(new File(FOLDER_COMPRESS, "coli/iJR904(7-28-04)-reacts-xnone.csv"), new File(FOLDER_MATLAB, "fba_iJR904_xnone.m"), "mue");
    }

    public void testPalsson_coli_iJR904_xnone_nobio() throws IOException {
        this.internalTestPalsson(new File(FOLDER_COMPRESS, "coli/iJR904(7-28-04)-reacts-xnone_nobio.csv"), new File(FOLDER_MATLAB, "fba_iJR904_xnonenobio.m"), "mue");
    }

    public void testPalsson_coli_Robert() throws IOException, DocumentException {
        Pattern externalPattern = Pattern.compile(".*xt|BM");
        this.internalTestPalsson(new File(FOLDER_COMPRESS, "coli/coliRobert.csv"), new File(FOLDER_MATLAB, "fba_coliRobert.m"), externalPattern, "biomass");
    }

    public void testPalsson_aureus_iSB619_xrev() throws IOException {
        this.internalTestPalsson(new File(FOLDER_COMPRESS, "staph_aureus/iSB619-reacts-xrev.csv"), new File(FOLDER_MATLAB, "fba_iSB619_xrev.m"), "biomass_SA_8a");
    }

    public void testPalsson_aureus_iSB619_xspec() throws IOException {
        this.internalTestPalsson(new File(FOLDER_COMPRESS, "staph_aureus/iSB619-reacts-xspec.csv"), new File(FOLDER_MATLAB, "fba_iSB619_xspec.m"), "biomass_SA_8a");
    }

    public void testPalsson_aureus_iSB619_xnone() throws IOException {
        this.internalTestPalsson(new File(FOLDER_COMPRESS, "staph_aureus/iSB619-reacts-xnone.csv"), new File(FOLDER_MATLAB, "fba_iSB619_xnone.m"), "mue");
    }

    public void testPalsson_aureus_iMH556() throws IOException {
        this.internalTestPalsson(new File(FOLDER_COMPRESS, "staph_aureus/iMH556.csv"), new File(FOLDER_MATLAB, "fba_iMH556.m"), "BX");
    }

    public void testPalsson_barkeri_iAF692_xspec() throws IOException {
        this.internalTestPalsson(new File(FOLDER_COMPRESS, "barkeri/mbarkeri-iAF692.csv"), new File(FOLDER_MATLAB, "fba_iAF692_xspec.m"), "biomass");
    }

    public void testPalsson_pylori_iIT341_xspec() throws IOException {
        this.internalTestPalsson(new File(FOLDER_COMPRESS, "pylori/iIT341.csv"), new File(FOLDER_MATLAB, "fba_iIT341_xspec.m"), "mue");
    }

    public void testPalsson_yeastc_iND750() throws IOException {
        Pattern externalPattern = Pattern.compile(".*\\[e\\]");
        this.internalTestPalsson(new File(FOLDER_COMPRESS, "yeast-cerevisiae/iND750-reacts.csv"), new File(FOLDER_MATLAB, "fba_iND750.m"), externalPattern, "mue");
    }

    public void testPalsson_yeastc_iLL672() throws IOException {
        Pattern externalPattern = Pattern.compile(".*xt");
        this.internalTestPalsson(new File(FOLDER_COMPRESS, "yeast-cerevisiae/iLL672-reacts.csv"), new File(FOLDER_MATLAB, "fba_iLL672.m"), externalPattern, "biomass-1");
    }

    public void testPalsson_yeastc_iLL672_unbalancedMetas() throws IOException {
        Pattern externalPattern = Pattern.compile(".*xt|TRE|GLYCOGEN|CLm|DEAC|PAP|RADP|SAMOB|THFG");
        this.internalTestPalsson(new File(FOLDER_COMPRESS, "yeast-cerevisiae/iLL672-reacts.csv"), new File(FOLDER_MATLAB, "fba_iLL672_unbalanced.m"), externalPattern, "biomass-1");
    }

    public void testPalsson_yeastc_Dirk() throws IOException, DocumentException {
        this.internalTestSbml(new File(FOLDER_COMPRESS, "yeast-cerevisiae/Yeast_model_Dirk.xml"), new File(FOLDER_MATLAB, "fba_Yeast_model_Dirk.m"), "external", "biomass formation");
    }

    private void internalTestPalsson(File inFile, File outFile, String biomassReactionName) throws IOException {
        this.internalTestPalsson(inFile, outFile, null, biomassReactionName);
    }

    private void internalTestPalsson(File inFile, File outFile, Pattern externalPattern, String biomassReactionName) throws IOException {
        Reaction[] reacts = externalPattern == null ? new PalssonParser().parseReactions(inFile) : new PalssonParser().parseReactions(inFile, externalPattern);
        DefaultMetabolicNetwork metaNet = new DefaultMetabolicNetwork(reacts);
        System.out.println("parsed network: " + MatlabTest.netSize(metaNet));
        this.writeMatlabFile(metaNet, outFile, biomassReactionName);
    }

    private void internalTestSbml(File inFile, File outFile, String externalCompartment, String biomassReactionName) throws IOException, DocumentException {
        MetabolicNetwork metaNet = new SbmlParser(externalCompartment, false).parse(inFile);
        System.out.println("parsed network: " + MatlabTest.netSize(metaNet));
        this.writeMatlabFile(metaNet, outFile, biomassReactionName);
    }

    private void internalTestGams(File inFolder, String inFileName, File outFile, String biomassReactionName) throws IOException {
        MetabolicNetwork metaNet = GamsParser.parse(inFolder, inFileName);
        System.out.println("parsed network: " + MatlabTest.netSize(metaNet));
        this.writeMatlabFile(metaNet, outFile, biomassReactionName);
    }

    private void internalTestFluxAnalyzer(FaConstants.SubNet subNet, File outFile, String biomassReactionName) throws IOException {
        MetabolicNetwork net = FluxAnalyserParser.parse(FaConstants.COLI_FOLDER);
        FilteredMetabolicNetwork fNet = new FilteredMetabolicNetwork(net);
        fNet.excludeReactions(subNet.excludeReactions);
        System.out.println("parsed network: " + MatlabTest.netSize(fNet));
        this.writeMatlabFile(fNet, outFile, biomassReactionName);
    }

    private void writeMatlabFile(MetabolicNetwork metaNet, File outFile, String biomassReactionName) throws IOException {
        if (outFile.exists()) {
            String ans = JOptionPane.showInputDialog("The file below already exists. \nYou can change the file name or overwrite it.", (Object)outFile.getAbsoluteFile());
            if (ans == null) {
                System.out.println("aborted.");
                return;
            }
            outFile = new File(ans);
        }
        PrintWriter pw = Print.createWriter(outFile);
        MatlabGenerator matlabGen = new MatlabGenerator("metanet");
        matlabGen.writeStoich(metaNet, pw, false, true);
        matlabGen.writeMetaNames(metaNet, pw);
        matlabGen.writeReactionNames(metaNet, pw);
        matlabGen.writeLowerBounds(metaNet, pw);
        matlabGen.writeUpperBounds(metaNet, pw);
        pw.flush();
        System.out.println("written matlab file: " + outFile.getAbsolutePath());
    }

    private static String netSize(MetabolicNetwork net) {
        return String.valueOf(net.getMetabolites().length()) + " metabolites, " + net.getReactions().length() + " reactions";
    }
}

