/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.generate;

import ch.javasoft.io.Print;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.generate.LogPkg;
import ch.javasoft.metabolic.generate.MatlabGenerator;
import ch.javasoft.metabolic.impl.FilteredMetabolicNetwork;
import java.io.File;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaColiTest
extends ch.javasoft.metabolic.parse.FaColiTest {
    private ThreadLocal<String> mModelName = new ThreadLocal();
    private ThreadLocal<String> mFileName = new ThreadLocal();
    private final boolean sbml = false;
    private static final File FOLDER_OUT = new File(System.getProperty("java.io.tmpdir"));

    @Override
    public void testAce() throws Exception {
        this.mModelName.set("E.coli, configuration -ace-: Stelling etc., Nature, 420:190-193, 2002");
        this.mFileName.set("coli-ace");
        super.testAce();
    }

    @Override
    public void testAc() throws Exception {
        this.mModelName.set("E.coli, configuration -ac-: Stelling etc., Nature, 420:190-193, 2002");
        this.mFileName.set("coli-ac");
        super.testAc();
    }

    @Override
    public void testSuc() throws Exception {
        this.mModelName.set("E.coli, configuration -suc-: Stelling etc., Nature, 420:190-193, 2002");
        this.mFileName.set("coli-suc");
        super.testSuc();
    }

    @Override
    public void testGl() throws Exception {
        this.mModelName.set("E.coli, configuration -gl-: Stelling etc., Nature, 420:190-193, 2002");
        this.mFileName.set("coli-gl");
        super.testGl();
    }

    @Override
    public void testGly() throws Exception {
        this.mModelName.set("E.coli, configuration -gly-: Stelling etc., Nature, 420:190-193, 2002");
        this.mFileName.set("coli-gly");
        super.testGly();
    }

    @Override
    public void testStandard() throws Exception {
        this.mModelName.set("E.coli, configuration -standard-: Stelling etc., Nature, 420:190-193, 2002");
        this.mFileName.set("coli-ac");
        super.testStandard();
    }

    @Override
    public void testAll() throws Exception {
        this.mModelName.set("E.coli, configuration -all-: Stelling etc., Nature, 420:190-193, 2002");
        this.mFileName.set("coli-all");
        super.testAll();
    }

    @Override
    public void testSuper() throws Exception {
        this.mModelName.set("E.coli, configuration -super-: Stelling etc., Nature, 420:190-193, 2002");
        this.mFileName.set("coli-super");
        super.testSuperX();
    }

    @Override
    public void testSuperX() throws Exception {
        this.mModelName.set("E.coli, configuration -super-x-: Stelling etc., Nature, 420:190-193, 2002");
        this.mFileName.set("coli-superx");
        super.testSuper();
    }

    @Override
    protected void internalTestMetabolicNetwork(MetabolicNetwork network, Set<String> suppressedReactions) throws Exception {
        FilteredMetabolicNetwork filtered = new FilteredMetabolicNetwork(network, suppressedReactions);
        this.internalTestMetabolicNetwork(network, filtered);
    }

    public void internalTestMetabolicNetwork(MetabolicNetwork originalNetwork, MetabolicNetwork reducedNetwork) throws Exception {
        File fileOut = new File(FOLDER_OUT, String.valueOf(this.mFileName.get()) + ".m");
        String modelName = this.mModelName.get();
        new MatlabGenerator("mnet", modelName).writeAll(reducedNetwork, Print.createWriter(fileOut));
        LogPkg.LOGGER.info("written to file: " + fileOut.getAbsolutePath());
    }
}

