/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.generate;

import ch.javasoft.io.Print;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.generate.LogPkg;
import ch.javasoft.metabolic.generate.MatlabGenerator;
import ch.javasoft.metabolic.generate.SbmlGenerator;
import ch.javasoft.metabolic.impl.FilteredMetabolicNetwork;
import java.io.File;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelTest
extends ch.javasoft.metabolic.parse.ExcelTest {
    private ThreadLocal<String> mModelName = new ThreadLocal();
    private ThreadLocal<String> mSbmlName = new ThreadLocal();
    private ThreadLocal<String> mMatFileName = new ThreadLocal();
    private static final File FOLDER_OUT = new File(System.getProperty("java.io.tmpdir"));

    @Override
    public void test_coli_Robert() throws Exception {
        this.mModelName.set("Robert Schuetz: E.coli (v03)");
        this.mSbmlName.set("coli-robert-v03.sbml");
        this.mMatFileName.set("coli_robert_v03.m");
        super.test_coli_Robert();
    }

    @Override
    public void test_subtilis_Robert() throws Exception {
        this.mModelName.set("Robert Schuetz: B.subtilis (v05)");
        this.mSbmlName.set("subtilis-robert-v05.sbml");
        this.mMatFileName.set("subtilis_robert_v05.m");
        super.test_subtilis_Robert();
    }

    @Override
    protected void internalTestMetabolicNetwork(MetabolicNetwork network, Set<String> suppressedReactions) throws Exception {
        FilteredMetabolicNetwork filtered = new FilteredMetabolicNetwork(network, suppressedReactions);
        this.internalTestMetabolicNetwork(network, filtered);
    }

    public void internalTestMetabolicNetwork(MetabolicNetwork originalNetwork, MetabolicNetwork reducedNetwork) throws Exception {
        File sbmlFileOut = new File(FOLDER_OUT, this.mSbmlName.get());
        File matFileOut = new File(FOLDER_OUT, this.mMatFileName.get());
        String modelName = this.mModelName.get();
        new SbmlGenerator(reducedNetwork, modelName).write(sbmlFileOut);
        LogPkg.LOGGER.info("written to file: " + sbmlFileOut.getAbsolutePath());
        new MatlabGenerator(modelName).writeAll(reducedNetwork, Print.createWriter(matFileOut));
        LogPkg.LOGGER.info("written to file: " + matFileOut.getAbsolutePath());
    }
}

