/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.fa;

import ch.javasoft.util.Arrays;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;

public interface FaConstants {
    public static final File FLUX_ANALYSER_FOLDER = new File("../metabolic-data/FluxAnalyzer50a");
    public static final File COLI_FOLDER = new File(FLUX_ANALYSER_FOLDER, "coli");
    public static final String[] SUCC_EX = new String[]{"Succ_ex", "Succ -->"};
    public static final String[][] AMINO = new String[][]{{"Asp_up", "--> Asp"}, {"Glu_up", "--> Glu"}, {"Ser_up", "--> Ser"}, {"Thr_up", "--> Thr"}, {"Trp_up", "--> Trp"}, {"HSer_up", "--> HSer"}, {"Ala_up", "--> Ala"}, {"Cys_up", "--> Cys"}, {"Phe_up", "--> Phe"}, {"Gly_up", "--> Gly"}, {"His_up", "--> His"}, {"Ile_up", "--> Ile"}, {"Lys_up", "--> Lys"}, {"Leu_up", "--> Leu"}, {"Met_up", "--> Met"}, {"Asn_up", "--> Asn"}, {"Pro_up", "--> Pro"}, {"Gln_up", "--> Gln"}, {"Arg_up", "--> Arg"}, {"Val_up", "--> Val"}, {"Tyr_up", "--> Tyr"}};
    public static final SuperNet SUPERALL_UP_AMINO_EX_SUCC = new SuperNet("superall", (String[][])Arrays.merge(AMINO, new String[][]{SUCC_EX}));
    public static final SuperNet GL_UP_ALL_AMINO_EX_SUCC = new SuperNet("glx_allamino", (String[][])Arrays.merge(AMINO, new String[][]{SUCC_EX}), new String[]{"Succ_up", "Glyc_up", "Ac_up"});
    public static final SuperNet GL_PTS_UP_ALL_AMINO_EX_SUCC = new SuperNet("glpts_allamino", (String[][])Arrays.merge(AMINO, new String[][]{SUCC_EX}), new String[]{"Glc_ATP_up", "Succ_up", "Glyc_up", "Ac_up"});
    public static final SuperNet SUPERXX_UP_ASP_GLU_SER_TRP_EX_SUCC = new SuperNet("superxxx", new String[][]{{"Asp_up", "--> Asp"}, {"Glu_up", "--> Glu"}, {"Ser_up", "--> Ser"}, {"Trp_up", "--> Trp"}, SUCC_EX});
    public static final SuperNet SUPERXX_UP_ASP_GLU_SER_THR_EX_SUCC = new SuperNet("superxxx", new String[][]{{"Asp_up", "--> Asp"}, {"Glu_up", "--> Glu"}, {"Ser_up", "--> Ser"}, {"Thr_up", "--> Thr"}, SUCC_EX});
    public static final SuperNet SUPERXXX_UP_ASP_GLU_SER_THR_TRP_EX_SUCC = new SuperNet("superxxx", new String[][]{{"Asp_up", "--> Asp"}, {"Glu_up", "--> Glu"}, {"Ser_up", "--> Ser"}, {"Thr_up", "--> Thr"}, {"Trp_up", "--> Trp"}, SUCC_EX});
    public static final SuperNet SUPERX_UP_ASP_GLU_SER_EX_SUCC = new SuperNet("superx", new String[][]{{"Asp_up", "--> Asp"}, {"Glu_up", "--> Glu"}, {"Ser_up", "--> Ser"}, SUCC_EX});
    public static final SuperNet SUPER_UP_ASP_EX_SUCC = new SuperNet("super", new String[][]{{"Asp_up", "--> Asp"}, SUCC_EX});
    public static final SuperNet SUPER_EX_SUCC = new SuperNet("allx", new String[][]{SUCC_EX});
    public static final SuperNet GL_EX_SUCC = new SuperNet("glx", new String[][]{SUCC_EX}, new String[]{"Succ_up", "Glyc_up", "Ac_up"});
    public static final SuperNet GL_UP_ALA_ASP_GLU_HIS_PHE_SER_THR_EX_SUCC = new SuperNet("gl_xxamino", new String[][]{{"Ala_up", "--> Ala"}, {"Asp_up", "--> Asp"}, {"Glu_up", "--> Glu"}, {"His_up", "--> His"}, {"Phe_up", "--> Phe"}, {"Ser_up", "--> Ser"}, {"Thr_up", "--> Thr"}, SUCC_EX}, new String[]{"Succ_up", "Glyc_up", "Ac_up"});
    public static final SuperNet GL_UP_ALA_ASP_GLU_HIS_PHE_SER_EX_SUCC = new SuperNet("gl_xamino", new String[][]{{"Ala_up", "--> Ala"}, {"Asp_up", "--> Asp"}, {"Glu_up", "--> Glu"}, {"His_up", "--> His"}, {"Phe_up", "--> Phe"}, {"Ser_up", "--> Ser"}, SUCC_EX}, new String[]{"Succ_up", "Glyc_up", "Ac_up"});
    public static final SuperNet GL_UP_ALA_ASP_GLU_PHE_SER_EX_SUCC = new SuperNet("gl_amino", new String[][]{{"Ala_up", "--> Ala"}, {"Asp_up", "--> Asp"}, {"Glu_up", "--> Glu"}, {"Phe_up", "--> Phe"}, {"Ser_up", "--> Ser"}, SUCC_EX}, new String[]{"Succ_up", "Glyc_up", "Ac_up"});
    public static final SuperNet GL_PTS_UP_ALA_ASP_GLU_HIS_PHE_SER_THR_VAL_EX_SUCC = new SuperNet("glpts_xxxamino", new String[][]{{"Ala_up", "--> Ala"}, {"Asp_up", "--> Asp"}, {"Glu_up", "--> Glu"}, {"His_up", "--> His"}, {"Phe_up", "--> Phe"}, {"Ser_up", "--> Ser"}, {"Thr_up", "--> Thr"}, {"Val_up", "--> Val"}, SUCC_EX}, new String[]{"Glc_ATP_up", "Succ_up", "Glyc_up", "Ac_up"});
    public static final SuperNet GL_PTS_UP_ALA_ASP_GLU_HIS_PHE_SER_THR_EX_SUCC = new SuperNet("glpts_xxamino", new String[][]{{"Ala_up", "--> Ala"}, {"Asp_up", "--> Asp"}, {"Glu_up", "--> Glu"}, {"His_up", "--> His"}, {"Phe_up", "--> Phe"}, {"Ser_up", "--> Ser"}, {"Thr_up", "--> Thr"}, SUCC_EX}, new String[]{"Glc_ATP_up", "Succ_up", "Glyc_up", "Ac_up"});
    public static final SuperNet GL_PTS_UP_ALA_ASP_GLU_HIS_PHE_SER_EX_SUCC = new SuperNet("glpts_xamino", new String[][]{{"Ala_up", "--> Ala"}, {"Asp_up", "--> Asp"}, {"Glu_up", "--> Glu"}, {"His_up", "--> His"}, {"Phe_up", "--> Phe"}, {"Ser_up", "--> Ser"}, SUCC_EX}, new String[]{"Glc_ATP_up", "Succ_up", "Glyc_up", "Ac_up"});
    public static final SuperNet GL_PTS_UP_ALA_ASP_GLU_PHE_SER_EX_SUCC = new SuperNet("glpts_amino", new String[][]{{"Ala_up", "--> Ala"}, {"Asp_up", "--> Asp"}, {"Glu_up", "--> Glu"}, {"Phe_up", "--> Phe"}, {"Ser_up", "--> Ser"}, SUCC_EX}, new String[]{"Glc_ATP_up", "Succ_up", "Glyc_up", "Ac_up"});
    public static final SubNet SUBNET_ALL = new SubNet("all", new String[0]);
    public static final SubNet SUBNET_NOEX = new SubNet("noex", new String[]{"O2_up", "S_up", "N_up", "Glc_PTS_up", "Glc_ATP_up", "Succ_up", "Glyc_up", "Ac_up", "CO2_ex", "Lac_ex", "Eth_ex", "Ac_ex", "Form_ex"});
    public static final SubNet SUBNET_ACE = new SubNet("ace", new String[]{"Glc_PTS_up", "Glc_ATP_up", "Succ_up", "Glyc_up", "Glyc3P::DHAP"});
    public static final SubNet SUBNET_AC = new SubNet("ac", new String[]{"Glc_PTS_up", "Glc_ATP_up", "Succ_up", "Glyc_up", "Ac_ex"});
    public static final SubNet SUBNET_GL = new SubNet("gl", new String[]{"Succ_up", "Glyc_up", "Ac_up"});
    public static final SubNet SUBNET_GLY = new SubNet("gly", new String[]{"Glc_PTS_up", "Glc_ATP_up", "Succ_up", "Ac_up"});
    public static final SubNet SUBNET_STANDARD = new SubNet("standard", new String[]{"Succ_up", "Glyc_up", "Ac_up", "Glyc3P::DHAP"});
    public static final SubNet SUBNET_SUC = new SubNet("suc", new String[]{"Glc_PTS_up", "Glc_ATP_up", "Glyc_up", "Ac_up"});

    public static class Net {
        public final String name;
        public final boolean allowMetaboliteAccumulation;

        public Net(String name, boolean allowMetaboliteAccumulation) {
            this.name = name;
            this.allowMetaboliteAccumulation = allowMetaboliteAccumulation;
        }
    }

    public static class SubNet
    extends Net {
        public final String[] excludeReactions;

        public SubNet(String name, String[] excludeReactions) {
            this(name, excludeReactions, false);
        }

        public SubNet(String name, String[] excludeReactions, boolean allowMetaboliteAccumulation) {
            super(name, allowMetaboliteAccumulation);
            this.excludeReactions = excludeReactions;
        }

        public String getDotFileName() {
            return String.valueOf(this.name) + ".dot";
        }

        public String getFluxesRefFileName() {
            return String.valueOf(this.name) + "-fluxes-ref.txt";
        }

        public String getFluxesFileName() {
            return String.valueOf(this.name) + "-fluxes.txt";
        }
    }

    public static class SuperNet
    extends Net {
        public final String[][] additionalReactions;
        public final String[] excludeReactions;

        public SuperNet(String name, String[][] additionalReactions) {
            this(name, additionalReactions, new String[0]);
        }

        public SuperNet(String name, String[][] additionalReactions, String[] excludeReactions) {
            super(name, false);
            this.additionalReactions = additionalReactions;
            this.excludeReactions = excludeReactions;
        }

        public String toString() {
            return SuperNet.toString(this.additionalReactions);
        }

        public static String toString(String[][] reactionNamesFormulas) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            String[][] stringArray = reactionNamesFormulas;
            int n = reactionNamesFormulas.length;
            int n2 = 0;
            while (n2 < n) {
                String[] reac = stringArray[n2];
                pw.println("\"" + reac[0] + "\"\t\"" + reac[0] + "\"\t\"" + reac[1] + "\"");
                ++n2;
            }
            pw.flush();
            return sw.toString();
        }
    }
}

