/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.util;

import ch.javasoft.math.NumberOperations;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.compress.CompressedMetabolicNetwork;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.util.MappingUtil;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.util.ints.BitSetIntSet;
import ch.javasoft.util.ints.DefaultIntList;
import ch.javasoft.util.ints.IntIterator;
import ch.javasoft.util.ints.IntList;
import ch.javasoft.util.ints.KeyRangeIntIntMap;
import ch.javasoft.util.map.DefaultIntIntMultiValueMap;
import ch.javasoft.util.map.IntIntMultiValueMap;
import ch.javasoft.util.map.JoinedMultiValueMap;
import ch.javasoft.util.map.MultiValueMap;
import ch.javasoft.util.map.SingleValueMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReactionMapping {
    private final Config config;
    private final MetabolicNetwork cmpNet;
    private final int[] sortMapping;
    private final MultiValueMap<Integer, Integer>[] maps;
    private final Map<Join, MultiValueMap<Integer, Integer>> cachedJoins = new HashMap<Join, MultiValueMap<Integer, Integer>>();

    public ReactionMapping(Config config, MetabolicNetwork cmpNet, int[] sortMapping) {
        IntIntMultiValueMap oc;
        this.config = config;
        this.cmpNet = cmpNet;
        this.sortMapping = sortMapping;
        this.maps = new MultiValueMap[Layer.values().length - 1];
        this.maps[SingleForwardMap.OC.ordinal()] = oc = ReactionMapping.getOC(cmpNet);
        this.maps[SingleForwardMap.CE.ordinal()] = ReactionMapping.getCE(config, cmpNet, oc);
        this.maps[SingleForwardMap.ES.ordinal()] = ReactionMapping.getES(sortMapping);
    }

    private static IntIntMultiValueMap getOC(MetabolicNetwork cmpNet) {
        if (cmpNet instanceof CompressedMetabolicNetwork) {
            return ((CompressedMetabolicNetwork)cmpNet).getReactionMapping();
        }
        return DefaultIntIntMultiValueMap.createFromSingleValueMap(new KeyRangeIntIntMap(cmpNet.getReactions().length()));
    }

    private static IntIntMultiValueMap getCE(Config config, MetabolicNetwork cmpNet, IntIntMultiValueMap oc) {
        IntIntMultiValueMap co = oc.invert();
        DefaultIntIntMultiValueMap map = new DefaultIntIntMultiValueMap();
        int iOrg = 0;
        int iMap = 0;
        for (Reaction reaction : cmpNet.getReactions()) {
            map.add(iOrg, iMap);
            ++iMap;
            if (ReactionMapping.isSplitReaction(config, cmpNet, co, reaction, iOrg)) {
                map.add(iOrg, iMap);
                ++iMap;
            }
            ++iOrg;
        }
        return map;
    }

    private static MultiValueMap<Integer, Integer> getES(int[] sortMapping) {
        return new SingleValueMap<Integer, Integer>(new KeyRangeIntIntMap(MappingUtil.getInvertedMapping(sortMapping)));
    }

    public void refreshSortMapping() {
        this.cachedJoins.clear();
        this.maps[Layer.Expanded.ordinal()] = ReactionMapping.getES(this.sortMapping);
    }

    public int getFirst(Layer srcLayer, int srcIndex, Layer dstLayer) {
        MultiValueMap<Integer, Integer> join = this.getJoin(srcLayer, dstLayer);
        Integer mapped = join.getFirst(srcIndex);
        return mapped == null ? -1 : mapped;
    }

    public IntList get(Layer srcLayer, int srcIndex, Layer dstLayer) {
        MultiValueMap<Integer, Integer> join = this.getJoin(srcLayer, dstLayer);
        return new DefaultIntList(join.get(srcIndex));
    }

    private MultiValueMap<Integer, Integer> getJoin(Layer srcLayer, Layer dstLayer) {
        Join join = new Join(srcLayer, dstLayer);
        MultiValueMap<Integer, Integer> res = this.cachedJoins.get(join);
        if (res != null) {
            return res;
        }
        res = this.getMap(join.from);
        if (join.isSingleLayer()) {
            res = new SingleValueMap<Integer, Integer>(new KeyRangeIntIntMap(res.keySize()));
        } else {
            Layer cur = join.from.next();
            while (!cur.equals((Object)join.to)) {
                res = JoinedMultiValueMap.join(res, this.getMap(cur));
                cur = cur.next();
            }
            if (dstLayer.equals((Object)join.from)) {
                res = res.invert();
            }
        }
        if (res instanceof JoinedMultiValueMap) {
            res = ((JoinedMultiValueMap)res).flatten();
        }
        this.cachedJoins.put(join, res);
        return res;
    }

    private MultiValueMap<Integer, Integer> getMap(Layer layer) {
        return this.maps[layer.ordinal()];
    }

    public static boolean isSplitReaction(Config config, MetabolicNetwork cmpNet, Reaction reaction) {
        return ReactionMapping.isSplitReaction(config, cmpNet, ReactionMapping.getOC(cmpNet).invert(), reaction, cmpNet.getReactionIndex(reaction.getName()));
    }

    private static boolean isSplitReaction(Config config, MetabolicNetwork cmpNet, IntIntMultiValueMap co, Reaction reaction, int reactionIndex) {
        MetabolicNetwork orgNet = ReactionMapping.getRootNetwork(cmpNet);
        if (reaction.getConstraints().isReversible()) {
            IntIterator it = co.get(reactionIndex).iterator();
            while (it.hasNext()) {
                int origIndex = it.nextInt();
                String origName = orgNet.getReactions().get(origIndex).getName();
                if (!Category.NoSplit.isMember(config, orgNet, origName)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getOriginalReactionIndexByName(String reactionName) {
        return ReactionMapping.getRootNetwork(this.cmpNet).getReactionIndex(reactionName);
    }

    public IntList getByOriginalReactionName(String reactionName, Layer dstLayer) {
        int index = this.getOriginalReactionIndexByName(reactionName);
        return this.get(Layer.Original, index, dstLayer);
    }

    private static MetabolicNetwork getRootNetwork(MetabolicNetwork cmpNet) {
        return cmpNet instanceof CompressedMetabolicNetwork ? ((CompressedMetabolicNetwork)cmpNet).getRootNetwork() : cmpNet;
    }

    public Category getReactionCategoryBySortedIndex(int sortedIndex) {
        return this.getReactionCategoryByExpandedIndex(this.sortMapping[sortedIndex]);
    }

    public Category getReactionCategoryByExpandedIndex(int expandedIndex) {
        MetabolicNetwork origNet = ReactionMapping.getRootNetwork(this.cmpNet);
        IntList origReacs = this.get(Layer.Expanded, expandedIndex, Layer.Original);
        Category cat = Category.Else;
        int i = 0;
        while (i < origReacs.size()) {
            int origIndex = origReacs.getInt(i);
            String origName = origNet.getReactions().get(origIndex).getName();
            cat = cat.getStronger(Category.find(this.config, origNet, origName));
            ++i;
        }
        return cat;
    }

    public boolean isReactionReversibleBySortedIndex(int sortedIndex) {
        int cmpIndex = this.getFirst(Layer.Sorted, sortedIndex, Layer.Compressed);
        return this.cmpNet.getReactions().get(cmpIndex).getConstraints().isReversible();
    }

    public int getSortedReactionIndexOfTwinPart(int sortedIndex) {
        int compressed = this.getFirst(Layer.Sorted, sortedIndex, Layer.Compressed);
        IntList sorted = this.get(Layer.Compressed, compressed, Layer.Sorted);
        if (sorted.size() != 2) {
            throw new IllegalArgumentException("not a split reversible reaction: " + sortedIndex);
        }
        int other = sorted.getInt(0);
        if (other == sortedIndex) {
            return sorted.getInt(1);
        }
        return other;
    }

    public <N extends Number, Col extends Column> N[] getUnexpandedFluxValues(ColumnHome<N, Col> columnHome, N[] expandedFluxValues) {
        IntIntMultiValueMap map = (IntIntMultiValueMap)SingleForwardMap.CE.map(this.maps);
        NumberOperations<N> ops = columnHome.getNumberOperations();
        Number[] unexpanded = ops.newArray(this.cmpNet.getReactions().length());
        int i = 0;
        while (i < unexpanded.length) {
            if (map.count(i) > 1) {
                IntIterator ixIt = map.get(i).iterator();
                int ixA = ixIt.nextInt();
                int ixB = ixIt.nextInt();
                if (ops.isZero(expandedFluxValues[ixB])) {
                    unexpanded[i] = expandedFluxValues[ixA];
                } else {
                    if (ops.isNonZero(expandedFluxValues[ixA])) {
                        throw new IllegalArgumentException("non-zero values for forward/backward reversible reaction [" + i + "]-->[" + ixA + ", " + ixB + "]: " + Arrays.toString(expandedFluxValues));
                    }
                    unexpanded[i] = ops.negate(expandedFluxValues[ixB]);
                }
            } else {
                unexpanded[i] = expandedFluxValues[map.getFirst(i)];
            }
            ++i;
        }
        return unexpanded;
    }

    public int getExpandedReactionCountOutOfIterationLoop() {
        HashSet<String> reacs = new HashSet<String>();
        reacs.addAll(this.config.getReactionsNoSplit());
        reacs.addAll(this.config.getReactionsToEnforce());
        for (Reaction reaction : ReactionMapping.getRootNetwork(this.cmpNet).getReactions()) {
            if (reacs.contains(reaction.getName()) || !reaction.getConstraints().isReversible() || this.config.getGenerator().splitReaction(reaction)) continue;
            reacs.add(reaction.getName());
        }
        BitSetIntSet bitSetIntSet = new BitSetIntSet();
        for (String reac : reacs) {
            int rind = ReactionMapping.getRootNetwork(this.cmpNet).getReactionIndex(reac);
            bitSetIntSet.addAll(this.get(Layer.Original, rind, Layer.Expanded));
        }
        return bitSetIntSet.size();
    }

    public static <N extends Number> ReadableMatrix<N> unsortExpandedStoichMatrixCols(ReadableMatrix<N> stoich, int[] sortMapping) {
        return ReactionMapping.unsortMatrix(stoich, sortMapping, false);
    }

    public static <N extends Number> ReadableMatrix<N> unsortKernelMatrixRows(ReadableMatrix<N> kn, int[] sortMapping) {
        return ReactionMapping.unsortMatrix(kn, sortMapping, true);
    }

    private static <N extends Number> ReadableMatrix<N> unsortMatrix(ReadableMatrix<N> kn, int[] sortMapping, boolean unsortRows) {
        WritableMatrix<N> mapped = kn.toWritableMatrix(true);
        int row = 0;
        while (row < sortMapping.length) {
            int dstRow = unsortRows ? sortMapping[row] : row;
            int col = 0;
            while (col < kn.getColumnCount()) {
                int dstCol = unsortRows ? col : sortMapping[col];
                N value = kn.getNumberValueAt(row, col);
                mapped.setValueAt(dstRow, dstCol, value);
                ++col;
            }
            ++row;
        }
        return mapped.toReadableMatrix(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Category {
        Suppress{

            public boolean isMember(Config config, MetabolicNetwork origNet, String name) {
                return config.getReactionsToSuppress().contains(name);
            }
        }
        ,
        NoSplit{

            public boolean isMember(Config config, MetabolicNetwork origNet, String name) {
                Reaction reac = origNet.getReaction(name);
                return config.getReactionsNoSplit().contains(name) || reac.getConstraints().isReversible() && !config.getGenerator().splitReaction(reac);
            }
        }
        ,
        Enforce{

            public boolean isMember(Config config, MetabolicNetwork metaNet, String name) {
                return config.getReactionsToEnforce().contains(name);
            }
        }
        ,
        Else{

            public boolean isMember(Config config, MetabolicNetwork metaNet, String name) {
                return true;
            }
        };


        public boolean isSpecial() {
            return this != Else;
        }

        public Category getStronger(Category other) {
            return other.ordinal() < this.ordinal() ? other : this;
        }

        public abstract boolean isMember(Config var1, MetabolicNetwork var2, String var3);

        public static Category find(Config config, MetabolicNetwork origNet, String name) {
            Category[] categoryArray = Category.values();
            int n = categoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Category o = categoryArray[n2];
                if (o.isMember(config, origNet, name)) {
                    return o;
                }
                ++n2;
            }
            throw new RuntimeException("internal error, Else should always accept");
        }
    }

    private static class Join {
        private final Layer from;
        private final Layer to;

        Join(Layer from, Layer to) {
            this.from = from.min(to);
            this.to = from.max(to);
        }

        public boolean isSingleLayer() {
            return this.from.equals((Object)this.to);
        }

        public int hashCode() {
            return this.from.hashCode() ^ this.to.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Join) {
                Join other = (Join)obj;
                return this.from.equals((Object)other.from) && this.to.equals((Object)other.to);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Layer {
        Original,
        Compressed,
        Expanded,
        Sorted;


        private Layer min(Layer other) {
            return this.ordinal() > other.ordinal() ? other : this;
        }

        private Layer max(Layer other) {
            return this.ordinal() < other.ordinal() ? other : this;
        }

        private Layer next() {
            return Layer.values()[this.ordinal() + 1];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SingleForwardMap {
        OC,
        CE,
        ES;


        public Layer sourceLayer() {
            return Layer.values()[this.ordinal()];
        }

        public Layer destinationLayer() {
            return Layer.values()[this.ordinal() + 1];
        }

        public MultiValueMap<Integer, Integer> map(MultiValueMap<Integer, Integer>[] maps) {
            return maps[this.ordinal()];
        }
    }
}

