/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.util;

import ch.javasoft.math.NumberOperations;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonicalUtil {
    public static double getInequalityValue(ReadableMatrix<Double> stoich, int row, double[] fluxVals, int[] stoichColumnSorting) {
        double sum = 0.0;
        if (stoich instanceof ReadableDoubleMatrix) {
            ReadableDoubleMatrix dblMx = (ReadableDoubleMatrix)stoich;
            int i = 0;
            while (i < fluxVals.length) {
                int stoichCol = stoichColumnSorting[i];
                sum += fluxVals[i] * dblMx.getDoubleValueAt(row, stoichCol);
                ++i;
            }
        } else {
            int i = 0;
            while (i < fluxVals.length) {
                int stoichCol = stoichColumnSorting[i];
                sum += fluxVals[i] * stoich.getNumberValueAt(row, stoichCol);
                ++i;
            }
        }
        return sum;
    }

    public static <N extends Number> N getInequalityValue(ReadableMatrix<N> stoich, int row, N[] fluxVals, int[] stoichColumnSorting) {
        NumberOperations numOps = stoich.getNumberOperations();
        Object sum = numOps.zero();
        int i = 0;
        while (i < fluxVals.length) {
            int stoichCol = stoichColumnSorting[i];
            sum = numOps.add(sum, numOps.multiply(fluxVals[i], stoich.getNumberValueAt(row, stoichCol)));
            ++i;
        }
        return sum;
    }

    private CanonicalUtil() {
    }
}

