/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.tree.concurrent;

import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.concurrent.ConcurrentToken;
import ch.javasoft.metabolic.efm.concurrent.ThreadFinalizer;
import ch.javasoft.metabolic.efm.concurrent.TimeoutWaitingReleasePolicy;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.tree.BitPatternTree;
import ch.javasoft.metabolic.efm.tree.InterNode;
import ch.javasoft.metabolic.efm.tree.LeafNode;
import ch.javasoft.metabolic.efm.tree.Node;
import ch.javasoft.metabolic.efm.tree.TreePairTraverser;
import ch.javasoft.util.ExceptionUtil;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobQueue<T extends ConcurrentToken> {
    private final TreePairTraverser<T> traverser;
    private final T token;
    private final ConcurrentLinkedQueue<Callable<Void>> queue;

    public JobQueue(TreePairTraverser<T> traverser, T token) {
        this.traverser = traverser;
        this.token = token;
        this.queue = new ConcurrentLinkedQueue();
    }

    public static <Tok extends ConcurrentToken, Col extends Column, N extends Number> boolean execThreaded(Config config, ColumnHome<N, Col> columnHome, Tok token, int myDepth, int otherDepth, TreePairTraverser<Tok> traverser, AdjEnumModel<Col> itModel, ThreadFinalizer threadFinalizer, boolean meIsPos, Node me, Node other) throws IOException {
        int threadCount = token.drainPermits();
        if (threadCount > 0) {
            JobQueue<Tok> queue = new JobQueue<Tok>(traverser, token);
            queue.addJobsToQueue(columnHome, itModel, token, myDepth, otherDepth, meIsPos, me, other);
            try {
                super.exec(config, threadCount, threadFinalizer);
            }
            catch (Exception e) {
                throw ExceptionUtil.toRuntimeExceptionOr(IOException.class, e);
            }
            return true;
        }
        return false;
    }

    private <I> void exec(Config config, int threadCount, ThreadFinalizer threadFinalizer) throws Exception {
        this.startChildThreads(config, threadCount, threadFinalizer);
        this.execParentThread();
    }

    private <I> void startChildThreads(Config config, int threadCount, ThreadFinalizer threadFinalizer) {
        final TimeoutWaitingReleasePolicy releasePolicy = new TimeoutWaitingReleasePolicy();
        releasePolicy.initialize(config, 4 << new Level().maxlevelDepth, threadCount);
        int i = 0;
        while (i < threadCount) {
            this.token.createChildThread(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    JobQueue.this.execQueuedJobsByCurrentThread();
                    releasePolicy.releasePermit(JobQueue.this.token);
                    return null;
                }
            }, threadFinalizer).start();
            ++i;
        }
    }

    private void execQueuedJobsByCurrentThread() throws Exception {
        Callable<Void> job = this.queue.poll();
        while (job != null) {
            job.call();
            job = this.queue.poll();
        }
    }

    private void execParentThread() throws Exception {
        this.execQueuedJobsByCurrentThread();
    }

    protected <C extends Column, N extends Number> void addJobsToQueue(ColumnHome<N, C> columnHome, AdjEnumModel<C> itModel, T token, int myDepth, int otherDepth, boolean meIsPos, Node me, Node other) throws IOException {
        new JobCollector().traverseNN(columnHome, itModel, new Level(), myDepth, otherDepth, meIsPos, me, other);
    }

    private <C extends Column, N extends Number> void addJobToQueue(final ColumnHome<N, C> columnHome, final TreePairTraverser<T> traverser, final AdjEnumModel<C> itModel, final T token, final int myDepth, final int otherDepth, final boolean meIsPos, final Node me, final Node other) {
        this.queue.add(new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                me.traverseN(traverser, columnHome, itModel, token, myDepth, otherDepth, meIsPos, other);
                return null;
            }
        });
    }

    private void checkAndNotifyProgress(final T token, final int curProgress, int childProgress) {
        if (!token.isProgressIncrementNotifiable(childProgress)) {
            this.queue.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    token.notifyProgressIncrement(curProgress);
                    return null;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JobCollector
    implements TreePairTraverser<Level> {
        private JobCollector() {
        }

        @Override
        public <Col extends Column, N extends Number> void traverse(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, Level token, BitPatternTree posTree, BitPatternTree negTree) throws IOException {
            posTree.root().traverseN(this, columnHome, iterationModel, token, 0, 0, true, negTree.root());
        }

        @Override
        public <C extends Column, N extends Number> void traverseNN(ColumnHome<N, C> columnHome, AdjEnumModel<C> itModel, Level levelToken, int myDepth, int otherDepth, boolean meIsPos, Node me, Node other) throws IOException {
            me.traverseN(this, columnHome, itModel, levelToken, myDepth, otherDepth, meIsPos, other);
        }

        @Override
        public <C extends Column, N extends Number> void traverseIN(ColumnHome<N, C> columnHome, AdjEnumModel<C> itModel, Level levelToken, int myDepth, int otherDepth, boolean meIsPos, InterNode me, Node other) throws IOException {
            other.traverseI(this, columnHome, itModel, levelToken, myDepth, otherDepth, !meIsPos, me);
        }

        @Override
        public <C extends Column, N extends Number> void traverseLN(ColumnHome<N, C> columnHome, AdjEnumModel<C> itModel, Level levelToken, int myDepth, int otherDepth, boolean meIsPos, LeafNode me, Node other) throws IOException {
            other.traverseL(this, columnHome, itModel, levelToken, myDepth, otherDepth, !meIsPos, me);
        }

        @Override
        public <C extends Column, N extends Number> void traverseII(ColumnHome<N, C> columnHome, AdjEnumModel<C> itModel, Level levelToken, int myDepth, int otherDepth, boolean meIsPos, InterNode me, InterNode other) throws IOException {
            if (levelToken.level < levelToken.maxlevelDepth) {
                ++levelToken.level;
                this.traverseNN(columnHome, itModel, levelToken, myDepth + 1, otherDepth + 1, meIsPos, me.left(), other.left());
                this.traverseNN(columnHome, itModel, levelToken, myDepth + 1, otherDepth + 1, meIsPos, me.left(), other.right());
                this.traverseNN(columnHome, itModel, levelToken, myDepth + 1, otherDepth + 1, meIsPos, me.right(), other.left());
                this.traverseNN(columnHome, itModel, levelToken, myDepth + 1, otherDepth + 1, meIsPos, me.right(), other.right());
                JobQueue.this.checkAndNotifyProgress(JobQueue.this.token, myDepth + otherDepth, myDepth + otherDepth + 2);
                --levelToken.level;
            } else {
                JobQueue.this.addJobToQueue(columnHome, JobQueue.this.traverser, itModel, JobQueue.this.token, myDepth, otherDepth, meIsPos, me, other);
            }
        }

        @Override
        public <C extends Column, N extends Number> void traverseIL(ColumnHome<N, C> columnHome, AdjEnumModel<C> itModel, Level levelToken, int myDepth, int otherDepth, boolean meIsPos, InterNode me, LeafNode other) throws IOException {
            if (levelToken.level < levelToken.maxlevelDepth) {
                ++levelToken.level;
                this.traverseLN(columnHome, itModel, levelToken, otherDepth, myDepth + 1, !meIsPos, other, me.left());
                this.traverseLN(columnHome, itModel, levelToken, otherDepth, myDepth + 1, !meIsPos, other, me.right());
                JobQueue.this.checkAndNotifyProgress(JobQueue.this.token, myDepth + otherDepth, myDepth + otherDepth + 1);
                --levelToken.level;
            } else {
                JobQueue.this.addJobToQueue(columnHome, JobQueue.this.traverser, itModel, JobQueue.this.token, myDepth, otherDepth, meIsPos, me, other);
            }
        }

        @Override
        public <C extends Column, N extends Number> void traverseLL(ColumnHome<N, C> columnHome, AdjEnumModel<C> itModel, Level levelToken, int myDepth, int otherDepth, boolean meIsPos, LeafNode me, LeafNode other) throws IOException {
            JobQueue.this.addJobToQueue(columnHome, JobQueue.this.traverser, itModel, JobQueue.this.token, myDepth, otherDepth, meIsPos, me, other);
        }
    }

    private static class Level {
        final int maxlevelDepth = 6;
        int level;

        private Level() {
        }
    }
}

