/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.tree.concurrent;

import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.concurrent.ConcurrentToken;
import ch.javasoft.metabolic.efm.concurrent.ThreadFinalizer;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.tree.AdjacencyFilter;
import ch.javasoft.metabolic.efm.tree.AdjacencyPrecondition;
import ch.javasoft.metabolic.efm.tree.BitPatternTree;
import ch.javasoft.metabolic.efm.tree.InterNode;
import ch.javasoft.metabolic.efm.tree.LeafNode;
import ch.javasoft.metabolic.efm.tree.Node;
import ch.javasoft.metabolic.efm.tree.TreeTraverser;
import ch.javasoft.metabolic.efm.tree.concurrent.JobQueue;
import ch.javasoft.metabolic.efm.tree.impl.DefaultTreeTraverser;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentTreeTraverser<T extends ConcurrentToken>
extends DefaultTreeTraverser<T> {
    private final ThreadFinalizer threadFinalizer;

    public ConcurrentTreeTraverser(EfmModel efmModel, AdjacencyPrecondition<T> precondition, AdjacencyFilter<T> filter, final AdjEnumModel itModel, final BitPatternTree posTree, final BitPatternTree negTree) {
        super(efmModel, precondition, filter);
        this.threadFinalizer = new ThreadFinalizer(){

            public void finalizeCurrentThread() throws Exception {
                itModel.closeForThread();
                posTree.closeForCurrentThread();
                negTree.closeForCurrentThread();
            }
        };
    }

    @Override
    public <Col extends Column, N extends Number> void traverseII(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> itModel, T token, int myDepth, int otherDepth, boolean meIsPos, InterNode me, InterNode other) throws IOException {
        if (!JobQueue.execThreaded((Config)this.efmModel.getConfig(), columnHome, token, (int)myDepth, (int)otherDepth, (TreeTraverser)this, itModel, (ThreadFinalizer)this.threadFinalizer, (boolean)meIsPos, (Node)me, (Node)other)) {
            this.traverseNN(columnHome, itModel, (ConcurrentToken)token, myDepth + 1, otherDepth + 1, meIsPos, me.left(), other.left());
            this.traverseNN(columnHome, itModel, (ConcurrentToken)token, myDepth + 1, otherDepth + 1, meIsPos, me.left(), other.right());
            this.traverseNN(columnHome, itModel, (ConcurrentToken)token, myDepth + 1, otherDepth + 1, meIsPos, me.right(), other.left());
            this.traverseNN(columnHome, itModel, (ConcurrentToken)token, myDepth + 1, otherDepth + 1, meIsPos, me.right(), other.right());
            this.checkAndNotifyProgress(token, myDepth + otherDepth, myDepth + otherDepth + 2);
        }
    }

    @Override
    public <Col extends Column, N extends Number> void traverseIL(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> itModel, T token, int myDepth, int otherDepth, boolean meIsPos, InterNode me, LeafNode other) throws IOException {
        if (!JobQueue.execThreaded((Config)this.efmModel.getConfig(), columnHome, token, (int)myDepth, (int)otherDepth, (TreeTraverser)this, itModel, (ThreadFinalizer)this.threadFinalizer, (boolean)meIsPos, (Node)me, (Node)other)) {
            this.traverseLN(columnHome, itModel, token, otherDepth, myDepth + 1, !meIsPos, other, me.left());
            this.traverseLN(columnHome, itModel, token, otherDepth, myDepth + 1, !meIsPos, other, me.right());
            this.checkAndNotifyProgress(token, myDepth + otherDepth, myDepth + otherDepth + 1);
        }
    }

    private void checkAndNotifyProgress(T token, int curProgress, int childProgress) throws IOException {
        if (!token.isProgressIncrementNotifiable(childProgress)) {
            token.notifyProgressIncrement(curProgress);
        }
    }
}

