/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.sort;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.sort.AbsLexMinSorter;
import ch.javasoft.metabolic.efm.sort.CascadingSorter;
import ch.javasoft.metabolic.efm.sort.FewestNegPosSorter;
import ch.javasoft.metabolic.efm.sort.LexMinSorter;
import ch.javasoft.metabolic.efm.sort.LogPkg;
import ch.javasoft.metabolic.efm.sort.MatrixSorter;
import ch.javasoft.metabolic.efm.sort.MostZerosSorter;
import ch.javasoft.metabolic.efm.sort.SuppressedEnforcedNoSplitSorter;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.smx.ops.Hsl;
import ch.javasoft.smx.ops.HslGateway;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.IntArray;
import ch.javasoft.util.logging.LogPrintWriter;
import ch.javasoft.util.numeric.Zero;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortUtil {
    private static File traceSortingFile;
    public static final String DEFAULT_SORTER = "MostZerosOrAbsLexMin";
    private static final Logger LOG;

    static {
        LOG = LogPkg.LOGGER;
    }

    public static void setTraceSortingFile(File file) {
        traceSortingFile = file;
    }

    public static <M extends ReadableDoubleMatrix & WritableMatrix> void sortKernel(M kernel, int[] rowMapping, MetabolicNetwork net, Config config) {
        SortUtil.sortMatrix(kernel, rowMapping, kernel.getColumnCount(), kernel.getRowCount(), false, net, config);
        if (traceSortingFile != null) {
            try {
                kernel.writeToMultiline(new FileWriter(traceSortingFile));
            }
            catch (IOException e) {
                throw new RuntimeException("cannot trace row sorting, e=" + e, e);
            }
        }
    }

    public static <M extends ReadableDoubleMatrix & WritableMatrix> void sortStoich(M stoich, int startRow, int[] rowMapping, MetabolicNetwork net, Config config) {
        SortUtil.sortMatrix(stoich, rowMapping, startRow, stoich.getRowCount(), false, net, config);
        if (traceSortingFile != null) {
            try {
                stoich.writeToMultiline(new FileWriter(traceSortingFile));
            }
            catch (IOException e) {
                throw new RuntimeException("cannot trace row sorting, e=" + e, e);
            }
        }
    }

    private static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrix(M kernel, int[] rowMapping, int startRow, int endRow, boolean reverse, MetabolicNetwork net, Config config) {
        String rowOrdering = config.getRowOrdering();
        SortUtil.sortMatrix(kernel, rowMapping, startRow, endRow, reverse, net, config, rowOrdering);
    }

    private static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrix(M kernel, int[] rowMapping, int startRow, int endRow, boolean reverse, MetabolicNetwork net, Config config, String rowOrdering) {
        if (rowOrdering.startsWith("Fixed:")) {
            SortUtil.sortMatrixFixed(kernel, rowMapping, startRow, endRow, reverse, rowOrdering.substring("Fixed:".length()), net, config);
        } else {
            try {
                Class[] signature = new Class[]{ReadableDoubleMatrix.class, int[].class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, MetabolicNetwork.class, Config.class};
                Object[] args = new Object[]{kernel, rowMapping, startRow, endRow, reverse, net, config};
                Method method = SortUtil.class.getDeclaredMethod("sortMatrix" + rowOrdering, signature);
                method.invoke(null, args);
            }
            catch (Exception ex) {
                LOG.severe("cannot use row-ordering '" + rowOrdering + "', e=" + ex);
                ex.printStackTrace(new LogPrintWriter(LOG, Level.SEVERE));
                LOG.severe("defaulting to row ordering MostZerosOrAbsLexMin.");
                SortUtil.sortMatrixMostZerosOrAbsLexMin(kernel, rowMapping, startRow, endRow, reverse, net, config);
            }
        }
    }

    private static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrixFixed(M kernel, int[] rowMapping, int startRow, int endRow, boolean reverse, String fixedOrdering, MetabolicNetwork net, Config config) {
        int colon1 = fixedOrdering.indexOf(58);
        int colon2 = fixedOrdering.indexOf(58, colon1 + 1);
        int indexBase = Integer.parseInt(fixedOrdering.substring(0, colon1));
        String refSort = fixedOrdering.substring(colon1 + 1, colon2);
        SortUtil.sortMatrix(kernel, rowMapping, startRow, endRow, reverse, net, config, refSort);
        String[] fix = fixedOrdering.substring(colon2 + 1).split(":");
        if (endRow - startRow != fix.length) {
            throw new IllegalArgumentException("expected ordering string with " + (endRow - startRow) + " elements, but found " + fix.length);
        }
        int[] fwdMapping = new int[rowMapping.length];
        int[] bwdMapping = new int[rowMapping.length];
        int i = 0;
        while (i < rowMapping.length) {
            fwdMapping[i] = i;
            bwdMapping[i] = i;
            ++i;
        }
        i = startRow;
        while (i < endRow - 1) {
            int fi = startRow + Integer.parseInt(fix[i - startRow]) - indexBase;
            int bfi = bwdMapping[fi];
            int mi = fwdMapping[i];
            int mbfi = fi;
            if (i != bfi) {
                ((WritableMatrix)kernel).swapRows(i, bfi);
                IntArray.swap(rowMapping, i, bfi);
                IntArray.swap(fwdMapping, i, bfi);
                IntArray.swap(bwdMapping, mi, mbfi);
            }
            ++i;
        }
    }

    private static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrixMonet(M kernel, int[] rowMapping, int startRow, int endRow, boolean reverse, MetabolicNetwork net, Config config) {
        int mbfi;
        int mi;
        int bfi;
        int fi;
        int nblocks = 2;
        int cols = kernel.getColumnCount();
        IntArray irn = new IntArray();
        IntArray jcn = new IntArray();
        int i = startRow;
        while (i < endRow) {
            int j = 0;
            while (j < cols) {
                if (kernel.getSignumAt(i, j) != 0) {
                    jcn.add(i - startRow + 1);
                    irn.add(j + 1);
                }
                ++j;
            }
            ++i;
        }
        Hsl.Result_mc66 sort66 = HslGateway.callMc66(cols, endRow - startRow, irn.toArray(), jcn.toArray(), 2);
        int[] fwdMapping = new int[rowMapping.length];
        int[] bwdMapping = new int[rowMapping.length];
        int i2 = 0;
        while (i2 < rowMapping.length) {
            fwdMapping[i2] = i2;
            bwdMapping[i2] = i2;
            ++i2;
        }
        i2 = startRow;
        while (i2 < endRow - 1) {
            fi = startRow + sort66.column_order[i2 - startRow] - 1;
            bfi = bwdMapping[fi];
            mi = fwdMapping[i2];
            mbfi = fi;
            if (i2 != bfi) {
                ((WritableMatrix)kernel).swapRows(i2, bfi);
                IntArray.swap(rowMapping, i2, bfi);
                IntArray.swap(fwdMapping, i2, bfi);
                IntArray.swap(bwdMapping, mi, mbfi);
            }
            ++i2;
        }
        fwdMapping = new int[cols];
        bwdMapping = new int[cols];
        i2 = 0;
        while (i2 < cols) {
            fwdMapping[i2] = i2;
            bwdMapping[i2] = i2;
            ++i2;
        }
        i2 = 0;
        while (i2 < cols - 1) {
            fi = sort66.row_order[i2] - 1;
            bfi = bwdMapping[fi];
            mi = fwdMapping[i2];
            mbfi = fi;
            if (i2 != bfi) {
                ((WritableMatrix)kernel).swapColumns(i2, bfi);
                IntArray.swap(fwdMapping, i2, bfi);
                IntArray.swap(bwdMapping, mi, mbfi);
            }
            ++i2;
        }
    }

    public static void main(String[] args) {
        int endRow = 6;
        int startRow = 0;
        String[] fix = "1:2:5:3:0:4".split(":");
        if (endRow - startRow != fix.length) {
            throw new IllegalArgumentException("expected ordering string with " + (endRow - startRow) + " elements, but found " + fix.length);
        }
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        int[] rowMapping = nArray;
        int[] backMapping = new int[rowMapping.length];
        int i = 0;
        while (i < rowMapping.length) {
            backMapping[rowMapping[i]] = i;
            ++i;
        }
        i = startRow;
        while (i < endRow - 1) {
            int fi = Integer.parseInt(fix[i]);
            int bfi = backMapping[fi];
            int mi = rowMapping[i];
            int mbfi = fi;
            if (i != bfi) {
                IntArray.swap(rowMapping, i, bfi);
                IntArray.swap(backMapping, mi, mbfi);
            }
            ++i;
        }
        System.out.println(java.util.Arrays.toString(rowMapping));
        System.out.println(java.util.Arrays.toString(backMapping));
    }

    private static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrixMostZerosOrAbsLexMin(M kernel, int[] rowMapping, int startRow, int endRow, boolean reverse, MetabolicNetwork net, Config config) {
        int cols = kernel.getColumnCount();
        SortUtil.sortMatrix(kernel, rowMapping, rowMapping == null ? new CascadingSorter(new MostZerosSorter(true, startRow, endRow, 0, cols, new Zero()), new AbsLexMinSorter(true, startRow, endRow, 0, cols)) : new CascadingSorter(new SuppressedEnforcedNoSplitSorter(net, config, rowMapping, startRow, endRow), new MostZerosSorter(true, startRow, endRow, 0, cols, new Zero()), new AbsLexMinSorter(true, startRow, endRow, 0, cols)), reverse, null, false);
    }

    private static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrixRandom(M kernel, int[] rowMapping, int startRow, int endRow, boolean reverse, MetabolicNetwork net, Config config) {
        IntArray arr = new IntArray(endRow - startRow);
        int i = startRow;
        while (i < endRow) {
            arr.add(i);
            ++i;
        }
        i = startRow;
        while (i < endRow) {
            int arrIndex = (int)(Math.random() * (double)arr.length());
            int rowIndex = arr.get(arrIndex);
            if (i != rowIndex) {
                ((WritableMatrix)kernel).swapRows(i, rowIndex);
                Arrays.swap(rowMapping, i, rowIndex);
            }
            int lastValue = arr.removeLast();
            if (arrIndex != arr.length()) {
                arr.set(arrIndex, lastValue);
            }
            ++i;
        }
        if (rowMapping != null) {
            SortUtil.sortMatrix(kernel, rowMapping, new SuppressedEnforcedNoSplitSorter(net, config, rowMapping, startRow, endRow), reverse, null, false);
        }
    }

    private static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrixMostZeros(M kernel, int[] rowMapping, int startRow, int endRow, boolean reverse, MetabolicNetwork net, Config config) {
        int cols = kernel.getColumnCount();
        SortUtil.sortMatrix(kernel, rowMapping, new CascadingSorter(new SuppressedEnforcedNoSplitSorter(net, config, rowMapping, startRow, endRow), new MostZerosSorter(true, startRow, endRow, 0, cols, new Zero())), reverse, null, false);
    }

    private static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrixFewestNegPos(M kernel, int[] rowMapping, int startRow, int endRow, boolean reverse, MetabolicNetwork net, Config config) {
        int cols = kernel.getColumnCount();
        Zero zero = new Zero();
        SortUtil.sortMatrix(kernel, rowMapping, rowMapping == null ? new CascadingSorter(new FewestNegPosSorter(true, startRow, endRow, 0, cols, zero)) : new CascadingSorter(new SuppressedEnforcedNoSplitSorter(net, config, rowMapping, startRow, endRow), new FewestNegPosSorter(true, startRow, endRow, 0, cols, zero)), reverse, null, false);
    }

    private static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrixAbsLexMin(M kernel, int[] rowMapping, int startRow, int endRow, boolean reverse, MetabolicNetwork net, Config config) {
        int cols = kernel.getColumnCount();
        SortUtil.sortMatrix(kernel, rowMapping, rowMapping == null ? new CascadingSorter(new AbsLexMinSorter(true, startRow, endRow, 0, cols)) : new CascadingSorter(new SuppressedEnforcedNoSplitSorter(net, config, rowMapping, startRow, endRow), new AbsLexMinSorter(true, startRow, endRow, 0, cols)), reverse, null, false);
    }

    private static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrixLexMin(M kernel, int[] rowMapping, int startRow, int endRow, boolean reverse, MetabolicNetwork net, Config config) {
        int cols = kernel.getColumnCount();
        SortUtil.sortMatrix(kernel, rowMapping, rowMapping == null ? new CascadingSorter(new LexMinSorter(true, startRow, endRow, 0, cols)) : new CascadingSorter(new SuppressedEnforcedNoSplitSorter(net, config, rowMapping, startRow, endRow), new LexMinSorter(true, startRow, endRow, 0, cols)), reverse, null, false);
    }

    private static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrixMostZerosOrFewestNegPos(M kernel, int[] rowMapping, int startRow, int endRow, boolean reverse, MetabolicNetwork net, Config config) {
        int cols = kernel.getColumnCount();
        Zero zero = new Zero();
        SortUtil.sortMatrix(kernel, rowMapping, rowMapping == null ? new CascadingSorter(new MostZerosSorter(true, startRow, endRow, 0, cols, zero), new FewestNegPosSorter(true, startRow, endRow, 0, cols, zero)) : new CascadingSorter(new SuppressedEnforcedNoSplitSorter(net, config, rowMapping, startRow, endRow), new MostZerosSorter(true, startRow, endRow, 0, cols, zero), new FewestNegPosSorter(true, startRow, endRow, 0, cols, zero)), reverse, null, false);
    }

    private static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrixMostZerosOrLexMin(M kernel, int[] rowMapping, int startRow, int endRow, boolean reverse, MetabolicNetwork net, Config config) {
        int cols = kernel.getColumnCount();
        SortUtil.sortMatrix(kernel, rowMapping, rowMapping == null ? new CascadingSorter(new MostZerosSorter(true, startRow, endRow, 0, cols, new Zero()), new LexMinSorter(true, startRow, endRow, 0, cols)) : new CascadingSorter(new SuppressedEnforcedNoSplitSorter(net, config, rowMapping, startRow, endRow), new MostZerosSorter(true, startRow, endRow, 0, cols, new Zero()), new LexMinSorter(true, startRow, endRow, 0, cols)), reverse, null, false);
    }

    private static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrixFewestNegPosOrMostZeros(M kernel, int[] rowMapping, int startRow, int endRow, boolean reverse, MetabolicNetwork net, Config config) {
        int cols = kernel.getColumnCount();
        Zero zero = new Zero();
        SortUtil.sortMatrix(kernel, rowMapping, rowMapping == null ? new CascadingSorter(new FewestNegPosSorter(true, startRow, endRow, 0, cols, zero), new MostZerosSorter(true, startRow, endRow, 0, cols, zero)) : new CascadingSorter(new SuppressedEnforcedNoSplitSorter(net, config, rowMapping, startRow, endRow), new FewestNegPosSorter(true, startRow, endRow, 0, cols, zero), new MostZerosSorter(true, startRow, endRow, 0, cols, zero)), reverse, null, false);
    }

    private static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrixFewestNegPosOrAbsLexMin(M kernel, int[] rowMapping, int startRow, int endRow, boolean reverse, MetabolicNetwork net, Config config) {
        int cols = kernel.getColumnCount();
        Zero zero = new Zero();
        SortUtil.sortMatrix(kernel, rowMapping, rowMapping == null ? new CascadingSorter(new FewestNegPosSorter(true, startRow, endRow, 0, cols, zero), new AbsLexMinSorter(true, startRow, endRow, 0, cols)) : new CascadingSorter(new SuppressedEnforcedNoSplitSorter(net, config, rowMapping, startRow, endRow), new FewestNegPosSorter(true, startRow, endRow, 0, cols, zero), new AbsLexMinSorter(true, startRow, endRow, 0, cols)), reverse, null, false);
    }

    private static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrix(M kernel, int[] rowMapping, MatrixSorter rowSorter, boolean reverseRows, MatrixSorter colSorter, boolean reverseCols) {
        if (colSorter != null) {
            SortUtil.sortMatrixColumns(kernel, null, colSorter, reverseCols);
        }
        if (rowSorter != null) {
            SortUtil.sortMatrixRows(kernel, rowMapping, rowSorter, reverseRows);
        }
    }

    public static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrixRows(M mx, int[] mapping, MatrixSorter rowSorter, boolean reverse) {
        if (rowSorter != null) {
            double rev;
            double d = rev = reverse ? -1.0 : 1.0;
            if (!rowSorter.compareRows()) {
                throw new IllegalArgumentException("not a row sorter");
            }
            int rows = rowSorter.end(mx);
            int pivotRow = rowSorter.start(mx);
            while (pivotRow < rows) {
                int minRow = pivotRow;
                int row = pivotRow + 1;
                while (row < rows) {
                    if (rev * (double)rowSorter.compare(mx, minRow, row) > 0.0) {
                        minRow = row;
                    }
                    ++row;
                }
                if (minRow != pivotRow) {
                    ((WritableMatrix)mx).swapRows(minRow, pivotRow);
                    if (mapping != null) {
                        int tmp = mapping[minRow];
                        mapping[minRow] = mapping[pivotRow];
                        mapping[pivotRow] = tmp;
                    }
                }
                ++pivotRow;
            }
        }
    }

    public static <M extends ReadableDoubleMatrix & WritableMatrix> void sortMatrixColumns(M mx, int[] mapping, MatrixSorter colSorter, boolean reverse) {
        if (colSorter != null) {
            double rev;
            double d = rev = reverse ? -1.0 : 1.0;
            if (colSorter.compareRows()) {
                throw new IllegalArgumentException("not a col sorter");
            }
            int cols = colSorter.end(mx);
            int pivotCol = colSorter.start(mx);
            while (pivotCol < cols) {
                int minCol = pivotCol;
                int col = pivotCol + 1;
                while (col < cols) {
                    if (rev * (double)colSorter.compare(mx, minCol, col) > 0.0) {
                        minCol = col;
                    }
                    ++col;
                }
                if (minCol != pivotCol) {
                    ((WritableMatrix)mx).swapColumns(minCol, pivotCol);
                    if (mapping != null) {
                        int tmp = mapping[minCol];
                        mapping[minCol] = mapping[pivotCol];
                        mapping[pivotCol] = tmp;
                    }
                }
                ++pivotCol;
            }
        }
    }
}

