/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.progress;

import ch.javasoft.metabolic.efm.progress.ProgressAggregator;
import ch.javasoft.metabolic.efm.progress.ProgressMonitor;
import ch.javasoft.metabolic.efm.progress.ProgressNotifiable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class IntProgressAggregator
implements ProgressAggregator {
    private final int smallestIncrement;
    private final AtomicInteger progress;
    private final ProgressNotifiable aggregateNotifiable;
    private final int aggregateShift;

    public IntProgressAggregator(ProgressNotifiable aggregateMonitor) {
        this(aggregateMonitor, 30);
    }

    public IntProgressAggregator(ProgressNotifiable aggregateMonitor, int smallestIncrement) {
        if (smallestIncrement < 0 || smallestIncrement > 30) {
            throw new IllegalArgumentException("smallest increment must be in [0, 30], but is " + smallestIncrement);
        }
        if (aggregateMonitor.getSmallestIncrement() >= smallestIncrement) {
            throw new IllegalArgumentException("smallest increment of aggregate most be larger than increment of aggregator, i.e. exponent must be smaller");
        }
        this.smallestIncrement = smallestIncrement;
        this.progress = new AtomicInteger(0);
        this.aggregateNotifiable = aggregateMonitor;
        this.aggregateShift = smallestIncrement - aggregateMonitor.getSmallestIncrement();
    }

    /*
     * Unable to fully structure code
     */
    public void updateProgress(int e) throws IOException, IllegalArgumentException {
        block5: {
            block6: {
                if (e > this.smallestIncrement) {
                    throw new IllegalArgumentException("progress increment too small, i.e. e > " + this.smallestIncrement + ": " + e);
                }
                if (e < 0) {
                    throw new IllegalArgumentException("negative progress increment: " + e);
                }
                add = 1 << this.smallestIncrement - e;
                while (!this.progress.compareAndSet(old = this.progress.get(), upd = old + add)) {
                }
                aggOld = old >>> this.aggregateShift;
                aggUpd = upd >>> this.aggregateShift;
                if (aggOld == aggUpd) break block5;
                if (!(this.aggregateNotifiable instanceof ProgressMonitor)) break block6;
                ((ProgressMonitor)this.aggregateNotifiable).notifyProgress((double)upd / (double)(1 << this.smallestIncrement));
                break block5;
            }
            if (!(this.aggregateNotifiable instanceof ProgressAggregator)) break block5;
            agg = (ProgressAggregator)this.aggregateNotifiable;
            aggE = this.aggregateNotifiable.getSmallestIncrement();
            aggDiff = aggUpd - aggOld;
            ** GOTO lbl26
            {
                aggDiff >>>= 1;
                --aggE;
                do {
                    if (aggDiff % 2 == 0) continue block1;
                    aggDiff >>>= 1;
                    agg.updateProgress(aggE);
lbl26:
                    // 2 sources

                } while (aggDiff > 0);
            }
        }
    }

    public final int getSmallestIncrement() {
        return this.smallestIncrement;
    }

    public void close() throws IOException {
        this.aggregateNotifiable.close();
    }

    public double getProgress() {
        return this.progress.doubleValue() / (double)(1 << this.smallestIncrement);
    }
}

