/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.output.mat;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.output.AbstractFormattedOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputFormatter;
import ch.javasoft.metabolic.efm.output.OutputMode;
import ch.javasoft.metabolic.efm.output.mat.DefaultPartitionedMatFileWriter;
import ch.javasoft.metabolic.efm.output.mat.LogPkg;
import ch.javasoft.metabolic.efm.output.mat.MatFileOutputFormatter;
import ch.javasoft.metabolic.efm.output.mat.PartitionedMatFileWriter;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatFileOutputCallback
extends AbstractFormattedOutputCallback<PartitionedMatFileWriter> {
    public static final String STRUCT_NAME = "mnet";

    public MatFileOutputCallback(MetabolicNetwork originalNetwork, File folder, String fileName) throws IOException {
        this(OutputMode.DoubleUncompressed, originalNetwork, folder, fileName);
    }

    public MatFileOutputCallback(MetabolicNetwork originalNetwork, File folder, String fileName, long efmsPerPart) throws IOException {
        this(OutputMode.DoubleUncompressed, originalNetwork, folder, fileName, efmsPerPart);
    }

    public MatFileOutputCallback(OutputMode mode, MetabolicNetwork originalNetwork, File folder, String fileName) throws IOException {
        this(mode, new MatFileOutputFormatter(originalNetwork), MatFileOutputCallback.createPartitionedMatFileWriter(originalNetwork, mode, folder, fileName));
    }

    public MatFileOutputCallback(OutputMode mode, MetabolicNetwork originalNetwork, File folder, String fileName, long efmsPerPart) throws IOException {
        this(mode, new MatFileOutputFormatter(originalNetwork), MatFileOutputCallback.createPartitionedMatFileWriter(originalNetwork, mode, folder, fileName, efmsPerPart));
    }

    public MatFileOutputCallback(OutputMode mode, EfmOutputFormatter<PartitionedMatFileWriter> formatter, PartitionedMatFileWriter writer) {
        super(mode, formatter, writer);
    }

    @Override
    public boolean allowLoggingDuringOutput() {
        return true;
    }

    private static PartitionedMatFileWriter createPartitionedMatFileWriter(MetabolicNetwork originalNetwork, OutputMode mode, File folder, String fileName) {
        long estimate = MatFileOutputCallback.estimateEfmsPerPart(originalNetwork, mode);
        LogPkg.LOGGER.info("estimated efms-per-file: " + estimate);
        return new DefaultPartitionedMatFileWriter(folder, fileName, estimate);
    }

    private static PartitionedMatFileWriter createPartitionedMatFileWriter(MetabolicNetwork originalNetwork, OutputMode mode, File folder, String fileName, long efmsPerPart) {
        MatFileOutputCallback.checkEfmsPerPart(originalNetwork, mode, efmsPerPart);
        return new DefaultPartitionedMatFileWriter(folder, fileName, efmsPerPart);
    }

    private static void checkEfmsPerPart(MetabolicNetwork originalNetwork, OutputMode mode, long efmsPerPart) {
        long estimate = MatFileOutputCallback.estimateEfmsPerPart(originalNetwork, mode);
        LogPkg.LOGGER.info("estimated efms-per-file: " + estimate);
        LogPkg.LOGGER.info("specified efms-per-file: " + efmsPerPart);
        if (efmsPerPart > estimate) {
            LogPkg.LOGGER.warning("specified efms-per-file is larger than estimated figure: " + efmsPerPart + " > " + estimate);
        }
    }

    private static long estimateEfmsPerPart(MetabolicNetwork originalNetwork, OutputMode mode) {
        int valueSize = mode.granularity.isBinarySufficient() ? 1 : 8;
        int offset = 32 * originalNetwork.getReactions().length() * originalNetwork.getMetabolites().length();
        int estimate = (Integer.MAX_VALUE - offset) / originalNetwork.getReactions().length() / valueSize;
        LogPkg.LOGGER.finer("estimated efms-per-file (unrounded): " + estimate);
        int round = (int)Math.pow(10.0, (int)Math.log10(estimate)) / 10;
        if (round > 0) {
            estimate -= estimate % round;
        }
        return estimate;
    }
}

