/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.output.mat;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.output.EfmOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.metabolic.efm.output.EfmProcessor;
import ch.javasoft.metabolic.efm.output.mat.MatFileOutputFormatter;
import ch.javasoft.metabolic.efm.output.mat.MatFileWriter;
import ch.javasoft.metabolic.efm.output.mat.PartitionedMatFileWriter;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPartitionedMatFileWriter
implements PartitionedMatFileWriter {
    private final File mFolder;
    private final String mFileName;
    private final String mFileEnding;
    private final long mMaxEfmCountPerPart;
    private MatFileWriter mWriter = null;
    private long mLastEfmIndex = -1L;

    public DefaultPartitionedMatFileWriter(File folder, String fileName, long maxEfmCountPerPart) {
        this(folder, fileName, ".mat", maxEfmCountPerPart);
    }

    public DefaultPartitionedMatFileWriter(File folder, String fileName, String fileEnding, long maxEfmCountPerPart) {
        this.mFolder = folder;
        this.mFileName = fileName;
        this.mFileEnding = fileEnding;
        this.mMaxEfmCountPerPart = maxEfmCountPerPart;
    }

    public long getEfmCountForPart(EfmOutputCallback cb, EfmOutputEvent evt, int partIndex) {
        long efmsSoFar;
        long efmCount = evt.getEfmCount();
        long efmsLeft = efmCount - (efmsSoFar = (long)partIndex * this.mMaxEfmCountPerPart);
        return efmsLeft > this.mMaxEfmCountPerPart ? this.mMaxEfmCountPerPart : efmsLeft;
    }

    @Override
    public MatFileWriter getPartMatFileWriter(EfmOutputCallback cb, EfmOutputEvent evt, long efmIndex, MetabolicNetwork originalNetwork, EfmProcessor<MatFileWriter> efmProcessor) throws IOException {
        if (efmIndex != this.mLastEfmIndex) {
            if (efmIndex % this.mMaxEfmCountPerPart == 0L) {
                if (this.mWriter != null) {
                    this.closeCurrentWriter(cb, evt, efmProcessor);
                }
                this.mWriter = this.createAndInitWriter(cb, evt, efmIndex, originalNetwork, efmProcessor);
            }
            this.mLastEfmIndex = efmIndex;
        }
        return this.mWriter;
    }

    @Override
    public void close(EfmOutputCallback cb, EfmOutputEvent evt, long efmCount, EfmProcessor<MatFileWriter> efmProcessor) throws IOException {
        this.closeCurrentWriter(cb, evt, efmProcessor);
    }

    private MatFileWriter createAndInitWriter(EfmOutputCallback cb, EfmOutputEvent evt, long efmIndex, MetabolicNetwork originalNetwork, EfmProcessor<MatFileWriter> efmProcessor) throws IOException {
        long nextPartEfmInd = efmIndex + this.mMaxEfmCountPerPart;
        long totalEfmCount = evt.getEfmCount();
        int partCount = 1 + (int)(Math.max(0L, totalEfmCount - 1L) / this.mMaxEfmCountPerPart);
        long partEfmCount = nextPartEfmInd > totalEfmCount ? totalEfmCount % this.mMaxEfmCountPerPart : this.mMaxEfmCountPerPart;
        int partIndex = (int)(efmIndex / this.mMaxEfmCountPerPart);
        File partFile = this.getPartFile(partIndex);
        MatFileWriter matWriter = new MatFileWriter(partFile, "mnet");
        MatFileOutputFormatter.writeNetworkFootPrint(originalNetwork, matWriter, this.getFileNameWithoutEnding(), partFile.getName(), partIndex, partCount);
        int[] unused = efmProcessor.initialize(cb, matWriter, evt, partEfmCount);
        matWriter.write("disabledReactions", unused);
        return matWriter;
    }

    private String getFileNameWithoutEnding() {
        String ending = this.mFileEnding.startsWith(".") ? this.mFileEnding : "." + this.mFileEnding;
        String name = this.mFileName.endsWith(ending) ? this.mFileName.substring(0, this.mFileName.length() - ending.length()) : this.mFileName;
        return name;
    }

    private File getPartFile(int partIndex) {
        String ending = this.mFileEnding.startsWith(".") ? this.mFileEnding : "." + this.mFileEnding;
        File file = new File(this.mFolder, String.valueOf(this.getFileNameWithoutEnding()) + '_' + partIndex + ending);
        return file;
    }

    private void closeCurrentWriter(EfmOutputCallback cb, EfmOutputEvent evt, EfmProcessor<MatFileWriter> efmProcessor) throws IOException {
        if (efmProcessor != null) {
            efmProcessor.finalize(cb, this.mWriter, evt);
        }
        this.mWriter.close();
    }
}

