/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.output;

import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.compress.CompressedMetabolicNetwork;
import ch.javasoft.metabolic.efm.output.EfmOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.metabolic.efm.output.EfmProcessor;
import java.io.IOException;
import java.util.BitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmappingEfmProcessor<W>
implements EfmProcessor<W> {
    private final EfmProcessor<W> mDelegate;
    private final MetabolicNetwork mOriginalNetwork;
    private int[] mMetaboliteMapping;
    private int[] mReactionMapping;

    public UnmappingEfmProcessor(EfmProcessor<W> delegate, MetabolicNetwork originalNetwork) {
        this.mOriginalNetwork = originalNetwork;
        this.mDelegate = delegate;
    }

    @Override
    public int[] initialize(EfmOutputCallback cb, W writer, EfmOutputEvent evt, long efmCount) throws IOException {
        MetabolicNetwork net = evt.getMetabolicNetwork();
        if (net instanceof CompressedMetabolicNetwork) {
            if (!cb.getGranularity().isUncompressionNeeded()) {
                throw new IOException("compressed network, but uncompressed output");
            }
            net = ((CompressedMetabolicNetwork)net).getRootNetwork();
        }
        int mlen = net.getMetabolites().length();
        int rlen = net.getReactions().length();
        int olen = this.mOriginalNetwork.getReactions().length();
        this.mMetaboliteMapping = new int[mlen];
        this.mReactionMapping = new int[rlen];
        BitSet usedReacts = new BitSet(olen);
        int i = 0;
        while (i < mlen) {
            Metabolite meta = net.getMetabolites().get(i);
            this.mMetaboliteMapping[i] = this.mOriginalNetwork.getMetaboliteIndex(meta.getName());
            ++i;
        }
        i = 0;
        while (i < rlen) {
            int index;
            Reaction reac = net.getReactions().get(i);
            this.mReactionMapping[i] = index = this.mOriginalNetwork.getReactionIndex(reac.getName());
            if (this.mReactionMapping[i] == -1) {
                throw new IOException("reaction not found in original network: " + reac.getName());
            }
            usedReacts.set(index);
            ++i;
        }
        int[] unused = new int[olen - usedReacts.cardinality()];
        int index = 0;
        int i2 = usedReacts.nextClearBit(0);
        while (i2 < olen) {
            unused[index++] = i2 + 1;
            i2 = usedReacts.nextClearBit(i2 + 1);
        }
        this.mDelegate.initialize(cb, writer, new EfmOutputEvent(EfmOutputEvent.Kind.PRE, this.mOriginalNetwork, efmCount), efmCount);
        return unused;
    }

    @Override
    public int addEfm(EfmOutputCallback cb, W writer, EfmOutputEvent evt, long efmIndex) throws IOException {
        int curLen = evt.getEfm().getSize();
        FluxDistribution fluxDist = evt.getEfm().create(this.mOriginalNetwork);
        int i = 0;
        while (i < curLen) {
            Number value = evt.getEfm().getNumberRate(i);
            fluxDist.setRate(this.mReactionMapping[i], value);
            ++i;
        }
        return this.mDelegate.addEfm(cb, writer, new EfmOutputEvent(this.mOriginalNetwork, fluxDist, evt.getEfmCount()), efmIndex);
    }

    @Override
    public void finalize(EfmOutputCallback cb, W writer, EfmOutputEvent evt) throws IOException {
        this.mDelegate.finalize(cb, writer, evt);
    }
}

