/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.output;

import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.efm.output.AbstractOutputCallback;
import ch.javasoft.metabolic.efm.output.CallbackGranularity;
import ch.javasoft.metabolic.efm.output.EfmOutputCallback;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.metabolic.efm.output.LogPkg;
import ch.javasoft.util.DoubleArray;
import ch.javasoft.util.IntArray;
import ch.javasoft.util.logging.LogFragmenter;
import java.io.IOException;

public class OptimizerOutputCallback
extends AbstractOutputCallback {
    private final int[] mCostIndices;
    private final double[] mCostFunction;
    private final EfmOutputCallback mWrapped;
    private final boolean mCallbackForAllEfms;
    private double mMin;
    private double mMax;
    private FluxDistribution mMinFlux;
    private FluxDistribution mMaxFlux;

    public OptimizerOutputCallback(EfmOutputCallback wrapped, double[] costFunction, boolean callbackForAllEfms) {
        this.mWrapped = wrapped;
        IntArray inds = new IntArray();
        DoubleArray coeffs = new DoubleArray();
        int i = 0;
        while (i < costFunction.length) {
            if (costFunction[i] != 0.0) {
                inds.add(i);
                coeffs.add(costFunction[i]);
            }
            ++i;
        }
        this.mCostIndices = inds.toArray();
        this.mCostFunction = coeffs.toArray();
        this.mCallbackForAllEfms = callbackForAllEfms;
    }

    protected void callbackPre(EfmOutputEvent evt) throws IOException {
        this.mMin = Double.MAX_VALUE;
        this.mMax = -1.7976931348623157E308;
        this.mMinFlux = null;
        this.mMaxFlux = null;
        this.mWrapped.callback(evt);
    }

    protected void callbackEfmOut(EfmOutputEvent evt) throws IOException {
        double[] vals = evt.getEfm().getDoubleRates();
        double cost = 0.0;
        int i = 0;
        while (i < this.mCostIndices.length) {
            cost += this.mCostFunction[i] * vals[this.mCostIndices[i]];
            ++i;
        }
        if (cost < this.mMin) {
            this.mMin = cost;
            this.mMinFlux = evt.getEfm();
        }
        if (cost > this.mMax) {
            this.mMax = cost;
            this.mMaxFlux = evt.getEfm();
        }
        if (this.mCallbackForAllEfms) {
            this.mWrapped.callback(evt);
        }
    }

    protected void callbackPost(EfmOutputEvent evt) throws IOException {
        this.logCostFunction();
        if (this.mMinFlux != null) {
            EfmOutputEvent minEvt = new EfmOutputEvent(evt.getMetabolicNetwork(), this.mMinFlux, evt.getEfmCount());
            this.mWrapped.callback(minEvt);
            this.logMinMax(minEvt, this.mMin, true);
        }
        if (this.mMaxFlux != null) {
            EfmOutputEvent maxEvt = new EfmOutputEvent(evt.getMetabolicNetwork(), this.mMaxFlux, evt.getEfmCount());
            this.mWrapped.callback(maxEvt);
            this.logMinMax(maxEvt, this.mMax, false);
        }
        this.mWrapped.callback(evt);
    }

    public void logCostFunction() {
        LogFragmenter log = new LogFragmenter(LogPkg.LOGGER);
        log.infoStart("cost function c = ");
        int i = 0;
        while (i < this.mCostIndices.length) {
            if (i > 0) {
                log.append(" + ");
            }
            log.append(String.valueOf(this.mCostFunction[i]) + " x" + this.mCostIndices[i]);
            ++i;
        }
        log.end();
    }

    public void logMinMax(EfmOutputEvent evt, double value, boolean isMin) {
        LogPkg.LOGGER.info(String.valueOf(isMin ? "minimum" : "maximum") + " value: " + value);
    }

    public CallbackGranularity getGranularity() {
        return CallbackGranularity.DoubleUncompressed;
    }

    public boolean allowLoggingDuringOutput() {
        return this.mWrapped.allowLoggingDuringOutput();
    }

    public boolean isThreadSafe() {
        return false;
    }
}

