/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.output;

import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnFactories;

public class EfmOutputEvent {
    private final Kind mKind;
    private final MetabolicNetwork mMetabolicNetwork;
    private final FluxDistribution mEfm;
    private final long mEfmCount;

    protected EfmOutputEvent(Kind kind, MetabolicNetwork net, FluxDistribution efm, long efmCount) {
        if (net == null) {
            throw new NullPointerException("metabolic network cannot be null");
        }
        if (efm == null != (kind != Kind.EFM_OUT)) {
            if (kind == Kind.EFM_OUT) {
                throw new NullPointerException("efm cannot be null for event kind " + (Object)((Object)kind));
            }
            throw new IllegalArgumentException("efm must be null for event kind " + (Object)((Object)kind));
        }
        this.mKind = kind;
        this.mMetabolicNetwork = net;
        this.mEfm = efm;
        this.mEfmCount = efmCount;
    }

    public EfmOutputEvent(MetabolicNetwork net, FluxDistribution efm, long efmCount) {
        this(Kind.EFM_OUT, net, efm, efmCount);
    }

    public EfmOutputEvent(Kind kind, MetabolicNetwork net, long efmCount) {
        this(kind, net, null, efmCount);
    }

    public Kind getKind() {
        return this.mKind;
    }

    public MetabolicNetwork getMetabolicNetwork() {
        return this.mMetabolicNetwork;
    }

    public FluxDistribution getEfm() {
        return this.mEfm;
    }

    public Column getEfmAsColumn() {
        Column col = ColumnFactories.instance().createBinaryColumn(this.mEfm.getPreferredNumberClass(), this.mEfm.getSize());
        int i = 0;
        while (i < this.mEfm.getSize()) {
            if (this.mEfm.getRateSignum(i) != 0) {
                col.bitValues().set(i);
            }
            ++i;
        }
        return col;
    }

    public long getEfmCount() {
        return this.mEfmCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        PRE,
        EFM_OUT,
        POST;

    }
}

