/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.output;

import ch.javasoft.metabolic.efm.output.AbstractOutputCallback;
import ch.javasoft.metabolic.efm.output.CallbackGranularity;
import ch.javasoft.metabolic.efm.output.EfmOutputEvent;
import ch.javasoft.metabolic.efm.output.EfmOutputFormatter;
import ch.javasoft.metabolic.efm.output.OutputMode;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFormattedOutputCallback<W>
extends AbstractOutputCallback {
    protected final OutputMode mMode;
    protected final EfmOutputFormatter<W> mFormatter;
    protected final W mWriter;
    protected long cnt;

    public AbstractFormattedOutputCallback(OutputMode mode, EfmOutputFormatter<W> formatter, W writer) {
        this.mMode = mode;
        this.mFormatter = formatter;
        this.mWriter = writer;
    }

    @Override
    protected void callbackPre(EfmOutputEvent evt) throws IOException {
        this.cnt = 0L;
        this.mFormatter.formatHeader(this, this.mWriter, evt);
    }

    @Override
    protected void callbackEfmOut(EfmOutputEvent evt) throws IOException {
        this.mFormatter.formatEfmHeader(this, this.mWriter, evt, this.cnt);
        if (this.mFormatter.isEfmValueIterationNeeded(this)) {
            int i = 0;
            while (i < evt.getEfm().getSize()) {
                Number val = evt.getEfm().getNumberRate(i);
                this.mFormatter.formatEfmValue(this, this.mWriter, evt, this.cnt, i, val);
                ++i;
            }
        }
        this.mFormatter.formatEfmFooter(this, this.mWriter, evt, this.cnt);
        ++this.cnt;
    }

    @Override
    protected void callbackPost(EfmOutputEvent evt) throws IOException {
        this.mFormatter.formatFooter(this, this.mWriter, evt, this.cnt);
        this.cnt = 0L;
    }

    @Override
    public CallbackGranularity getGranularity() {
        return this.mMode.granularity;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }
}

