/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model.nullspace;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.IterationStateModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.model.nullspace.AbstractNullspaceColumnInspectorModifier;
import ch.javasoft.metabolic.efm.util.ColumnUtil;
import ch.javasoft.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullspaceDoubleColumnInspectorModifier
extends AbstractNullspaceColumnInspectorModifier<Double, double[]> {
    public NullspaceDoubleColumnInspectorModifier(boolean convertNumericToBinaryOnMerge) {
        super(convertNumericToBinaryOnMerge);
    }

    @Override
    public int getHyperplaneSign(ColumnHome<Double, ?> columnHome, EfmModel model, IBitSet binaryVals, int binarySize, double[] numericVals, IterationStateModel iteration) {
        int numericInd = this.getNumericIndex(model, binarySize, numericVals.length, iteration.getHyperplaneIndex());
        return model.zero().sgn(numericVals[numericInd]);
    }

    @Override
    public IBitSet convertBinary(ColumnHome<Double, ?> columnHome, EfmModel model, IBitSet binaryVals, int binarySize, double[] numericVals, IterationStepModel iteration, boolean clone) {
        int convertCount = this.getConvertSizeBinary(model, binarySize, numericVals.length, iteration);
        if (clone) {
            binaryVals = binaryVals.clone();
        }
        if (convertCount == 0) {
            return binaryVals;
        }
        int hyperInd = iteration.getCurrentState().getHyperplaneIndex();
        int i = 0;
        while (i < convertCount) {
            int signum;
            int numericInd = this.getNumericIndex(model, binarySize, numericVals.length, hyperInd + i);
            int n = signum = numericInd == -1 ? 0 : model.zero().sgn(numericVals[numericInd]);
            if (signum < 0) {
                throw new IllegalStateException("pivot value is below zero: " + numericVals[numericInd]);
            }
            if (signum == 0) {
                binaryVals.set(hyperInd + i);
            }
            ++i;
        }
        return binaryVals;
    }

    @Override
    public double[] convertNumeric(ColumnHome<Double, ?> columnHome, EfmModel model, IBitSet binaryVals, int binarySize, double[] numericVals, IterationStepModel iteration, boolean clone) {
        int convertCount = this.getConvertSizeNumeric(model, binarySize, numericVals.length, iteration);
        if (convertCount == 0 && !clone) {
            return numericVals;
        }
        return Arrays.copyOfRange(numericVals, convertCount, numericVals.length);
    }

    @Override
    public double[] mergeNumeric(ColumnHome<Double, ?> columnHome, EfmModel model, IBitSet binaryValsCol1, int binarySizeCol1, double[] numericValsCol1, IBitSet binaryValsCol2, int binarySizeCol2, double[] numericValsCol2, IterationStepModel iteration) {
        int hyperInd = iteration.getCurrentState().getHyperplaneIndex();
        int numerInd1 = this.getNumericIndex(model, binarySizeCol1, numericValsCol1.length, hyperInd);
        int numerInd2 = this.getNumericIndex(model, binarySizeCol2, numericValsCol2.length, hyperInd);
        double mulCol1 = numericValsCol2[numerInd2];
        double mulCol2 = numericValsCol1[numerInd1];
        if (model.zero().isNonZero(numericValsCol1[numerInd1] * mulCol1 - numericValsCol2[numerInd2] * mulCol2)) {
            throw new IllegalArgumentException("combination of " + numericValsCol1[numerInd1] + " with " + numericValsCol2[numerInd2] + " is not zero: " + (numericValsCol1[numerInd1] * mulCol1 + numericValsCol2[numerInd2] * mulCol2));
        }
        return ColumnUtil.mergeNumeric(model, mulCol1, numericValsCol1, mulCol2, numericValsCol2, this.convertNumericToBinaryOnMerge);
    }
}

