/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model.canonical;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.math.varint.VarIntNumber;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.IterationStateModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.model.canonical.AbstractCanonicalColumnInspectorModifier;
import ch.javasoft.metabolic.efm.util.CanonicalUtil;
import ch.javasoft.metabolic.efm.util.ColumnUtil;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonicalVarIntColumnInspectorModifier
extends AbstractCanonicalColumnInspectorModifier<VarIntNumber, VarIntNumber[]> {
    @Override
    protected VarIntNumber[] copyOf(VarIntNumber[] numericVals) {
        return Arrays.copyOf(numericVals, numericVals.length);
    }

    @Override
    public int getHyperplaneSign(ColumnHome<VarIntNumber, ?> columnHome, EfmModel model, IBitSet binaryVals, int binarySize, VarIntNumber[] numericVals, IterationStateModel iteration) {
        ReadableMatrix<VarIntNumber> stoich = model.getStoichiometricMatrix(columnHome);
        int hyperIndex = iteration.getHyperplaneIndex();
        VarIntNumber val = (VarIntNumber)CanonicalUtil.getInequalityValue(stoich, (int)hyperIndex, (Number[])numericVals, (int[])model.getReactionSorting());
        return val.signum();
    }

    @Override
    public VarIntNumber[] mergeNumeric(ColumnHome<VarIntNumber, ?> columnHome, EfmModel model, IBitSet binaryValsCol1, int binarySizeCol1, VarIntNumber[] numericValsCol1, IBitSet binaryValsCol2, int binarySizeCol2, VarIntNumber[] numericValsCol2, IterationStepModel iteration) {
        ReadableMatrix<VarIntNumber> stoich = model.getStoichiometricMatrix(columnHome);
        int hyperplaneIndex = iteration.getCurrentState().getHyperplaneIndex();
        VarIntNumber mulCol1 = (VarIntNumber)CanonicalUtil.getInequalityValue(stoich, (int)hyperplaneIndex, (Number[])numericValsCol2, (int[])model.getReactionSorting());
        VarIntNumber mulCol2 = (VarIntNumber)CanonicalUtil.getInequalityValue(stoich, (int)hyperplaneIndex, (Number[])numericValsCol1, (int[])model.getReactionSorting());
        NumberOperations<VarIntNumber> numOps = columnHome.getNumberOperations();
        return (VarIntNumber[])ColumnUtil.mergeNumeric((EfmModel)model, numOps, (Number)mulCol1, (Number[])numericValsCol1, (Number)mulCol2, (Number[])numericValsCol2, (boolean)false);
    }
}

