/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model.canonical;

import ch.javasoft.math.NumberOperations;
import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.model.AbstractColumnToFluxDistributionConverter;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;
import ch.javasoft.metabolic.efm.output.CallbackGranularity;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.util.logging.LogFragmenter;
import ch.javasoft.util.numeric.Zero;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonicalColumnToFluxDistributionConverter<N extends Number, Col extends Column>
extends AbstractColumnToFluxDistributionConverter<N, Col> {
    public CanonicalColumnToFluxDistributionConverter(ColumnHome<N, Col> columnHome) {
        super(columnHome);
    }

    @Override
    protected FluxDistribution createFluxDistributionFromColumn(LogFragmenter log, Config config, NetworkEfmModel model, Col column, CallbackGranularity granularity) {
        ReadableMatrix stoichMatrix = model.getStoichiometricMatrix(this.columnHome);
        NumberOperations numberOps = stoichMatrix.getNumberOperations();
        Zero zero = config.zero();
        int size = column.numericSize();
        Number[] values = numberOps.newArray(size);
        int ii = 0;
        while (ii < size) {
            Object value = granularity.isBinarySufficient() ? (column.getNumericSignum(zero, ii) == 0 ? numberOps.zero() : numberOps.one()) : column.getNumeric(this.columnHome, ii);
            values[model.getReactionSorting()[ii]] = value;
            ++ii;
        }
        Number[] unexpanded = model.getReactionMapping().getUnexpandedFluxValues(this.columnHome, values);
        return this.columnHome.createFluxDistribution(model.getMetabolicNetwork(), unexpanded);
    }
}

