/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model.canonical;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.IterationStateModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.model.canonical.AbstractCanonicalColumnInspectorModifier;
import ch.javasoft.metabolic.efm.util.CanonicalUtil;
import ch.javasoft.metabolic.efm.util.ColumnUtil;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.util.Arrays;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonicalBigIntegerColumnInspectorModifier
extends AbstractCanonicalColumnInspectorModifier<BigInteger, BigInteger[]> {
    @Override
    protected BigInteger[] copyOf(BigInteger[] numericVals) {
        return Arrays.copyOf(numericVals, numericVals.length);
    }

    @Override
    public int getHyperplaneSign(ColumnHome<BigInteger, ?> columnHome, EfmModel model, IBitSet binaryVals, int binarySize, BigInteger[] numericVals, IterationStateModel iteration) {
        ReadableMatrix<BigInteger> stoich = model.getStoichiometricMatrix(columnHome);
        int hyperIndex = iteration.getHyperplaneIndex();
        BigInteger val = (BigInteger)CanonicalUtil.getInequalityValue(stoich, (int)hyperIndex, (Number[])numericVals, (int[])model.getReactionSorting());
        return val.signum();
    }

    @Override
    public BigInteger[] mergeNumeric(ColumnHome<BigInteger, ?> columnHome, EfmModel model, IBitSet binaryValsCol1, int binarySizeCol1, BigInteger[] numericValsCol1, IBitSet binaryValsCol2, int binarySizeCol2, BigInteger[] numericValsCol2, IterationStepModel iteration) {
        ReadableMatrix<BigInteger> stoich = model.getStoichiometricMatrix(columnHome);
        int hyperplaneIndex = iteration.getCurrentState().getHyperplaneIndex();
        BigInteger mulCol1 = (BigInteger)CanonicalUtil.getInequalityValue(stoich, (int)hyperplaneIndex, (Number[])numericValsCol2, (int[])model.getReactionSorting());
        BigInteger mulCol2 = (BigInteger)CanonicalUtil.getInequalityValue(stoich, (int)hyperplaneIndex, (Number[])numericValsCol1, (int[])model.getReactionSorting());
        NumberOperations<BigInteger> numOps = columnHome.getNumberOperations();
        return (BigInteger[])ColumnUtil.mergeNumeric((EfmModel)model, numOps, (Number)mulCol1, (Number[])numericValsCol1, (Number)mulCol2, (Number[])numericValsCol2, (boolean)false);
    }
}

