/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model;

import ch.javasoft.metabolic.efm.model.IterationStateModel;
import ch.javasoft.metabolic.efm.model.NetworkEfmModel;

public class DefaultIterationStateModel
implements IterationStateModel {
    private final int hyperplaneIndex;
    private final int booleanSize;
    private final int numericSize;

    public DefaultIterationStateModel(NetworkEfmModel efmModel, int iteration) {
        this(efmModel.getHyperplaneIndex(iteration), efmModel.getBooleanSize(iteration), efmModel.getNumericSize(iteration));
    }

    public DefaultIterationStateModel(int hyperplaneIndex, int booleanSize, int numericSize) {
        this.hyperplaneIndex = hyperplaneIndex;
        this.booleanSize = booleanSize;
        this.numericSize = numericSize;
    }

    public static DefaultIterationStateModel getFinal(NetworkEfmModel efmModel) {
        return new DefaultIterationStateModel(-1, efmModel.getFinalBooleanSize(), efmModel.getFinalNumericSize());
    }

    public int getHyperplaneIndex() {
        return this.hyperplaneIndex;
    }

    public int getBooleanSize() {
        return this.booleanSize;
    }

    public int getNumericSize() {
        return this.numericSize;
    }

    public String toString() {
        return "{h=" + this.hyperplaneIndex + ", b=" + this.booleanSize + ", n=" + this.numericSize + "}";
    }
}

