/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.model;

import ch.javasoft.math.BigFraction;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.model.ColumnInspectorModifierFactory;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.util.numeric.Zero;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEfmModel
implements EfmModel {
    private final Config config;
    private final ReadableMatrix<BigFraction> stoichiometricMatrixRational;
    private final int stoichRank;
    private final int[] reactionSorting;
    private final int[] metaboliteSorting;
    private final ColumnInspectorModifierFactory columnInspectorModifierFactory;
    private volatile transient ReadableMatrix<?> stoichMatrixTyped;

    protected <N extends Number, Col extends Column> DefaultEfmModel(Init init) {
        this.config = (Config)init.notnull(init.config);
        this.stoichiometricMatrixRational = (ReadableMatrix)init.notnull(init.stoichiometricMatrixRational);
        this.stoichRank = init.notneg(init.stoichRank);
        this.reactionSorting = (int[])init.notnull(init.reactionSorting);
        this.metaboliteSorting = (int[])init.notnull(init.metaboliteSorting);
        this.columnInspectorModifierFactory = (ColumnInspectorModifierFactory)init.notnull(init.columnInspectorModifierFactory);
    }

    @Override
    public <N extends Number> ReadableMatrix<N> getStoichiometricMatrix(ColumnHome<N, ?> columnHome) {
        if (this.stoichMatrixTyped == null) {
            this.stoichMatrixTyped = columnHome.convertMatrix(this.stoichiometricMatrixRational, true, false);
        }
        return columnHome.castMatrix(this.stoichMatrixTyped);
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public Arithmetic getArithmetic() {
        return this.config.getArithmetic();
    }

    @Override
    public int getAdjEnumThreads() {
        return this.config.getMaxThreads();
    }

    @Override
    public ColumnInspectorModifierFactory getColumnInspectorModifierFactory() {
        return this.columnInspectorModifierFactory;
    }

    @Override
    public int[] getReactionSorting() {
        return this.reactionSorting;
    }

    @Override
    public int[] getMetaboliteSorting() {
        return this.metaboliteSorting;
    }

    @Override
    public int[] getColMapping() {
        return this.reactionSorting;
    }

    @Override
    public int getRequiredRank() {
        return this.stoichiometricMatrixRational.getColumnCount() - 2;
    }

    @Override
    public int getRequiredCardinality() {
        return this.getRequiredRank() - this.getStoichRank();
    }

    @Override
    public ReadableMatrix<BigFraction> getStoichRational() {
        return this.stoichiometricMatrixRational;
    }

    @Override
    public int getStoichRank() {
        return this.stoichRank;
    }

    @Override
    public Zero zero() {
        return this.config.zero();
    }

    @Override
    public <N extends Number> void log(ColumnHome<N, ?> columnHome, Logger logger) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("efm-model:");
            logger.fine("..kind             : " + this.getClass().getSimpleName());
            logger.fine("..arithmetic       : " + this.config.getArithmetic().getNiceName());
            logger.fine("..adj enum threads : " + this.getAdjEnumThreads());
            logger.fine("..stoich type      : " + this.stoichiometricMatrixRational.getClass().getSimpleName());
            logger.fine("..stoich rank      : " + this.stoichRank);
            logger.fine("..reaction sorting : " + Arrays.toString(this.reactionSorting));
            logger.fine("..metabolite sort. : " + Arrays.toString(this.metaboliteSorting));
            logger.fine("..col i/m factory  : " + this.columnInspectorModifierFactory.getClass().getSimpleName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Init {
        protected Config config;
        protected ReadableMatrix<BigFraction> stoichiometricMatrixRational;
        protected int stoichRank = -1;
        protected int[] reactionSorting;
        protected int[] metaboliteSorting;
        protected ColumnInspectorModifierFactory columnInspectorModifierFactory;

        private <O> O notnull(O obj) {
            if (obj == null) {
                throw new NullPointerException();
            }
            return obj;
        }

        private int notneg(int value) {
            if (value < 0) {
                throw new IllegalStateException("value not initialized: " + value);
            }
            return value;
        }
    }
}

