/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.memory.incore;

import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.memory.IndexableMemory;
import ch.javasoft.metabolic.efm.memory.ReadWriteMemory;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InCoreMemory<Col extends Column>
implements ReadWriteMemory<Col> {
    private final List<Col> mColumns = new ArrayList<Col>();

    @Override
    public String fileId() throws IOException {
        throw new IOException("in core memory has no associated file id");
    }

    @Override
    public Iterator<Col> iterator() {
        return Collections.unmodifiableList(this.mColumns).iterator();
    }

    @Override
    public void appendColumn(Col column) {
        this.mColumns.add(column);
    }

    @Override
    public void appendColumns(Iterable<? extends Col> columns) {
        if (columns instanceof InCoreMemory) {
            this.mColumns.addAll(((InCoreMemory)columns).mColumns);
        } else if (columns instanceof Collection) {
            this.mColumns.addAll((Collection)columns);
        } else {
            for (Column col : columns) {
                this.mColumns.add(col);
            }
        }
    }

    @Override
    public int getColumnCount() {
        return this.mColumns.size();
    }

    @Override
    public Col getColumn(int index) {
        return (Col)((Column)this.mColumns.get(index));
    }

    @Override
    public void swapColumns(int indexA, int indexB) throws IOException {
        Column colA = (Column)this.mColumns.get(indexA);
        this.mColumns.set(indexA, (Column)this.mColumns.get(indexB));
        this.mColumns.set(indexB, colA);
    }

    public void clear() {
        this.mColumns.clear();
    }

    @Override
    public void appendFrom(IndexableMemory<? extends Col> memory) {
        if (memory instanceof InCoreMemory) {
            this.mColumns.addAll(((InCoreMemory)memory).mColumns);
        } else {
            this.appendColumns(memory);
        }
    }

    @Override
    public SortableMemory<Col> toSortableMemory() throws IOException {
        return this;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close(boolean erase) throws IOException {
    }
}

