/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.memory.incore;

import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.memory.AppendableMemory;
import ch.javasoft.metabolic.efm.memory.IndexableMemory;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.memory.incore.InCoreMemory;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InCoreAppendableMemory<Col extends Column>
implements AppendableMemory<Col> {
    private final ConcurrentLinkedQueue<Col> queue = new ConcurrentLinkedQueue();

    @Override
    public String fileId() throws IOException {
        throw new IOException("in core memory has no associated file id");
    }

    @Override
    public void appendColumn(Col column) throws IOException {
        this.queue.add(column);
    }

    @Override
    public void appendColumns(Iterable<? extends Col> columns) throws IOException {
        for (Column col : columns) {
            this.queue.add(col);
        }
    }

    @Override
    public void appendFrom(IndexableMemory<? extends Col> memory) throws IOException {
        for (Column col : memory) {
            this.queue.add(col);
        }
    }

    @Override
    public int getColumnCount() throws IOException {
        return this.queue.size();
    }

    @Override
    public Iterator<Col> iterator() {
        return Collections.unmodifiableCollection(this.queue).iterator();
    }

    public void clear() throws IOException {
        this.queue.clear();
    }

    @Override
    public SortableMemory<Col> toSortableMemory() throws IOException {
        InCoreMemory mem = new InCoreMemory();
        mem.appendColumns(this);
        return mem;
    }

    @Override
    public void close(boolean erase) throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }
}

