/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.dist.impl.file;

import ch.javasoft.job.AbstractJob;
import ch.javasoft.job.ExecJob;
import ch.javasoft.job.Executable;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.config.DistributedConfig;
import ch.javasoft.metabolic.efm.dist.impl.DistJobController;
import ch.javasoft.metabolic.efm.dist.impl.DistServer;
import ch.javasoft.metabolic.efm.dist.impl.file.FileBasedDistJob;
import ch.javasoft.metabolic.efm.dist.impl.file.LogPkg;
import ch.javasoft.util.logging.LogPrintStream;
import ch.javasoft.util.logging.Loggers;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedDistJobController
implements DistJobController {
    private final Config config;
    private final String configFileName;
    private final String stoichFileName;
    private final String efmModelFileName;
    private final String adjModelFileName;
    private final String masterHostName;
    private final int masterPort;
    private final DistServer server;

    public FileBasedDistJobController(Config config, DistServer server, String configFileName, String stoichFileName, String efmModelFileName, String adjModelFileName, String masterHostName, int masterPort) {
        this.config = config;
        this.configFileName = configFileName;
        this.stoichFileName = stoichFileName;
        this.efmModelFileName = efmModelFileName;
        this.adjModelFileName = adjModelFileName;
        this.masterHostName = masterHostName;
        this.masterPort = masterPort;
        this.server = server;
    }

    private String[] getCommandArray(int nodeIndex) {
        DistributedConfig distConfig = this.config.getDistributedConfig();
        String rawCommand = distConfig.getCommand();
        String command = rawCommand.replace("[nodename]", distConfig.getNodeNames().get(nodeIndex)).replace("[workdir]", System.getProperty("user.dir")).replace("[classpath]", ManagementFactory.getRuntimeMXBean().getClassPath()).replace("[class]", FileBasedDistJob.class.getName()).replace("[vmargs]", distConfig.getVmArgs().get(nodeIndex)).replace("[args]", this.getArgs(nodeIndex));
        return command.split("\\s+");
    }

    private String getArgs(int nodeIndex) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.config.getTempDir().getPersonalizedDir().getAbsolutePath());
        sb.append(' ');
        sb.append(this.config.getDistributedConfig().getLogLevels().get(nodeIndex));
        sb.append(' ');
        sb.append(this.configFileName);
        sb.append(' ');
        sb.append(this.stoichFileName);
        sb.append(' ');
        sb.append(this.efmModelFileName);
        sb.append(' ');
        sb.append(this.adjModelFileName);
        sb.append(' ');
        sb.append(nodeIndex);
        sb.append(' ');
        sb.append(this.masterHostName);
        sb.append(' ');
        sb.append(this.masterPort);
        return sb.toString();
    }

    @Override
    public ExecJob createExecJob(int nodeIndex) {
        return new ExecJob(this.getCommandArray(nodeIndex));
    }

    @Override
    public Executable<Void> createExecutable(final int nodeIndex) {
        return new AbstractJob<Void>(){

            @Override
            public Void run() throws Throwable {
                Logger logger = Loggers.getLogger(FileBasedDistJob.class.getSimpleName());
                logger.setLevel(Level.WARNING);
                FileBasedDistJob.main(FileBasedDistJobController.this.getArgs(nodeIndex).split("\\s"), logger);
                return null;
            }
        };
    }

    @Override
    public void awaitCompletion() throws InterruptedException {
        this.server.awaitCompletion();
        this.abort();
    }

    @Override
    public void abort() {
        try {
            this.server.close();
        }
        catch (Exception ex) {
            LogPkg.LOGGER.warning("could not close server, e=" + ex);
            ex.printStackTrace(new LogPrintStream(LogPkg.LOGGER, Level.WARNING));
        }
    }
}

