/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.dist.impl;

import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.memory.PartId;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.MemoryAccessor;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientServerMemory<Col extends Column>
implements SortableMemory<Col> {
    private static final int CACHE_SIZE = 4048;
    private final AtomicReferenceArray<Entry<Col>> cache = new AtomicReferenceArray(4048);
    private final MemoryAccessor<Col> memoryAccessor;
    private final PartId part;

    public ClientServerMemory(MemoryAccessor<Col> memoryAccessor, PartId part) {
        this.memoryAccessor = memoryAccessor;
        this.part = part;
    }

    @Override
    public void flush() throws IOException {
        throw new IOException("unsupported method");
    }

    @Override
    public void swapColumns(int indexA, int indexB) throws IOException {
        throw new IOException("unsupported method");
    }

    @Override
    public Col getColumn(int index) throws IOException {
        int pos = ClientServerMemory.hash(index) % 4048;
        Entry<Col> e = this.cache.get(pos);
        if (e != null && ((Entry)e).index == index) {
            return (Col)((Entry)e).column;
        }
        Entry<Col> n = new Entry<Col>(index, this.memoryAccessor.getColumn(this.part, index));
        this.cache.set(pos, n);
        return (Col)((Entry)n).column;
    }

    @Override
    public void close(boolean erase) throws IOException {
    }

    @Override
    public String fileId() throws IOException {
        throw new IOException("unsupported method");
    }

    @Override
    public int getColumnCount() throws IOException {
        return this.memoryAccessor.getColumnCount(this.part);
    }

    @Override
    public Iterator<Col> iterator() {
        throw new UnsupportedOperationException("unsupported method");
    }

    private static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<C extends Column> {
        private final int index;
        private final C column;

        public Entry(int index, C column) {
            this.index = index;
            this.column = column;
        }
    }
}

