/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.concurrent;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.concurrent.SemaphoreConcurrentToken;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.progress.ProgressAggregator;
import ch.javasoft.metabolic.efm.rankup.PreprocessableMatrix;
import java.io.IOException;

public class RankUpdateToken
extends SemaphoreConcurrentToken {
    public final InheritableThreadLocal<PreprocessableMatrix> rankMatrices = new InheritableThreadLocal<PreprocessableMatrix>(){

        @Override
        protected PreprocessableMatrix childValue(PreprocessableMatrix parentValue) {
            return parentValue == null ? null : parentValue.clone();
        }
    };

    public RankUpdateToken(EfmModel efmModel) {
        super(efmModel);
    }

    public RankUpdateToken(EfmModel efmModel, ProgressAggregator progress) throws IOException {
        super(efmModel, progress);
    }

    public PreprocessableMatrix getRankMatrix() {
        return (PreprocessableMatrix)this.rankMatrices.get();
    }

    public void removeChildRankMatrix() {
        PreprocessableMatrix mx = (PreprocessableMatrix)this.rankMatrices.get();
        this.rankMatrices.set(mx.parent);
    }

    public void addRootRankMatrix(IBitSet key) {
        PreprocessableMatrix rootMx = PreprocessableMatrix.createRootMatrix(key);
        this.rankMatrices.set(rootMx);
    }

    public void addChildRankMatrix(IBitSet key) {
        PreprocessableMatrix parent = (PreprocessableMatrix)this.rankMatrices.get();
        PreprocessableMatrix child = parent.createChild(key);
        this.rankMatrices.set(child);
    }

    public void removeRootRankMatrix() {
        this.rankMatrices.set(null);
    }
}

