/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.column;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.jbase.EntityMarshaller;
import ch.javasoft.jbase.VariableWidthTable;
import ch.javasoft.jbase.concurrent.ConcurrentTable;
import ch.javasoft.math.BigFraction;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.math.ops.BigIntegerOperations;
import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.column.AbstractColumn;
import ch.javasoft.metabolic.efm.column.AbstractHome;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.memory.outcore.Cache;
import ch.javasoft.metabolic.efm.model.ColumnInspectorModifier;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.IterationStateModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.util.BitSetUtil;
import ch.javasoft.metabolic.impl.FractionNumberFluxDistribution;
import ch.javasoft.smx.iface.ReadableBigIntegerMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerMatrix;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.util.numeric.BigIntegerUtil;
import ch.javasoft.util.numeric.Zero;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableIntegerColumn
extends AbstractColumn {
    private int mBoolSize;
    private int mNumeSize;
    private final IBitSet mBitSet;
    private int[] mNumericRaw;
    public static final Home HOME = new Home(){

        @Override
        public Arithmetic getArithmetic() {
            return Arithmetic.bigint;
        }

        @Override
        public NumberOperations<BigInteger> getNumberOperations() {
            return BigIntegerOperations.instance();
        }

        @Override
        public VariableIntegerColumn newInstance(int booleanSize, int numericSize) {
            throw new RuntimeException("not implemented");
        }

        public VariableIntegerColumn[] newInstances(ReadableMatrix<BigInteger> matrix, int booleanSize) {
            int rows = matrix.getRowCount();
            int cols = matrix.getColumnCount();
            VariableIntegerColumn[] res = new VariableIntegerColumn[cols];
            int col = 0;
            while (col < cols) {
                BigInteger[] vals = new BigInteger[rows];
                int row = 0;
                while (row < rows) {
                    vals[row] = matrix.getNumberValueAt(row, col);
                    ++row;
                }
                res[col] = new VariableIntegerColumn(booleanSize, vals.length, BitSetUtil.factory().create(rows), VariableIntegerColumn.fromBigInteger(vals));
                ++col;
            }
            return res;
        }

        @Override
        public VariableIntegerColumn readFrom(DataInput dataIn, int booleanSize, int numericSize) throws IOException {
            IBitSet bitSet = this.readBinaryFrom(dataIn, booleanSize);
            int len = dataIn.readInt();
            int[] arr = new int[len];
            int i = 0;
            while (i < len) {
                arr[i] = dataIn.readInt();
                ++i;
            }
            return new VariableIntegerColumn(booleanSize, numericSize, bitSet, arr);
        }

        @Override
        public void writeTo(VariableIntegerColumn column, DataOutput dataOut) throws IOException {
            this.writeBinaryTo(column, dataOut);
            dataOut.writeInt(column.mNumericRaw.length);
            int i = 0;
            while (i < column.mNumericRaw.length) {
                dataOut.writeInt(column.mNumericRaw[i]);
                ++i;
            }
        }

        @Override
        public EntityMarshaller<VariableIntegerColumn> getEntityMarshaller(final int booleanSize, final int numericSize) throws IOException {
            return new EntityMarshaller<VariableIntegerColumn>(){

                @Override
                public VariableIntegerColumn readFrom(DataInput in) throws IOException {
                    return (VariableIntegerColumn)HOME.readFrom(in, booleanSize, numericSize);
                }

                @Override
                public void writeTo(VariableIntegerColumn entity, DataOutput out) throws IOException {
                    HOME.writeTo(entity, out);
                }
            };
        }

        @Override
        public ConcurrentTable<VariableIntegerColumn> createTable(File folder, String fileName, int booleanSize, int numericSize) throws IOException {
            int boolByteLen = BitSetUtil.byteSize(booleanSize);
            int numericByteLen = 4 + numericSize * 8;
            return new ConcurrentTable<VariableIntegerColumn>(VariableWidthTable.create(folder, fileName, boolByteLen + numericByteLen, this.getEntityMarshaller(booleanSize, numericSize), Cache.BigIntegerMemoryTable.getCacheTableSize(), Cache.BigIntegerMemoryTable.getCacheEntrySize()));
        }

        @Override
        public ConcurrentTable<VariableIntegerColumn> openTable(File folder, String fileName, int booleanSize, int numericSize) throws IOException {
            return new ConcurrentTable<VariableIntegerColumn>(VariableWidthTable.open(folder, fileName, this.getEntityMarshaller(booleanSize, numericSize), Cache.BigIntegerMemoryTable.getCacheTableSize(), Cache.BigIntegerMemoryTable.getCacheEntrySize()));
        }

        public FluxDistribution createFluxDistribution(MetabolicNetwork net, BigInteger[] values) {
            return new FractionNumberFluxDistribution(net, values);
        }

        @Override
        public ReadableMatrix<BigInteger> convertMatrix(ReadableMatrix matrix, boolean allowRowScaling, boolean allowColumnScaling) {
            if (matrix instanceof ReadableBigIntegerMatrix) {
                return ((ReadableBigIntegerMatrix)matrix).toBigIntegerMatrix(false);
            }
            int rows = matrix.getRowCount();
            int cols = matrix.getColumnCount();
            DefaultBigIntegerMatrix mx = new DefaultBigIntegerMatrix(rows, cols);
            if (allowRowScaling) {
                int row = 0;
                while (row < rows) {
                    BigInteger lcm = BigInteger.ONE;
                    int col = 0;
                    while (col < cols) {
                        BigFraction val = BigFraction.valueOf(matrix.getNumberValueAt(row, col));
                        lcm = BigIntegerUtil.lcm(lcm, val.getDenominator());
                        ++col;
                    }
                    BigFraction scale = BigFraction.valueOf(lcm.abs());
                    int col2 = 0;
                    while (col2 < cols) {
                        BigFraction val = BigFraction.valueOf(matrix.getNumberValueAt(row, col2));
                        BigFraction scaled = val.multiply(scale).reduce();
                        if (!scaled.isInteger()) {
                            throw new RuntimeException("internal error: could not scale to integer: " + scaled);
                        }
                        mx.setValueAt(row, col2, scaled.toBigInteger());
                        ++col2;
                    }
                    ++row;
                }
            } else if (allowColumnScaling) {
                int col = 0;
                while (col < cols) {
                    BigInteger lcm = BigInteger.ONE;
                    int row = 0;
                    while (row < rows) {
                        BigFraction val = BigFraction.valueOf(matrix.getNumberValueAt(row, col));
                        lcm = BigIntegerUtil.lcm(lcm, val.getDenominator());
                        ++row;
                    }
                    BigFraction scale = BigFraction.valueOf(lcm.abs());
                    int row2 = 0;
                    while (row2 < rows) {
                        BigFraction val = BigFraction.valueOf(matrix.getNumberValueAt(row2, col));
                        BigFraction scaled = val.multiply(scale).reduce();
                        if (!scaled.isInteger()) {
                            throw new RuntimeException("internal error: could not scale to integer: " + scaled);
                        }
                        mx.setValueAt(row2, col, scaled.toBigInteger());
                        ++row2;
                    }
                    ++col;
                }
            } else {
                throw new IllegalArgumentException("either allowRowScaling or allowColumnScaling must be true");
            }
            return mx;
        }

        @Override
        public ReadableMatrix<BigInteger> castMatrix(ReadableMatrix matrix) {
            if (matrix instanceof ReadableBigIntegerMatrix) {
                return ((ReadableBigIntegerMatrix)matrix).toBigIntegerMatrix(false);
            }
            throw new ClassCastException("not a ReadableBigIntegerMatrix: " + matrix.getClass().getName());
        }

        @Override
        public VariableIntegerColumn castColumn(Column column) {
            return (VariableIntegerColumn)column;
        }

        @Override
        public BigInteger castNumber(Number number) {
            return (BigInteger)number;
        }

        @Override
        public int rank(ReadableMatrix matrix, Zero zero) {
            return new Gauss(zero.mZeroPos).rank((ReadableBigIntegerRationalMatrix)matrix);
        }
    };

    public VariableIntegerColumn(int boolSize) {
        this.mBoolSize = boolSize;
        this.mNumeSize = 0;
        this.mBitSet = BitSetUtil.factory().create(boolSize);
        this.mNumericRaw = new int[0];
    }

    protected VariableIntegerColumn(int boolSize, int numSize, IBitSet bitSet, int[] values) {
        this.mBoolSize = boolSize;
        this.mNumeSize = numSize;
        this.mBitSet = bitSet;
        this.mNumericRaw = values;
    }

    @Override
    public IBitSet bitValues() {
        return this.mBitSet;
    }

    @Override
    public <N extends Number> N getNumeric(ColumnHome<N, ?> columnHome, int row) {
        BigInteger val = VariableIntegerColumn.toBigInteger(this.mNumericRaw, row);
        return columnHome.castNumber(val);
    }

    private BigInteger[] toBigInteger() {
        BigInteger[] res = new BigInteger[this.mNumeSize];
        int i = 0;
        while (i < this.mNumeSize) {
            res[i] = VariableIntegerColumn.toBigInteger(this.mNumericRaw, i);
            ++i;
        }
        return res;
    }

    private static BigInteger toBigInteger(int[] raw, int row) {
        int offset = VariableIntegerColumn.getOffset(raw, row);
        int first = raw[offset];
        if ((first & 0x40000000) != 0) {
            return BigInteger.valueOf(first << 2 >> 2);
        }
        if ((first & Integer.MIN_VALUE) != 0) {
            long value = (long)first << 32 | (long)raw[offset + 1];
            return BigInteger.valueOf(value << 1 >> 1);
        }
        int bytelen = first;
        int intlen = (bytelen + 3) / 4;
        byte[] bytes = new byte[bytelen];
        int firstval = raw[offset + 1];
        int byteoff = 0;
        if (bytelen % 4 == 0) {
            bytes[byteoff++] = (byte)(firstval >>> 24);
        }
        if (byteoff > 0 || 3 == bytelen % 4) {
            bytes[byteoff++] = (byte)(firstval >>> 16);
        }
        if (byteoff > 0 || 2 == bytelen % 4) {
            bytes[byteoff++] = (byte)(firstval >>> 8);
        }
        bytes[byteoff++] = (byte)firstval;
        int i = 1;
        while (i < intlen) {
            int intval = raw[offset + i + 1];
            bytes[byteoff++] = (byte)(intval >>> 24);
            bytes[byteoff++] = (byte)(intval >>> 16);
            bytes[byteoff++] = (byte)(intval >>> 8);
            bytes[byteoff++] = (byte)intval;
            ++i;
        }
        return new BigInteger(bytes);
    }

    private static int getOffset(int[] raw, int row) {
        int offset = 0;
        while (row != 0) {
            int first = raw[offset];
            if ((first & 0x40000000) != 0) {
                ++offset;
            } else if ((first & Integer.MIN_VALUE) != 0) {
                offset += 2;
            } else {
                int bytelen = first;
                int intlen = (bytelen + 3) / 4;
                ++offset;
                offset += intlen;
            }
            --row;
        }
        return offset;
    }

    private static int toSignum(int[] raw, int row) {
        int offset = VariableIntegerColumn.getOffset(raw, row);
        int first = raw[offset];
        if ((first & 0x40000000) != 0) {
            int intval = first << 2 >> 2;
            return intval == 0 ? 0 : (intval < 0 ? -1 : 1);
        }
        if ((first & Integer.MIN_VALUE) != 0) {
            int intval = first << 1 >> 1;
            return intval == 0 ? 0 : (intval < 0 ? -1 : 1);
        }
        int bytelen = first;
        int firstval = raw[offset + 1];
        byte byteval = bytelen % 4 == 0 ? (byte)(firstval >>> 24) : (offset > 0 || 3 == bytelen % 4 ? (byte)(firstval >>> 16) : (offset > 0 || 2 == bytelen % 4 ? (byte)(firstval >>> 8) : (byte)firstval));
        return byteval == 0 ? 0 : (byteval < 0 ? -1 : 1);
    }

    private static int computeArrayLength(BigInteger[] values) {
        int size = 0;
        int i = 0;
        while (i < values.length) {
            int bitlen = values[i].bitLength();
            int signum = values[i].signum();
            if (signum >= 0 && bitlen <= 30 || bitlen < 30) {
                ++size;
            } else if (signum >= 0 && bitlen <= 63 || bitlen < 63) {
                size += 2;
            } else {
                int bytelen = (int)Math.ceil((bitlen + 1) / 8);
                int intlen = (bytelen + 3) / 4;
                size += intlen + 1;
            }
            ++i;
        }
        return size;
    }

    private static int[] fromBigInteger(BigInteger[] values) {
        int len = VariableIntegerColumn.computeArrayLength(values);
        int[] raw = new int[len];
        int offset = 0;
        int i = 0;
        while (i < values.length) {
            offset += VariableIntegerColumn.fromBigInteger(values[i], raw, offset);
            ++i;
        }
        return raw;
    }

    private static int fromBigInteger(BigInteger value, int[] raw, int offset) {
        int bitlen = value.bitLength();
        int signum = value.signum();
        if (signum >= 0 && bitlen <= 30 || bitlen < 30) {
            raw[offset] = 0x40000000 | value.intValue();
            return 1;
        }
        if (signum >= 0 && bitlen <= 63 || bitlen < 63) {
            long longval = value.longValue();
            raw[offset] = Integer.MIN_VALUE | (int)(longval >> 32);
            raw[offset + 1] = (int)longval;
            return 2;
        }
        byte[] bytes = value.toByteArray();
        raw[offset++] = bytes.length;
        int intval = 0;
        int byteoff = 0;
        while ((bytes.length - byteoff) % 4 != 0) {
            intval <<= 8;
            intval = bytes[byteoff];
            ++byteoff;
        }
        raw[offset++] = intval;
        int i = byteoff;
        while (i < bytes.length) {
            intval = bytes[byteoff] << 24;
            intval |= bytes[byteoff + 1] << 16;
            intval |= bytes[byteoff + 2] << 8;
            raw[offset++] = intval |= bytes[byteoff + 3];
            i += 4;
        }
        int intlen = (bytes.length + 3) / 4;
        return intlen + 1;
    }

    @Override
    public int booleanSize() {
        return this.mBoolSize;
    }

    @Override
    public int numericSize() {
        return this.mNumeSize;
    }

    public int size() {
        return this.mBoolSize + this.mNumeSize;
    }

    @Override
    public int getNumericSignum(Zero zero, int row) {
        return VariableIntegerColumn.toSignum(this.mNumericRaw, row);
    }

    @Override
    public int getHyperplaneSign(EfmModel model, IterationStateModel iteration) {
        return VariableIntegerColumn.getColumnInspectorModifier(model, BigInteger.class, BigInteger[].class).getHyperplaneSign(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.toBigInteger(), iteration);
    }

    @Override
    public <Col extends Column> Col convert(ColumnHome<?, Col> columnHome, EfmModel model, IterationStepModel iteration, boolean clone) {
        BigInteger[] biValues = this.toBigInteger();
        ColumnInspectorModifier<BigInteger, BigInteger[]> modifier = VariableIntegerColumn.getColumnInspectorModifier(model, BigInteger.class, BigInteger[].class);
        IBitSet newBin = modifier.convertBinary(this.columnHome(), model, this.mBitSet, this.mBoolSize, biValues, iteration, clone);
        BigInteger[] newNum = modifier.convertNumeric(this.columnHome(), model, this.mBitSet, this.mBoolSize, biValues, iteration, clone);
        if (clone) {
            return columnHome.castColumn(new VariableIntegerColumn(iteration.getNextState().getBooleanSize(), newNum.length, newBin, VariableIntegerColumn.fromBigInteger(newNum)));
        }
        this.mBoolSize = iteration.getNextState().getBooleanSize();
        if (this.mBitSet != newBin) {
            this.mBitSet.clear();
            this.mBitSet.or(newBin);
        }
        this.mNumericRaw = VariableIntegerColumn.fromBigInteger(newNum);
        return columnHome.castColumn(this);
    }

    @Override
    public <Col extends Column> Col mergeWith(ColumnHome<?, Col> columnHome, EfmModel model, Col other, IterationStepModel iteration) {
        return columnHome.castColumn(this.mergeWith(model, (VariableIntegerColumn)other, iteration));
    }

    public VariableIntegerColumn mergeWith(EfmModel model, VariableIntegerColumn other, IterationStepModel iteration) {
        BigInteger[] myValues = this.toBigInteger();
        BigInteger[] otValues = other.toBigInteger();
        ColumnInspectorModifier<BigInteger, BigInteger[]> modifier = VariableIntegerColumn.getColumnInspectorModifier(model, BigInteger.class, BigInteger[].class);
        IBitSet newBin = modifier.mergeBinary(this.columnHome(), model, this.mBitSet, this.mBoolSize, myValues, other.mBitSet, other.mBoolSize, otValues, iteration);
        BigInteger[] newNum = modifier.mergeNumeric(this.columnHome(), model, this.mBitSet, this.mBoolSize, myValues, other.mBitSet, other.mBoolSize, otValues, iteration);
        return new VariableIntegerColumn(iteration.getNextState().getBooleanSize(), newNum.length, newBin, VariableIntegerColumn.fromBigInteger(newNum));
    }

    @Override
    public void writeTo(DataOutput dataOut) throws IOException {
        this.columnHome().writeTo(this, dataOut);
    }

    @Override
    public VariableIntegerColumn clone() {
        return new VariableIntegerColumn(this.mBoolSize, this.mNumeSize, this.mBitSet.clone(), (int[])this.mNumericRaw.clone());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof VariableIntegerColumn) {
            VariableIntegerColumn col = (VariableIntegerColumn)obj;
            return this.mBoolSize == col.mBoolSize && this.mBitSet.equals(col.mBitSet) && Arrays.equals(this.mNumericRaw, col.mNumericRaw);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        int ii = 0;
        while (ii < this.mBoolSize) {
            sb.append(this.mBitSet.get(ii) ? (char)'1' : '0');
            ++ii;
        }
        ii = 0;
        while (ii < this.mNumeSize) {
            if (this.mBoolSize > 0 || ii > 0) {
                sb.append(", ");
            }
            sb.append(VariableIntegerColumn.toBigInteger(this.mNumericRaw, ii));
            ++ii;
        }
        sb.append('}');
        return sb.toString();
    }

    public Home columnHome() {
        return HOME;
    }

    public static void main(String[] args) {
        System.out.println("int");
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{0x40000000}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{0x40000001}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{-1}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{0x4000004D}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{-77}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{Integer.MAX_VALUE}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{Integer.MAX_VALUE}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{0x5FFFFFFF}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{0x60000000}, 0));
        System.out.println("int sgn");
        System.out.println(VariableIntegerColumn.toSignum(new int[]{0x40000000}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{0x40000001}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{-1}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{0x4000004D}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{-77}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{Integer.MAX_VALUE}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{Integer.MAX_VALUE}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{0x5FFFFFFF}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{0x60000000}, 0));
        System.out.println("long");
        int[] nArray = new int[2];
        nArray[0] = -2147483647;
        System.out.println(VariableIntegerColumn.toBigInteger(nArray, 0));
        int[] nArray2 = new int[2];
        nArray2[0] = -2147483647;
        System.out.println(VariableIntegerColumn.toBigInteger(nArray2, 0));
        int[] nArray3 = new int[2];
        nArray3[0] = -1;
        System.out.println(VariableIntegerColumn.toBigInteger(nArray3, 0));
        int[] nArray4 = new int[2];
        nArray4[0] = -2147483571;
        System.out.println(VariableIntegerColumn.toBigInteger(nArray4, 0));
        int[] nArray5 = new int[2];
        nArray5[0] = -77;
        System.out.println(VariableIntegerColumn.toBigInteger(nArray5, 0));
        System.out.println("long sgn");
        int[] nArray6 = new int[2];
        nArray6[0] = -2147483647;
        System.out.println(VariableIntegerColumn.toSignum(nArray6, 0));
        int[] nArray7 = new int[2];
        nArray7[0] = -2147483647;
        System.out.println(VariableIntegerColumn.toSignum(nArray7, 0));
        int[] nArray8 = new int[2];
        nArray8[0] = -1;
        System.out.println(VariableIntegerColumn.toSignum(nArray8, 0));
        int[] nArray9 = new int[2];
        nArray9[0] = -2147483571;
        System.out.println(VariableIntegerColumn.toSignum(nArray9, 0));
        int[] nArray10 = new int[2];
        nArray10[0] = -77;
        System.out.println(VariableIntegerColumn.toSignum(nArray10, 0));
        System.out.println("bigint");
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{9, -1, -1, -1}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{8, -1, -1}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{7, 0xFFFFFF, -1}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{6, 65535, -1}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{5, 255, -1}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{9, 1, 1, 1}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{8, 1, 1}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{7, 0x7FFFFF, -1}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{6, Short.MAX_VALUE, -1}, 0));
        System.out.println(VariableIntegerColumn.toBigInteger(new int[]{5, 127, -1}, 0));
        System.out.println("bigint sgn");
        System.out.println(VariableIntegerColumn.toSignum(new int[]{9, -1, -1, -1}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{8, -1, -1}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{7, 0xFFFFFF, -1}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{6, 65535, -1}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{5, 255, -1}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{9, 1, 1, 1}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{8, Integer.MAX_VALUE, 1}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{7, 0x7FFFFF, -1}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{6, Short.MAX_VALUE, -1}, 0));
        System.out.println(VariableIntegerColumn.toSignum(new int[]{5, 127, -1}, 0));
        System.out.println("to/from");
        BigInteger[] vals = new BigInteger[]{BigInteger.valueOf(0L), BigInteger.valueOf(1L), BigInteger.valueOf(2L), BigInteger.valueOf(10L), BigInteger.valueOf(77L), BigInteger.valueOf(-1L), BigInteger.valueOf(-2L), BigInteger.valueOf(-10L), BigInteger.valueOf(-77L), BigInteger.valueOf(0x1FFFFFFFL), BigInteger.valueOf(0x3FFFFFFFL), BigInteger.valueOf(Integer.MAX_VALUE), BigInteger.valueOf(0x20000000L), BigInteger.valueOf(Integer.MAX_VALUE), BigInteger.valueOf(Integer.MIN_VALUE), BigInteger.valueOf(Long.MAX_VALUE), BigInteger.valueOf(Long.MIN_VALUE)};
        int[] raw = VariableIntegerColumn.fromBigInteger(vals);
        int i = 0;
        while (i < vals.length) {
            BigInteger toFrom = VariableIntegerColumn.toBigInteger(raw, i);
            if (!toFrom.equals(vals[i])) {
                throw new RuntimeException(vals[i] + " != " + toFrom);
            }
            System.out.println("vals[" + i + "] = " + vals[i]);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Home
    extends AbstractHome<BigInteger, VariableIntegerColumn>
    implements ColumnHome<BigInteger, VariableIntegerColumn> {
    }
}

