/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.column;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.math.varint.VarIntFactory;
import ch.javasoft.math.varint.VarIntNumber;
import ch.javasoft.math.varint.ops.VarIntOperations;
import ch.javasoft.smx.iface.BigIntegerMatrix;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.smx.ops.MatrixOperations;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarIntMatrix
implements ReadableBigIntegerMatrix<VarIntNumber>,
WritableMatrix<VarIntNumber> {
    private final BigIntegerMatrix matrix;

    public VarIntMatrix(BigIntegerMatrix matrix) {
        this.matrix = matrix;
    }

    public VarIntNumber[][] getNumberRows() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        VarIntNumber[][] data = new VarIntNumber[rows][cols];
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                data[r][c] = VarIntFactory.create(this.matrix.getBigIntegerValueAt(r, c));
                ++c;
            }
            ++r;
        }
        return data;
    }

    @Override
    public VarIntNumber getNumberValueAt(int row, int col) {
        return VarIntFactory.create((BigInteger)this.matrix.getNumberValueAt(row, col));
    }

    @Override
    public int getSignumAt(int row, int col) {
        return this.matrix.getSignumAt(row, col);
    }

    @Override
    public WritableMatrix<VarIntNumber> newInstance(int rows, int cols) {
        return new VarIntMatrix(this.matrix.newInstance(rows, cols));
    }

    public WritableMatrix<VarIntNumber> newInstance(VarIntNumber[][] data, boolean rowsInDim1) {
        int rows = data.length;
        BigInteger[][] bdata = new BigInteger[rows][];
        int r = 0;
        while (r < data.length) {
            int cols = data[r].length;
            bdata[r] = new BigInteger[cols];
            int c = 0;
            while (c < cols) {
                bdata[r][c] = data[r][c].toBigInteger();
                ++c;
            }
            ++r;
        }
        return new VarIntMatrix(this.matrix.newInstance(bdata, rowsInDim1));
    }

    @Override
    public WritableMatrix<VarIntNumber> toWritableMatrix(boolean enforceNewInstance) {
        return enforceNewInstance ? this.clone() : this;
    }

    public VarIntMatrix transpose() {
        return new VarIntMatrix(this.matrix.transpose());
    }

    @Override
    public int getColumnCount() {
        return this.matrix.getColumnCount();
    }

    @Override
    public MatrixOperations<VarIntNumber> getMatrixOperations() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public NumberOperations<VarIntNumber> getNumberOperations() {
        return VarIntOperations.instance();
    }

    @Override
    public int getRowCount() {
        return this.matrix.getRowCount();
    }

    @Override
    public String toMultilineString() {
        return this.matrix.toMultilineString();
    }

    @Override
    public void writeTo(Writer writer) {
        this.matrix.writeTo(writer);
    }

    @Override
    public void writeTo(OutputStream out) {
        this.matrix.writeTo(out);
    }

    @Override
    public void writeToMultiline(Writer writer) {
        this.matrix.writeToMultiline(writer);
    }

    @Override
    public void writeToMultiline(OutputStream out) {
        this.matrix.writeToMultiline(out);
    }

    @Override
    public void negate(int row, int col) {
        this.matrix.negate(row, col);
    }

    @Override
    public void setValueAt(int row, int col, VarIntNumber value) {
        this.matrix.setValueAt(row, col, value.toBigInteger());
    }

    @Override
    public void swapColumns(int colA, int colB) {
        this.matrix.swapColumns(colA, colB);
    }

    @Override
    public void swapRows(int rowA, int rowB) {
        this.matrix.swapRows(rowA, rowB);
    }

    @Override
    public ReadableMatrix<VarIntNumber> toReadableMatrix(boolean enforceNewInstance) {
        return enforceNewInstance ? this.clone() : this;
    }

    public VarIntMatrix clone() {
        return new VarIntMatrix(this.matrix.clone());
    }

    @Override
    public BigInteger[] getBigIntegerColumn(int col) {
        return this.matrix.getBigIntegerColumn(col);
    }

    @Override
    public BigInteger[][] getBigIntegerColumns() {
        return this.matrix.getBigIntegerColumns();
    }

    @Override
    public BigInteger[] getBigIntegerRow(int row) {
        return this.matrix.getBigIntegerRow(row);
    }

    @Override
    public BigInteger[][] getBigIntegerRows() {
        return this.matrix.getBigIntegerRows();
    }

    @Override
    public BigInteger getBigIntegerValueAt(int row, int col) {
        return this.matrix.getBigIntegerValueAt(row, col);
    }

    @Override
    public ReadableBigIntegerMatrix subBigIntegerMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.matrix.subBigIntegerMatrix(rowStart, rowEnd, colStart, colEnd);
    }

    @Override
    public void toArray(BigInteger[] array) {
        this.matrix.toArray(array);
    }

    @Override
    public BigInteger[] toBigIntegerArray() {
        return this.matrix.toBigIntegerArray();
    }

    @Override
    public BigIntegerMatrix toBigIntegerMatrix(boolean enforceNewInstance) {
        return this.matrix.toBigIntegerMatrix(enforceNewInstance);
    }

    @Override
    public BigFraction getBigFractionValueAt(int row, int col) {
        return this.matrix.getBigFractionValueAt(row, col);
    }

    @Override
    public BigInteger getBigIntegerDenominatorAt(int row, int col) {
        return this.matrix.getBigIntegerDenominatorAt(row, col);
    }

    @Override
    public BigInteger getBigIntegerNumeratorAt(int row, int col) {
        return this.matrix.getBigIntegerNumeratorAt(row, col);
    }

    @Override
    public BigIntegerRationalMatrix subBigIntegerRationalMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.matrix.subBigIntegerRationalMatrix(rowStart, rowEnd, colStart, colEnd);
    }

    @Override
    public BigIntegerRationalMatrix toBigIntegerRationalMatrix(boolean enforceNewInstance) {
        return this.matrix.toBigIntegerRationalMatrix(enforceNewInstance);
    }

    @Override
    public double[] getDoubleColumn(int col) {
        return this.matrix.getDoubleColumn(col);
    }

    @Override
    public double[][] getDoubleColumns() {
        return this.matrix.getDoubleColumns();
    }

    @Override
    public double[] getDoubleRow(int row) {
        return this.matrix.getDoubleRow(row);
    }

    @Override
    public double[][] getDoubleRows() {
        return this.matrix.getDoubleRows();
    }

    @Override
    public double getDoubleValueAt(int row, int col) {
        return this.matrix.getDoubleValueAt(row, col);
    }

    @Override
    public DoubleMatrix subDoubleMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        return this.matrix.subDoubleMatrix(rowStart, rowEnd, colStart, colEnd);
    }

    @Override
    public void toArray(double[] array) {
        this.matrix.toArray(array);
    }

    @Override
    public double[] toDoubleArray() {
        return this.matrix.toDoubleArray();
    }

    @Override
    public DoubleMatrix toDoubleMatrix(boolean enforceNewInstance) {
        return this.matrix.toDoubleMatrix(enforceNewInstance);
    }
}

