/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.column;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.jbase.FixedWidthMarshaller;
import ch.javasoft.jbase.FixedWidthTable;
import ch.javasoft.jbase.concurrent.ConcurrentTable;
import ch.javasoft.math.ops.DoubleOperations;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.column.AbstractColumn;
import ch.javasoft.metabolic.efm.column.AbstractHome;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.memory.outcore.Cache;
import ch.javasoft.metabolic.efm.model.ColumnInspectorModifier;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.IterationStateModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.util.BitSetUtil;
import ch.javasoft.metabolic.impl.DefaultFluxDistribution;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.util.numeric.Zero;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleColumn
extends AbstractColumn {
    private int mBoolSize;
    private final IBitSet mBitSet;
    private double[] mValues;
    public static final Home HOME = new Home(){

        @Override
        public Arithmetic getArithmetic() {
            return Arithmetic.double_;
        }

        public DoubleOperations getNumberOperations() {
            return DoubleOperations.instance();
        }

        @Override
        public DoubleColumn newInstance(int booleanSize, int numericSize) {
            return new DoubleColumn(booleanSize, numericSize);
        }

        public DoubleColumn[] newInstances(ReadableMatrix<Double> matrix, int booleanSize) {
            int rows = matrix.getRowCount();
            int cols = matrix.getColumnCount();
            DoubleColumn[] res = new DoubleColumn[cols];
            int col = 0;
            while (col < cols) {
                res[col] = new DoubleColumn(booleanSize, rows);
                double[] vals = res[col].mValues;
                int row = 0;
                while (row < rows) {
                    vals[row] = matrix.getNumberValueAt(row, col);
                    ++row;
                }
                ++col;
            }
            return res;
        }

        @Override
        public DoubleColumn readFrom(DataInput dataIn, int booleanSize, int numericSize) throws IOException {
            IBitSet bitSet = this.readBinaryFrom(dataIn, booleanSize);
            double[] dbls = new double[numericSize];
            int i = 0;
            while (i < numericSize) {
                dbls[i] = dataIn.readDouble();
                ++i;
            }
            return new DoubleColumn(booleanSize, bitSet, dbls);
        }

        @Override
        public void writeTo(DoubleColumn column, DataOutput dataOut) throws IOException {
            this.writeBinaryTo(column, dataOut);
            int i = 0;
            while (i < column.mValues.length) {
                dataOut.writeDouble(column.mValues[i]);
                ++i;
            }
        }

        @Override
        public FixedWidthMarshaller<DoubleColumn> getEntityMarshaller(final int booleanSize, final int numericSize) throws IOException {
            final int byteWidth = BitSetUtil.byteSize(booleanSize) + numericSize * 8;
            return new FixedWidthMarshaller<DoubleColumn>(){

                @Override
                public int getByteWidth() {
                    return byteWidth;
                }

                @Override
                public DoubleColumn readFrom(DataInput in) throws IOException {
                    return (DoubleColumn)HOME.readFrom(in, booleanSize, numericSize);
                }

                @Override
                public void writeTo(DoubleColumn entity, DataOutput out) throws IOException {
                    HOME.writeTo(entity, out);
                }
            };
        }

        @Override
        public ConcurrentTable<DoubleColumn> createTable(File folder, String fileName, int booleanSize, int numericSize) throws IOException {
            return new ConcurrentTable<DoubleColumn>(FixedWidthTable.create(new File(folder, fileName), this.getEntityMarshaller(booleanSize, numericSize), Cache.DoubleMemoryTable.getCacheTableSize(), Cache.DoubleMemoryTable.getCacheEntrySize()));
        }

        @Override
        public ConcurrentTable<DoubleColumn> openTable(File folder, String fileName, int booleanSize, int numericSize) throws IOException {
            return new ConcurrentTable<DoubleColumn>(FixedWidthTable.open(new File(folder, fileName), this.getEntityMarshaller(booleanSize, numericSize), Cache.DoubleMemoryTable.getCacheTableSize(), Cache.DoubleMemoryTable.getCacheEntrySize()));
        }

        public DefaultFluxDistribution createFluxDistribution(MetabolicNetwork net, Double[] values) {
            double[] vals = new double[values.length];
            int i = 0;
            while (i < vals.length) {
                vals[i] = values[i];
                ++i;
            }
            return this.createFluxDistribution(net, vals);
        }

        public DefaultFluxDistribution createFluxDistribution(MetabolicNetwork net, double[] values) {
            return new DefaultFluxDistribution(net, values);
        }

        @Override
        public ReadableMatrix<Double> convertMatrix(ReadableMatrix matrix, boolean allowRowScaling, boolean allowColumnScaling) {
            if (matrix instanceof ReadableDoubleMatrix) {
                return ((ReadableDoubleMatrix)matrix).toDoubleMatrix(false);
            }
            int rows = matrix.getRowCount();
            int cols = matrix.getColumnCount();
            DefaultDoubleMatrix mx = new DefaultDoubleMatrix(rows, cols);
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    mx.setValueAt(row, col, ((Number)matrix.getNumberValueAt(row, col)).doubleValue());
                    ++col;
                }
                ++row;
            }
            return mx;
        }

        @Override
        public ReadableMatrix<Double> castMatrix(ReadableMatrix matrix) {
            if (matrix instanceof ReadableDoubleMatrix) {
                return ((ReadableDoubleMatrix)matrix).toDoubleMatrix(false);
            }
            throw new ClassCastException("not a ReadableDoubleMatrix: " + matrix.getClass().getName());
        }

        @Override
        public DoubleColumn castColumn(Column column) {
            return (DoubleColumn)column;
        }

        @Override
        public Double castNumber(Number number) {
            return (Double)number;
        }

        @Override
        public int rank(ReadableMatrix matrix, Zero zero) {
            return new Gauss(zero.mZeroPos).rank((ReadableDoubleMatrix)matrix);
        }
    };

    public DoubleColumn(int boolSize) {
        this(boolSize, 0);
    }

    public DoubleColumn(int boolSize, int doubleSize) {
        this.mBoolSize = boolSize;
        this.mBitSet = BitSetUtil.factory().create(boolSize);
        this.mValues = new double[doubleSize];
    }

    protected DoubleColumn(int boolSize, IBitSet bitSet, double[] values) {
        this.mBoolSize = boolSize;
        this.mBitSet = bitSet;
        this.mValues = values;
    }

    @Override
    public IBitSet bitValues() {
        return this.mBitSet;
    }

    @Override
    public int getNumericSignum(Zero zero, int row) {
        return zero.sgn(this.mValues[row]);
    }

    @Override
    public int getHyperplaneSign(EfmModel model, IterationStateModel iteration) {
        return DoubleColumn.getColumnInspectorModifier(model, Double.class, double[].class).getHyperplaneSign(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.mValues, iteration);
    }

    @Override
    public <Col extends Column> Col convert(ColumnHome<?, Col> columnHome, EfmModel model, IterationStepModel iteration, boolean clone) {
        ColumnInspectorModifier<Double, double[]> modifier = DoubleColumn.getColumnInspectorModifier(model, Double.class, double[].class);
        IBitSet newBin = modifier.convertBinary(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.mValues, iteration, clone);
        double[] newNum = modifier.convertNumeric(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.mValues, iteration, clone);
        if (clone) {
            return columnHome.castColumn(new DoubleColumn(iteration.getNextState().getBooleanSize(), newBin, newNum));
        }
        this.mBoolSize = iteration.getNextState().getBooleanSize();
        if (this.mBitSet != newBin) {
            this.mBitSet.clear();
            this.mBitSet.or(newBin);
        }
        this.mValues = newNum;
        return columnHome.castColumn(this);
    }

    @Override
    public <Col extends Column> Col mergeWith(ColumnHome<?, Col> columnHome, EfmModel model, Col other, IterationStepModel iteration) {
        return columnHome.castColumn(this.mergeWith(model, (DoubleColumn)other, iteration));
    }

    public DoubleColumn mergeWith(EfmModel model, DoubleColumn other, IterationStepModel iteration) {
        ColumnInspectorModifier<Double, double[]> modifier = DoubleColumn.getColumnInspectorModifier(model, Double.class, double[].class);
        IBitSet newBin = modifier.mergeBinary(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.mValues, other.mBitSet, other.mBoolSize, other.mValues, iteration);
        double[] newNum = modifier.mergeNumeric(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.mValues, other.mBitSet, other.mBoolSize, other.mValues, iteration);
        return new DoubleColumn(iteration.getNextState().getBooleanSize(), newBin, newNum);
    }

    @Override
    public int booleanSize() {
        return this.mBoolSize;
    }

    @Override
    public int numericSize() {
        return this.mValues.length;
    }

    public int size() {
        return this.mBoolSize + this.mValues.length;
    }

    @Override
    public <N extends Number> N getNumeric(ColumnHome<N, ?> columnHome, int row) {
        return columnHome.castNumber(this.mValues[row]);
    }

    @Override
    public DoubleColumn clone() {
        return new DoubleColumn(this.mBoolSize, this.mBitSet.clone(), (double[])this.mValues.clone());
    }

    @Override
    public void writeTo(DataOutput dataOut) throws IOException {
        this.columnHome().writeTo(this, dataOut);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DoubleColumn) {
            DoubleColumn col = (DoubleColumn)obj;
            return this.mBoolSize == col.mBoolSize && this.mBitSet.equals(col.mBitSet) && Arrays.equals(this.mValues, col.mValues);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        int ii = 0;
        while (ii < this.mBoolSize) {
            sb.append(this.mBitSet.get(ii) ? (char)'1' : '0');
            ++ii;
        }
        ii = 0;
        while (ii < this.mValues.length) {
            if (this.mBoolSize > 0 || ii > 0) {
                sb.append(", ");
            }
            sb.append(this.mValues[ii]);
            ++ii;
        }
        sb.append('}');
        return sb.toString();
    }

    public Home columnHome() {
        return HOME;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Home
    extends AbstractHome<Double, DoubleColumn>
    implements ColumnHome<Double, DoubleColumn> {
    }
}

