/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.borndie.matrix;

import ch.javasoft.metabolic.efm.borndie.range.CellRange;
import ch.javasoft.metabolic.efm.borndie.range.DefaultRectangularRange;
import ch.javasoft.metabolic.efm.borndie.range.LowerTriangularMatrix;
import ch.javasoft.metabolic.efm.borndie.range.RectangularRange;

public class PairingRule {
    private final LowerTriangularMatrix matrix;
    private final CellRange cell;

    public PairingRule(LowerTriangularMatrix matrix, CellRange cell) {
        if (!matrix.contains(cell)) {
            throw new IllegalArgumentException("cell not contained in born/die matrix: " + cell + " not in " + matrix);
        }
        this.matrix = matrix;
        this.cell = cell;
    }

    public int getIterationCount() {
        return this.matrix.getRowCount() - 1;
    }

    public RectangularRange getPartnerCells() {
        return new DefaultRectangularRange(0, this.cell.getDieRow() + 1, this.cell.getDieRow() + 1, this.getIterationCount() + 1);
    }
}

