/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree.search;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.adj.incore.tree.AbstractRoot;
import ch.javasoft.metabolic.efm.adj.incore.tree.Node;
import ch.javasoft.metabolic.efm.adj.incore.tree.TreeFactory;
import ch.javasoft.metabolic.efm.column.AdjCandidates;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.EfmModel;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearSearchRoot<T>
extends AbstractRoot<T> {
    private final int mRequiredZeroCount;

    public LinearSearchRoot(Config config, EfmModel model, TreeFactory<T> treeFactory, int requiredZeroCount, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols) throws IOException {
        super(config, model, treeFactory, posCols, zeroCols, negCols);
        this.mRequiredZeroCount = requiredZeroCount;
    }

    @Override
    public boolean isRequiredZeroBitCount(T token, int count) {
        return count >= this.mRequiredZeroCount;
    }

    @Override
    public void filterAdjacentPairs(T token, Node<T> nodeA, Node<T> nodeB, IBitSet filterCutPattern, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, AdjCandidates<Column> candidates) throws IOException {
        int len = candidates.size();
        int index = 0;
        while (index < len) {
            if (this.hasSuperSet(candidates, index, zeroCols) || this.hasSuperSet(candidates, index, posCols) || this.hasSuperSet(candidates, index, negCols)) {
                if (index != --len) {
                    candidates.swap(index, len);
                }
                candidates.removeLast();
                continue;
            }
            ++index;
        }
    }

    private boolean hasSuperSet(AdjCandidates<Column> candidates, int pairIndex, SortableMemory<Column> cols) throws IOException {
        return candidates.hasSuperSet(pairIndex, cols, 0, cols.getColumnCount());
    }
}

