/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree;

import ch.javasoft.metabolic.efm.adj.incore.tree.AbstractTreeFactory;
import ch.javasoft.metabolic.efm.adj.incore.tree.InterNode;
import ch.javasoft.metabolic.efm.adj.incore.tree.Node;
import ch.javasoft.metabolic.efm.adj.incore.tree.PoolToken;
import ch.javasoft.metabolic.efm.adj.incore.tree.Root;
import ch.javasoft.metabolic.efm.adj.incore.tree.ThreadPoolToken;
import ch.javasoft.metabolic.efm.adj.incore.tree.Traverser;
import ch.javasoft.metabolic.efm.adj.incore.tree.TreeFactory;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnPair;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.EfmModel;
import java.io.IOException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolTreeFactory
extends AbstractTreeFactory<PoolToken> {
    private final PoolToken token;

    public PoolTreeFactory(EfmModel efmModel) {
        super(efmModel);
        this.token = new ThreadPoolToken(efmModel);
    }

    @Override
    public InterNode<PoolToken> createInterNode(SortableMemory<Column> cols, int[] selectiveBits, int prevSelBitIndex, int iStart, int iEnd) throws IOException {
        return new InterNode<PoolToken>((TreeFactory)this, cols, selectiveBits, prevSelBitIndex, iStart, iEnd){

            @Override
            public void addAdjacentPairs(PoolToken token, Root<PoolToken> root, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, Node<PoolToken> partner, boolean thisIsPos, Queue<ColumnPair> adjacentPairs) throws IOException {
                if (!token.scheduleAsJob(token, root, posCols, zeroCols, negCols, this, partner, thisIsPos, adjacentPairs) && root.enterIfCandidates(token, this, partner)) {
                    if (partner instanceof InterNode) {
                        InterNode interPartner = (InterNode)partner;
                        this.child0.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child0, thisIsPos, adjacentPairs);
                        this.child0.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child1, thisIsPos, adjacentPairs);
                        this.child1.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child0, thisIsPos, adjacentPairs);
                        this.child1.addAdjacentPairs(token, root, posCols, zeroCols, negCols, interPartner.child1, thisIsPos, adjacentPairs);
                    } else {
                        this.child0.addAdjacentPairs(token, root, posCols, zeroCols, negCols, partner, thisIsPos, adjacentPairs);
                        this.child1.addAdjacentPairs(token, root, posCols, zeroCols, negCols, partner, thisIsPos, adjacentPairs);
                    }
                    root.leave(token, this, partner);
                }
            }
        };
    }

    @Override
    public Traverser<PoolToken> createTraverser() {
        return new Traverser<PoolToken>(){

            @Override
            public void traverseTree(Root<PoolToken> root, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols, Queue<ColumnPair> adjacentPairs) throws IOException {
                if (!PoolTreeFactory.this.token.scheduleAsJob(PoolTreeFactory.this.token, root, posCols, zeroCols, negCols, root.pos(), root.neg(), true, adjacentPairs)) {
                    root.pos().addAdjacentPairs(PoolTreeFactory.this.token, root, posCols, zeroCols, negCols, root.neg(), true, adjacentPairs);
                }
                PoolTreeFactory.this.token.execMainThread();
            }
        };
    }
}

