/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree;

import ch.javasoft.math.BigFraction;
import ch.javasoft.metabolic.efm.adj.incore.tree.Node;
import ch.javasoft.metabolic.efm.adj.incore.tree.Root;
import ch.javasoft.metabolic.efm.adj.incore.tree.TreeFactory;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.memory.IndexableMemory;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.util.ColumnUtil;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.util.numeric.Zero;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRoot<T>
implements Root<T> {
    protected final Config mConfig;
    protected final EfmModel mModel;
    protected final TreeFactory<T> mTreeFactory;
    protected final int[] mSelectiveBits;
    protected final Node<T> mPos;
    protected final Node<T> mNeg;
    private static final float zeroToOneOptimum = 1.0f;

    public AbstractRoot(Config config, EfmModel model, TreeFactory<T> treeFactory, SortableMemory<Column> posCols, SortableMemory<Column> zeroCols, SortableMemory<Column> negCols) {
        this.mConfig = config;
        this.mModel = model;
        this.mTreeFactory = treeFactory;
        try {
            this.mSelectiveBits = AbstractRoot.calculateXorBitOrder(posCols, negCols);
            this.mPos = treeFactory.createNode(posCols, this.mSelectiveBits, -1, 0, posCols.getColumnCount());
            this.mNeg = treeFactory.createNode(negCols, this.mSelectiveBits, -1, 0, negCols.getColumnCount());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Zero zero() {
        return this.mConfig.zero();
    }

    @Override
    public Node<T> pos() {
        return this.mPos;
    }

    @Override
    public Node<T> neg() {
        return this.mNeg;
    }

    public int booleanSize() {
        return this.mSelectiveBits.length;
    }

    public int numericSize() {
        return this.getStoichRational().getColumnCount() - this.booleanSize();
    }

    public ReadableMatrix<BigFraction> getStoichRational() {
        return this.mModel.getStoichRational();
    }

    @Override
    public boolean enterIfCandidates(T token, Node<T> nodeA, Node<T> nodeB) {
        int interCard = nodeA.unionPattern.getAndCardinality(nodeB.unionPattern);
        return this.isRequiredZeroBitCount(token, interCard);
    }

    @Override
    public void leave(T token, Node<T> nodeA, Node<T> nodeB) {
    }

    public static int[] calculateCardinalityBitOrder(IndexableMemory<Column> ... columns) {
        try {
            int bitCount = ColumnUtil.getBooleanSize(columns[0]);
            int[][] cnt = new int[bitCount][3];
            int i = 0;
            while (i < columns.length) {
                int bit = 0;
                while (bit < bitCount) {
                    for (Column col : columns[i]) {
                        if (col.get(bit)) {
                            int[] nArray = cnt[bit];
                            nArray[1] = nArray[1] + 1;
                            continue;
                        }
                        int[] nArray = cnt[bit];
                        nArray[0] = nArray[0] + 1;
                    }
                    cnt[bit][2] = bit;
                    ++bit;
                }
                ++i;
            }
            return AbstractRoot.calculateBitOrder(cnt);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static int[] calculateXorBitOrder(IndexableMemory<Column> ... columns) {
        try {
            Random rnd = new Random();
            int bitCount = ColumnUtil.getBooleanSize(columns[0]);
            int[][] cnt = new int[bitCount][3];
            int i = 0;
            while (i < columns.length) {
                int colCount = columns[i].getColumnCount();
                int bit = 0;
                while (bit < bitCount) {
                    int j = 0;
                    while (j < 1024) {
                        Column col0 = columns[i].getColumn(rnd.nextInt(colCount));
                        Column col1 = columns[i].getColumn(rnd.nextInt(colCount));
                        if (col0.get(bit) != col1.get(bit)) {
                            int[] nArray = cnt[bit];
                            nArray[0] = nArray[0] + col0.bitValues().getXorCardinality(col1.bitValues());
                            int[] nArray2 = cnt[bit];
                            nArray2[1] = nArray2[1] + bitCount;
                        } else {
                            int[] nArray = cnt[bit];
                            nArray[1] = nArray[1] + 1;
                        }
                        ++j;
                    }
                    cnt[bit][2] = bit;
                    ++bit;
                }
                ++i;
            }
            return AbstractRoot.calculateBitOrder(cnt);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static int[] calculateBitOrder(int[][] cnt) {
        Arrays.sort(cnt, new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                float diff2;
                float rel1 = (float)o1[0] / (float)o1[1];
                float rel2 = (float)o2[0] / (float)o2[1];
                float diff1 = Math.abs(rel1 - 1.0f);
                return diff1 < (diff2 = Math.abs(rel2 - 1.0f)) ? -1 : (diff1 > diff2 ? 1 : 0);
            }
        });
        int[] result = new int[cnt.length];
        int ii = 0;
        while (ii < cnt.length) {
            result[ii] = cnt[ii][2];
            ++ii;
        }
        return result;
    }
}

