/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore;

import ch.javasoft.metabolic.efm.adj.incore.AbstractAdjacencyEnumerator;
import ch.javasoft.metabolic.efm.column.AdjCandidates;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnPair;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import java.io.IOException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSearchAdjacencyEnumerator
extends AbstractAdjacencyEnumerator {
    @Override
    public void adjacentPairs(Queue<ColumnPair> adjacentPairs, SortableMemory<Column> zerCols, SortableMemory<Column> posCols, SortableMemory<Column> negCols) throws IOException {
        int minCard = this.mModel.getRequiredCardinality();
        AdjCandidates<Column> candidates = new AdjCandidates<Column>(posCols, negCols, 1);
        int posCnt = posCols.getColumnCount();
        int negCnt = negCols.getColumnCount();
        int indP = 0;
        while (indP < posCnt) {
            Object colP = posCols.getColumn(indP);
            int indN = 0;
            while (indN < negCnt) {
                Object colN = negCols.getColumn(indN);
                int card = colP.bitValues().getAndCardinality(colN.bitValues());
                if (card >= minCard) {
                    candidates.add(posCols, indP, negCols, indN);
                    this.filterAdjacentPairs(zerCols, posCols, negCols, candidates);
                    candidates.appendPairsTo(adjacentPairs);
                    candidates.removeAll();
                }
                ++indN;
            }
            ++indP;
        }
    }

    protected abstract void filterAdjacentPairs(SortableMemory<Column> var1, SortableMemory<Column> var2, SortableMemory<Column> var3, AdjCandidates<Column> var4) throws IOException;
}

