/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.concurrent.RankUpdateToken;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.ModelPersister;
import ch.javasoft.metabolic.efm.progress.ProgressAggregator;
import ch.javasoft.metabolic.efm.rankup.modpi.ModIntPrimeMatrixFactory;
import ch.javasoft.metabolic.efm.tree.AdjacencyPrecondition;
import ch.javasoft.metabolic.efm.tree.BitPatternTree;
import ch.javasoft.metabolic.efm.tree.TreeMemAdjEnum;
import ch.javasoft.metabolic.efm.tree.TreePairTraverser;
import ch.javasoft.metabolic.efm.tree.concurrent.ConcurrentTreePairTraverser;
import ch.javasoft.metabolic.efm.tree.rankup.DefaultRankUpAdjacencyFilter;
import ch.javasoft.metabolic.efm.tree.rankup.DefaultRankUpAdjacencyPrecondition;
import ch.javasoft.metabolic.efm.util.PreconditionUtil;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModIntPrimeAdjEnum
extends TreeMemAdjEnum<RankUpdateToken> {
    protected AbstractModIntPrimeAdjEnum(String name) {
        super(name);
    }

    public ModelPersister getModelPersister() {
        throw new RuntimeException("subclass must override to support distributed computation");
    }

    @Override
    protected <Col extends Column, N extends Number> RankUpdateToken createToken(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> itModel, BitPatternTree posTree, BitPatternTree negTree, ProgressAggregator progress) throws IOException {
        RankUpdateToken token;
        RankUpdateToken rankUpdateToken = token = progress == null ? new RankUpdateToken(this.getEfmModel()) : new RankUpdateToken(this.getEfmModel(), progress);
        if (token.tryAcquirePermit()) {
            IBitSet unionCutPattern = posTree.root().unionPattern().getAnd(negTree.root().unionPattern());
            token.addRootRankMatrix(unionCutPattern);
            return token;
        }
        throw new RuntimeException("internal error: could not acquire permit to start main thread");
    }

    @Override
    protected <Col extends Column, N extends Number> void releaseToken(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> itModel, BitPatternTree posTree, BitPatternTree negTree, RankUpdateToken token) {
        token.removeRootRankMatrix();
        token.releasePermit();
        try {
            token.waitForChildThreads();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected <Col extends Column, N extends Number> TreePairTraverser<RankUpdateToken> createTreeTraverser(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, BitPatternTree posTree, BitPatternTree negTree, AdjacencyPrecondition<RankUpdateToken> precondition) {
        AdjacencyPrecondition<Object> precond = new DefaultRankUpAdjacencyPrecondition(columnHome, this.getEfmModel());
        if (precondition != null) {
            precond = PreconditionUtil.and(precondition, precond);
        }
        return new ConcurrentTreePairTraverser<RankUpdateToken>(this.getEfmModel(), precond, new DefaultRankUpAdjacencyFilter(columnHome, this.getEfmModel(), new ModIntPrimeMatrixFactory(this.getEfmModel())), iterationModel, posTree, negTree);
    }
}

