/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.compartment.CompartmentReaction;
import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.efm.ElementaryFluxModes;
import ch.javasoft.metabolic.efm.LogPkg;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.impl.SequentialDoubleDescriptionImpl;
import ch.javasoft.metabolic.efm.memory.incore.InCoreMemoryFactory;
import ch.javasoft.metabolic.efm.model.canonical.CanonicalEfmModelFactory;
import ch.javasoft.metabolic.fa.FaConstants;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.impl.FilteredMetabolicNetwork;
import ch.javasoft.metabolic.parse.FaColiTest;
import ch.javasoft.metabolic.parse.PalssonParser;
import ch.javasoft.metabolic.util.StoichiometricMatrices;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.smx.ops.HslGateway;
import ch.javasoft.util.IntArray;
import ch.javasoft.util.logging.Loggers;
import java.io.StringReader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColiTest
extends FaColiTest {
    private static final Logger LOG;
    private final String PROP_NAME_AMINO = "ColiTest.SingleAmino";

    static {
        CompressionMethod[] compression = CompressionMethod.STANDARD_NO_DUPLICATE;
        if (Config.initForJUnitTest("pattern-tree-minzero", "MostZerosOrAbsLexMin", compression, false, Arithmetic.double_)) {
            Loggers.getRootLogger().setLevel(Level.FINE);
            Config config = Config.getConfig();
            ElementaryFluxModes.setImpl(new SequentialDoubleDescriptionImpl(Config.getConfig(), new CanonicalEfmModelFactory(), new InCoreMemoryFactory()));
        }
        LOG = LogPkg.LOGGER;
    }

    @Override
    public void testNoEx() throws Exception {
        super.testNoEx();
    }

    @Override
    public void testAce() throws Exception {
        super.testAce();
    }

    @Override
    public void testAceAccumulate() throws Exception {
        super.testAceAccumulate();
    }

    @Override
    public void testAc() throws Exception {
        super.testAc();
    }

    @Override
    public void testAcAccumulate() throws Exception {
        super.testAcAccumulate();
    }

    @Override
    public void testSuc() throws Exception {
        super.testSuc();
    }

    @Override
    public void testGly() throws Exception {
        super.testGly();
    }

    @Override
    public void testStandard() throws Exception {
        super.testStandard();
    }

    @Override
    public void testStandardAccumulate() throws Exception {
        super.testStandardAccumulate();
    }

    @Override
    public void testGl() throws Exception {
        super.testGl();
    }

    @Override
    public void testGlX() throws Exception {
        super.testGlX();
    }

    @Override
    public void testGlX_MTHF_forward_only() throws Exception {
        super.testGlX_MTHF_forward_only();
    }

    public void testGlX_mueAtp() throws Exception {
        this.testGlX_mueAtp(60.0);
    }

    protected void testGlX_mueAtp(final double atpMMolPerGMue) throws Exception {
        ColiTest test = new ColiTest(){

            @Override
            public void testGlX_mueAtp() throws Exception {
                super.testGlX();
            }

            @Override
            protected void internalTestMetabolicNetwork(MetabolicNetwork network, Set<String> suppressedReactions) throws Exception {
                String mue = network.getReaction("mue").toString();
                String[][] mueAtp = new String[][]{{"mue", String.valueOf(atpMMolPerGMue) + " ATP + " + mue.substring(0, mue.length() - 2)}};
                CompartmentReaction[] addReacts = new PalssonParser(false).parseReactions(new StringReader(FaConstants.SuperNet.toString(mueAtp)));
                FilteredMetabolicNetwork fNet = new FilteredMetabolicNetwork(network);
                fNet.excludeReactions("ATPdrain", "mue");
                Reaction[] reacts = new Reaction[fNet.getReactions().length() + addReacts.length];
                fNet.getReactions().toArray(reacts);
                System.arraycopy(addReacts, 0, reacts, fNet.getReactions().length(), addReacts.length);
                DefaultMetabolicNetwork supNet = new DefaultMetabolicNetwork(reacts);
                super.internalTest(supNet, suppressedReactions);
            }
        };
        test.testGlX_mueAtp();
    }

    public void testGlSingleAmino() throws Exception {
        String amino = System.getProperty("ColiTest.SingleAmino");
        if (amino == null) {
            throw new IllegalStateException("missing system property ColiTest.SingleAmino");
        }
        super.testGl(amino);
    }

    public void testGlXSingleAmino() throws Exception {
        String amino = System.getProperty("ColiTest.SingleAmino");
        if (amino == null) {
            throw new IllegalStateException("missing system property ColiTest.SingleAmino");
        }
        super.testGlX(amino);
    }

    @Override
    public void testGlXXAmino_AlaAspGluHisPheSerThr() throws Exception {
        super.testGlXXAmino_AlaAspGluHisPheSerThr();
    }

    @Override
    public void testGlXAmino_AlaAspGluHisPheSer() throws Exception {
        super.testGlXAmino_AlaAspGluHisPheSer();
    }

    @Override
    public void testGlAmino_AlaAspGluPheSer() throws Exception {
        super.testGlAmino_AlaAspGluPheSer();
    }

    @Override
    public void testGlPtsXXXAmino_AlaAspGluHisPheSerThrVal() throws Exception {
        super.testGlPtsXXXAmino_AlaAspGluHisPheSerThrVal();
    }

    @Override
    public void testGlPtsXXAmino_AlaAspGluHisPheSerThr() throws Exception {
        super.testGlPtsXXAmino_AlaAspGluHisPheSerThr();
    }

    @Override
    public void testGlPtsXAmino_AlaAspGluHisPheSer() throws Exception {
        super.testGlPtsXAmino_AlaAspGluHisPheSer();
    }

    @Override
    public void testGlPtsAmino_AlaAspGluPheSer() throws Exception {
        super.testGlPtsAmino_AlaAspGluPheSer();
    }

    @Override
    public void testAll() throws Exception {
        super.testAll();
    }

    @Override
    public void testAllAccumulate() throws Exception {
        super.testAllAccumulate();
    }

    @Override
    public void testAllX() throws Exception {
        super.testAllX();
    }

    @Override
    public void testSuper() throws Exception {
        super.testSuper();
    }

    @Override
    public void testSuperX() throws Exception {
        super.testSuperX();
    }

    @Override
    public void testSuperXXThr() throws Exception {
        super.testSuperXXThr();
    }

    @Override
    public void testSuperXXTrp() throws Exception {
        super.testSuperXXTrp();
    }

    @Override
    public void testSuperXXX() throws Exception {
        super.testSuperXXX();
    }

    @Override
    public void testSuperAll() throws Exception {
        super.testSuperAll();
    }

    @Override
    protected void internalTestMetabolicNetwork(MetabolicNetwork network, Set<String> suppressedReactions) throws Exception {
        if (suppressedReactions != null) {
            Config.getConfig().getReactionsToSuppress().addAll(suppressedReactions);
        }
        ElementaryFluxModes.calculateLogCountOnly(network);
    }

    private void callMonet(MetabolicNetwork net, int nblocks) {
        ReadableMatrix<?> stoich = net.getStoichiometricMatrix().transpose();
        IntArray irn = new IntArray();
        IntArray jcn = new IntArray();
        int i = 0;
        while (i < stoich.getRowCount()) {
            int j = 0;
            while (j < stoich.getColumnCount()) {
                if (stoich.getSignumAt(i, j) != 0) {
                    irn.add(i + 1);
                    jcn.add(j + 1);
                }
                ++j;
            }
            ++i;
        }
        HslGateway.callMc66(stoich.getRowCount(), stoich.getColumnCount(), irn.toArray(), jcn.toArray(), nblocks, false, true);
    }

    private static boolean[] getReversible(MetabolicNetwork net) {
        boolean[] rev = new boolean[net.getReactions().length()];
        int i = 0;
        while (i < rev.length) {
            rev[i] = net.getReactions().get(i).getConstraints().isReversible();
            ++i;
        }
        return rev;
    }

    private static ReadableBigIntegerRationalMatrix getStoich(MetabolicNetwork net) {
        return new DefaultBigIntegerRationalMatrix(StoichiometricMatrices.createStoichiometricMatrix(net), true, true);
    }
}

