/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.compress;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.compress.CompressedMetabolicNetwork;
import ch.javasoft.metabolic.compress.CompressionMethod;
import ch.javasoft.metabolic.compress.DuplicateGeneCompressor;
import ch.javasoft.metabolic.compress.LogPkg;
import ch.javasoft.metabolic.compress.StoichMatrixCompressedMetabolicNetwork;
import ch.javasoft.metabolic.compress.StoichMatrixCompressor;
import ch.javasoft.metabolic.impl.AbstractMetabolicNetwork;
import ch.javasoft.metabolic.impl.FractionNumberStoichMetabolicNetwork;
import ch.javasoft.metabolic.util.MetabolicNetworkUtil;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.logging.LogPrintWriter;
import ch.javasoft.util.logging.Loggers;
import ch.javasoft.util.numeric.Zero;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompressionUtil {
    private static final Logger LOG = LogPkg.LOGGER;
    private static final Logger LOG_DATA = Loggers.getLogger(String.valueOf(LOG.getName()) + ".data", -2);

    public static CompressedMetabolicNetwork compress(MetabolicNetwork net) {
        return CompressionUtil.compress(net, null);
    }

    public static CompressedMetabolicNetwork compress(MetabolicNetwork net, Set<String> suppressedReactions) {
        return CompressionUtil.compress(net, CompressionMethod.STANDARD, suppressedReactions);
    }

    public static CompressedMetabolicNetwork compress(MetabolicNetwork net, CompressionMethod[] methods, Set<String> suppressedReactions) {
        return CompressionUtil.compress(net, methods, suppressedReactions, new Zero(0.0));
    }

    public static CompressedMetabolicNetwork compress(MetabolicNetwork net, CompressionMethod[] methods, Set<String> suppressedReactions, Zero zero) {
        boolean[] reversible = net.getReactionReversibilities();
        ReadableBigIntegerRationalMatrix stoich = FractionNumberStoichMetabolicNetwork.getStoich(net);
        String[] metaNames = net.getMetaboliteNames();
        String[] reacNames = net.getReactionNames();
        StoichMatrixCompressor.CompressionRecord rec = new StoichMatrixCompressor(methods).compress(stoich, reversible, metaNames, reacNames, suppressedReactions);
        CompressionUtil.sortMatrix(rec.cmp, rec.post, rec.reversible);
        CompressionUtil.logCompressionRecord(stoich, rec, Level.FINER);
        StoichMatrixCompressedMetabolicNetwork cmpNet = new StoichMatrixCompressedMetabolicNetwork(net, rec.pre, rec.post, rec.cmp);
        if (!java.util.Arrays.equals(rec.reversible, cmpNet.getReactionReversibilities())) {
            LOG.warning("reversibility missmatch:");
            LOG.warning("  reversibility(cmp.rec) = " + java.util.Arrays.toString(rec.reversible));
            LOG.warning("  reversibility(cmp.net) = " + java.util.Arrays.toString(cmpNet.getReactionReversibilities()));
            throw new RuntimeException("reversibility missmatch, see log for details");
        }
        if (LOG.isLoggable(Level.FINE)) {
            CompressionMethod.log(Level.FINE, methods);
            LOG.fine(MetabolicNetworkUtil.getNetworkSizeString("Uncompressed network size: ", net));
            LOG.fine(MetabolicNetworkUtil.getNetworkSizeString("Compressed network size: ", cmpNet));
        }
        return cmpNet;
    }

    public static MetabolicNetwork compressDuplicateGeneReactions(MetabolicNetwork net, Zero zero, CompressionMethod ... methods) {
        boolean[] reversible = net.getReactionReversibilities();
        ReadableBigIntegerRationalMatrix stoich = FractionNumberStoichMetabolicNetwork.getStoich(net);
        String[] metaNames = net.getMetaboliteNames();
        String[] reacNames = net.getReactionNames();
        boolean doExtendedDuplicates = CompressionMethod.DuplicateGeneExtended.containedIn(methods);
        DuplicateGeneCompressor.CompressionRecord rec = DuplicateGeneCompressor.compress(stoich, reversible, metaNames, reacNames, doExtendedDuplicates);
        CompressionUtil.sortMatrix(rec.dupfree, rec.dupelim, rec.reversible);
        CompressionUtil.logCompressionRecord(stoich, rec, Level.FINER);
        FractionNumberStoichMetabolicNetwork dupfreeNet = new FractionNumberStoichMetabolicNetwork(rec.metaNames, rec.reacNames, rec.dupfree, rec.reversible);
        if (LOG.isLoggable(Level.FINE)) {
            CompressionMethod.log(Level.FINE, CompressionMethod.DuplicateGene);
            LOG.fine(MetabolicNetworkUtil.getNetworkSizeString("Uncompressed network size: ", net));
            LOG.fine(MetabolicNetworkUtil.getNetworkSizeString("Duplicate free network size: ", dupfreeNet));
        }
        return dupfreeNet;
    }

    public static MetabolicNetwork convertToNoncompressed(final MetabolicNetwork cNet) {
        return new AbstractMetabolicNetwork(){

            @Override
            public ArrayIterable<? extends Metabolite> getMetabolites() {
                return cNet.getMetabolites();
            }

            @Override
            public ArrayIterable<? extends Reaction> getReactions() {
                return cNet.getReactions();
            }

            @Override
            public ReadableMatrix<?> getStoichiometricMatrix() {
                return cNet.getStoichiometricMatrix();
            }
        };
    }

    public static void logCompressionRecord(StoichMatrixCompressor.CompressionRecord rec, Level level) {
        CompressionUtil.logCompressionRecord(null, rec, level);
    }

    public static void logCompressionRecord(ReadableMatrix<?> stoich, StoichMatrixCompressor.CompressionRecord rec, Level level) {
        if (Loggers.isLoggable(LOG_DATA, level)) {
            LogPrintWriter dataLogger = new LogPrintWriter(LOG_DATA, level);
            LOG_DATA.log(level, "compression matrices:");
            LOG_DATA.log(level, "  pre * stoich * post  = cmp");
            LOG_DATA.log(level, "efm uncompression:");
            LOG_DATA.log(level, "  stoich * post * efmc = 0");
            LOG_DATA.log(level, "  stoich * efm         = 0");
            LOG_DATA.log(level, "  -->      efm         = post * efmc");
            if (stoich != null) {
                LOG_DATA.log(level, "stoich: ");
                stoich.writeToMultiline(dataLogger);
            }
            LOG_DATA.log(level, "pre: ");
            rec.pre.writeToMultiline(dataLogger);
            LOG_DATA.log(level, "post: ");
            rec.post.writeToMultiline(dataLogger);
            LOG_DATA.log(level, "cmp: ");
            rec.cmp.writeToMultiline(dataLogger);
            LOG_DATA.log(level, "cmp_reversibilities = " + java.util.Arrays.toString(rec.reversible));
        }
    }

    public static void logCompressionRecord(DuplicateGeneCompressor.CompressionRecord rec, Level level) {
        CompressionUtil.logCompressionRecord(null, rec, level);
    }

    public static void logCompressionRecord(ReadableMatrix<?> stoich, DuplicateGeneCompressor.CompressionRecord rec, Level level) {
        if (Loggers.isLoggable(LOG_DATA, level)) {
            LogPrintWriter dataLogger = new LogPrintWriter(LOG_DATA, level);
            LOG_DATA.log(level, "compression matrices:");
            LOG_DATA.log(level, "  stoich * dupelim = dupfree");
            if (stoich != null) {
                LOG_DATA.log(level, "stoich: ");
                stoich.writeToMultiline(dataLogger);
            }
            LOG_DATA.log(level, "dupelim: ");
            rec.dupelim.writeToMultiline(dataLogger);
            LOG_DATA.log(level, "dupfree: ");
            rec.dupfree.writeToMultiline(dataLogger);
            LOG_DATA.log(level, "dupfree_reversibilities = " + java.util.Arrays.toString(rec.reversible));
            LOG_DATA.log(level, "dupgroups: " + java.util.Arrays.toString(rec.dupgroups));
        }
    }

    private static <N extends Number, M extends ReadableMatrix<N> & WritableMatrix<N>> void sortMatrix(M stoich, M post, boolean[] reversibilities) {
        CompressionUtil.sortMatrixDiagStoich(stoich, post, reversibilities);
    }

    private static <N extends Number, M extends ReadableMatrix<N> & WritableMatrix<N>> void sortMatrixNone(M stoich, M post, boolean[] reversibilities) {
    }

    private static <N extends Number, M extends ReadableMatrix<N> & WritableMatrix<N>> void sortMatrixFewNonZeroColsPost(M stoich, M post, boolean[] reversibilities) {
        int rows = stoich.getRowCount();
        int cols = stoich.getColumnCount();
        int piv = 0;
        while (piv < cols) {
            int pivcol = piv;
            int pivcnt = Integer.MAX_VALUE;
            int pivrow = Integer.MAX_VALUE;
            int col = piv;
            while (col < cols) {
                int rowFirst = Integer.MAX_VALUE;
                int cnt = 0;
                int row = 0;
                while (row < rows) {
                    if (post.getSignumAt(row, col) != 0) {
                        rowFirst = Math.min(row, rowFirst);
                        ++cnt;
                    }
                    ++row;
                }
                if (cnt < pivcnt || cnt == pivcnt && rowFirst < pivrow) {
                    pivcol = col;
                    pivcnt = cnt;
                    pivrow = rowFirst;
                }
                ++col;
            }
            if (pivcol != piv) {
                ((WritableMatrix<N>)stoich).swapColumns(pivcol, piv);
                ((WritableMatrix<N>)post).swapColumns(pivcol, piv);
                Arrays.swap(reversibilities, pivcol, piv);
            }
            ++piv;
        }
    }

    private static <N extends Number, M extends ReadableMatrix<N> & WritableMatrix<N>> void sortMatrixFewNonZeroColsStoich(M stoich, M post, boolean[] reversibilities) {
        int rows = stoich.getRowCount();
        int cols = stoich.getColumnCount();
        int piv = 0;
        while (piv < cols) {
            int pivcol = piv;
            int pivcnt = Integer.MAX_VALUE;
            int pivrow = Integer.MAX_VALUE;
            int col = piv;
            while (col < cols) {
                int rowFirst = Integer.MAX_VALUE;
                int cnt = 0;
                int row = 0;
                while (row < rows) {
                    if (stoich.getSignumAt(row, col) != 0) {
                        rowFirst = Math.min(row, rowFirst);
                        ++cnt;
                    }
                    ++row;
                }
                if (cnt < pivcnt || cnt == pivcnt && rowFirst < pivrow) {
                    pivcol = col;
                    pivcnt = cnt;
                    pivrow = rowFirst;
                }
                ++col;
            }
            if (pivcol != piv) {
                ((WritableMatrix<N>)stoich).swapColumns(pivcol, piv);
                ((WritableMatrix<N>)post).swapColumns(pivcol, piv);
                Arrays.swap(reversibilities, pivcol, piv);
            }
            ++piv;
        }
    }

    private static <N extends Number, M extends ReadableMatrix<N> & WritableMatrix<N>> void sortMatrixDiagPost(M stoich, M post, boolean[] reversibilities) {
        int rows = stoich.getRowCount();
        int cols = stoich.getColumnCount();
        int piv = 0;
        while (piv < cols) {
            int pivcol = piv;
            int pivrow = Integer.MAX_VALUE;
            int col = piv;
            while (col < cols) {
                int row = 0;
                while (row < rows) {
                    if (post.getSignumAt(row, col) != 0) {
                        if (row >= pivrow) break;
                        pivrow = row;
                        pivcol = col;
                        break;
                    }
                    ++row;
                }
                if (pivrow == 0) break;
                ++col;
            }
            if (pivcol != piv) {
                ((WritableMatrix<N>)stoich).swapColumns(pivcol, piv);
                ((WritableMatrix<N>)post).swapColumns(pivcol, piv);
                Arrays.swap(reversibilities, pivcol, piv);
            }
            ++piv;
        }
    }

    private static <N extends Number, M extends ReadableMatrix<N> & WritableMatrix<N>> void sortMatrixDiagStoich(M stoich, M post, boolean[] reversibilities) {
        int rows = stoich.getRowCount();
        int cols = stoich.getColumnCount();
        int piv = 0;
        while (piv < cols) {
            int pivcol = piv;
            int pivrow = Integer.MAX_VALUE;
            int col = piv;
            while (col < cols) {
                int row = 0;
                while (row < rows) {
                    if (stoich.getSignumAt(row, col) != 0) {
                        if (row >= pivrow) break;
                        pivrow = row;
                        pivcol = col;
                        break;
                    }
                    ++row;
                }
                if (pivrow == 0) break;
                ++col;
            }
            if (pivcol != piv) {
                ((WritableMatrix<N>)stoich).swapColumns(pivcol, piv);
                ((WritableMatrix<N>)post).swapColumns(pivcol, piv);
                Arrays.swap(reversibilities, pivcol, piv);
            }
            ++piv;
        }
    }

    private CompressionUtil() {
    }
}

