/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.compress;

import ch.javasoft.metabolic.compress.LogPkg;
import ch.javasoft.util.logging.LogWriter;
import ch.javasoft.util.logging.Loggers;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

class CompressionStatistics {
    public static final Logger LOG = Loggers.getLogger(String.valueOf(LogPkg.LOGGER.getName()) + ".stats", -2);
    private int[][] countR = new int[CompressionTypeR.values().length][1];
    private int[][] countM = new int[CompressionTypeR.values().length][1];
    private int compressionIteration = -1;
    private int maxNonZeroIteration = -1;

    protected CompressionStatistics() {
    }

    public int incCompressionIteration() {
        ++this.compressionIteration;
        return this.compressionIteration;
    }

    public int getCompressionIteration() {
        return this.compressionIteration;
    }

    public void incZeroFluxReactions() {
        this.incR(CompressionTypeR.ZeroFlux);
    }

    public void incContradictingReactions() {
        this.incR(CompressionTypeR.Contradicting);
    }

    public void incCoupledReactions() {
        this.incR(CompressionTypeR.Coupled, 1);
    }

    public void incCoupledReactions(int reactionCount) {
        this.incR(CompressionTypeR.Coupled, reactionCount);
    }

    public void incUniqueFlowReactions() {
        this.incR(CompressionTypeR.UniqueFlow);
        this.incM(CompressionTypeM.UniqueFlow);
    }

    public void incDeadEndMetaboliteReactions(int reactionCount) {
        this.incR(CompressionTypeR.DeadEnd, reactionCount);
        this.incM(CompressionTypeM.DeadEnd);
    }

    public void incUnusedMetabolite() {
        this.incM(CompressionTypeM.Unused);
    }

    public void incDuplicateGeneReactions(int reactionCount) {
        this.incR(CompressionTypeR.DuplicateGeneSimple, reactionCount);
    }

    public void incDuplicateGeneCompoundReactions(int reactionCount) {
        this.incR(CompressionTypeR.DuplicateGeneComplex, reactionCount);
    }

    public void incInterchangeableMetabolites() {
        this.incM(CompressionTypeM.InterchangeableMetaboliteSimple);
    }

    public void incInterchangeableMetabolitesComplex() {
        this.incM(CompressionTypeM.InterchangeableMetaboliteComplex);
    }

    private void incR(CompressionTypeR type) {
        this.countR[type.ordinal()] = this.inc(this.countR[type.ordinal()]);
    }

    private void incM(CompressionTypeM type) {
        this.countM[type.ordinal()] = this.inc(this.countM[type.ordinal()]);
    }

    private void incR(CompressionTypeR type, int inc) {
        int i = 0;
        while (i < inc) {
            this.countR[type.ordinal()] = this.inc(this.countR[type.ordinal()]);
            ++i;
        }
    }

    private int[] inc(int[] me) {
        if (me.length <= this.compressionIteration) {
            int[] arr = new int[Math.max(this.compressionIteration + 1, me.length * 2)];
            System.arraycopy(me, 0, arr, 0, me.length);
            me = arr;
        }
        int n = this.compressionIteration;
        me[n] = me[n] + 1;
        this.maxNonZeroIteration = this.compressionIteration;
        return me;
    }

    private int getR(int which, int iteration) {
        return this.get(this.countR[which], iteration);
    }

    private int getM(int which, int iteration) {
        return this.get(this.countM[which], iteration);
    }

    private int get(int[] me, int iteration) {
        return iteration < me.length ? me[iteration] : 0;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.write(sw);
        return sw.toString();
    }

    public void writeToLog() {
        this.writeToLog(Level.FINE);
    }

    public void writeToLog(Level level) {
        this.write(new LogWriter(LOG, level));
    }

    public void write(OutputStream out) {
        this.write(new PrintWriter(new OutputStreamWriter(out)));
    }

    public void write(Writer writer) {
        int which;
        PrintWriter pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        pw.println("compression statistics");
        int iteration = 0;
        while (iteration <= this.maxNonZeroIteration) {
            int value;
            which = 0;
            while (which < CompressionTypeM.values().length) {
                value = this.getM(which, iteration);
                pw.println("  meta[" + iteration + "]." + (Object)((Object)CompressionTypeM.values()[which]) + " = " + value);
                ++which;
            }
            which = 0;
            while (which < CompressionTypeR.values().length) {
                value = this.getR(which, iteration);
                pw.println("  reac[" + iteration + "]." + (Object)((Object)CompressionTypeR.values()[which]) + " = " + value);
                ++which;
            }
            ++iteration;
        }
        int totalMeta = 0;
        which = 0;
        while (which < CompressionTypeM.values().length) {
            int total = 0;
            int iteration2 = 0;
            while (iteration2 <= this.maxNonZeroIteration) {
                total += this.getM(which, iteration2);
                ++iteration2;
            }
            pw.println("  meta." + (Object)((Object)CompressionTypeM.values()[which]) + " = " + total);
            totalMeta += total;
            ++which;
        }
        int totalReac = 0;
        int which2 = 0;
        while (which2 < CompressionTypeR.values().length) {
            int total = 0;
            int iteration3 = 0;
            while (iteration3 <= this.maxNonZeroIteration) {
                total += this.getR(which2, iteration3);
                ++iteration3;
            }
            pw.println("  reac." + (Object)((Object)CompressionTypeR.values()[which2]) + " = " + total);
            totalReac += total;
            ++which2;
        }
        pw.println("  meta = " + totalMeta);
        pw.println("  reac = " + totalReac);
        pw.flush();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CompressionTypeM {
        DeadEnd,
        UniqueFlow,
        Unused,
        InterchangeableMetaboliteSimple,
        InterchangeableMetaboliteComplex;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CompressionTypeR {
        ZeroFlux,
        Contradicting,
        Coupled,
        UniqueFlow,
        DeadEnd,
        DuplicateGeneSimple,
        DuplicateGeneComplex;

    }
}

