/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.varint;

import ch.javasoft.math.varint.BigIntegerVarInt;
import ch.javasoft.math.varint.IntVarInt;
import ch.javasoft.math.varint.LongVarInt;
import ch.javasoft.math.varint.VarIntCache;
import java.math.BigInteger;

public class DefaultVarIntCache
implements VarIntCache {
    public static final String SYSTEM_PROPERTY_SIZE = String.valueOf(DefaultVarIntCache.class.getName()) + ".size";
    public static final String SYSTEM_PROPERTY_OFFSET = String.valueOf(DefaultVarIntCache.class.getName()) + ".offset";
    private static final int DEFAULT_CACHE_SIZE = 256;
    private final IntVarInt[] cache;
    private final int offset;

    public DefaultVarIntCache() {
        int cacheSize = DefaultVarIntCache.getFromSystemProperties(SYSTEM_PROPERTY_SIZE, 256);
        this.cache = new IntVarInt[cacheSize];
        this.offset = DefaultVarIntCache.getFromSystemProperties(SYSTEM_PROPERTY_OFFSET, cacheSize >> 1);
        this.initCache();
    }

    public DefaultVarIntCache(int cacheSize, int cacheOffset) {
        this.cache = new IntVarInt[cacheSize];
        this.offset = cacheOffset;
        this.initCache();
    }

    private static int getFromSystemProperties(String property, int defaultValue) {
        String val = System.getProperty(property);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.toString());
        }
        catch (Exception e) {
            System.err.println("Cannot read int value from system properties: " + property + "='" + val + "', e=" + e);
            e.printStackTrace();
            return defaultValue;
        }
    }

    private void initCache() {
        int i = 0;
        while (i < this.cache.length) {
            this.cache[i] = new IntVarInt(i - this.offset);
            ++i;
        }
    }

    public IntVarInt cacheGet(int value) {
        int index = value + this.offset;
        if (index >= 0 && index < this.cache.length) {
            return this.cache[index];
        }
        return new IntVarInt(value);
    }

    public LongVarInt cacheGet(long value) {
        return new LongVarInt(value);
    }

    public BigIntegerVarInt cacheGet(BigInteger value) {
        return new BigIntegerVarInt(value);
    }

    public void reset() {
    }

    static VarIntCache createCache() {
        String className = System.getProperty(VarIntCache.SYSTEM_PROPERTY);
        if (className != null) {
            try {
                return (VarIntCache)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                System.err.println("cannot initialize " + VarIntCache.class.getSimpleName() + " with class " + className + " configured in system property '" + VarIntCache.SYSTEM_PROPERTY + "', e=" + e);
            }
        }
        return new DefaultVarIntCache();
    }
}

