/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.ops;

import ch.javasoft.math.NumberOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNumberOps<N extends Number>
implements NumberOperations<N> {
    @Override
    public N abs(N number) {
        return this.isNegative(number) ? this.negate(number) : number;
    }

    @Override
    public N invert(N number) {
        return this.divide(this.one(), number);
    }

    @Override
    public boolean isNegative(N number) {
        return this.signum(number) < 0;
    }

    @Override
    public boolean isNonZero(N number) {
        return this.signum(number) != 0;
    }

    @Override
    public boolean isOne(N number) {
        return this.compare(this.one(), number) == 0;
    }

    @Override
    public boolean isPositive(N number) {
        return this.signum(number) >= 0;
    }

    @Override
    public boolean isZero(N number) {
        return this.signum(number) == 0;
    }

    @Override
    public boolean isNonNegative(N number) {
        return this.signum(number) >= 0;
    }

    @Override
    public boolean isNonPositive(N number) {
        return this.signum(number) <= 0;
    }

    @Override
    public N max(N valA, N valB) {
        int cmp = this.compare(valA, valB);
        return cmp == -1 ? valB : valA;
    }

    @Override
    public N max(N ... vals) {
        N max = null;
        N[] NArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            N val = NArray[n2];
            max = (N)(max == null ? val : this.max(max, val));
            ++n2;
        }
        return max;
    }

    @Override
    public N min(N valA, N valB) {
        int cmp = this.compare(valA, valB);
        return cmp == 1 ? valB : valA;
    }

    @Override
    public N min(N ... vals) {
        N min = null;
        N[] NArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            N val = NArray[n2];
            min = (N)(min == null ? val : this.min(min, val));
            ++n2;
        }
        return min;
    }
}

