/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.array.sort;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.operator.IntBinaryOperator;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexMinArrayComparator<N extends Number, A>
implements Comparator<A> {
    private final ArrayOperations<A> aops;
    private final IntBinaryOperator<N, A> comparator;

    public LexMinArrayComparator(NumberOperators<N, A> operators) {
        this.aops = operators.getArrayOperations();
        this.comparator = operators.intBinary(IntBinaryOperator.Id.compare);
    }

    @Override
    public int compare(A o1, A o2) {
        int len1 = this.aops.getLength(o1);
        int len2 = this.aops.getLength(o1);
        int len = Math.min(len1, len2);
        int i = 0;
        while (i < len) {
            int cmp = this.comparator.intOperate(o1, i, o2, i);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return len1 - len2;
    }
}

