/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.array.sort;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.operator.IntBinaryOperator;
import ch.javasoft.math.operator.UnaryOperator;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbsLexMinArrayComparator<N extends Number, A>
implements Comparator<A> {
    private final ArrayOperations<A> aops;
    private final UnaryOperator<N, A> abs;
    private final IntBinaryOperator<N, A> comparator;
    private final ThreadLocal<A> temp;

    public AbsLexMinArrayComparator(NumberOperators<N, A> operators) {
        this.aops = operators.getArrayOperations();
        this.abs = operators.unary(UnaryOperator.Id.abs);
        this.comparator = operators.intBinary(IntBinaryOperator.Id.compare);
        this.temp = new ThreadLocal<A>(){

            @Override
            protected A initialValue() {
                return AbsLexMinArrayComparator.this.aops.newVector(2);
            }
        };
    }

    @Override
    public int compare(A o1, A o2) {
        int len1 = this.aops.getLength(o1);
        int len2 = this.aops.getLength(o1);
        int len = Math.min(len1, len2);
        A tmp = this.temp.get();
        int i = 0;
        while (i < len) {
            this.abs.operate(o1, i, tmp, 0);
            this.abs.operate(o2, i, tmp, 1);
            int cmp = this.comparator.intOperate(tmp, 0, tmp, 1);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return len1 - len2;
    }
}

