/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.array.parse;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.array.parse.DataType;
import ch.javasoft.math.array.parse.DefaultMatrixData;
import ch.javasoft.math.array.parse.MatrixData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;

public class MatrixParser {
    private final MatrixData matrixData;

    public MatrixParser(File file) throws FileNotFoundException, IOException {
        this(new FileInputStream(file));
    }

    public MatrixParser(InputStream in) throws IOException {
        this(new InputStreamReader(in));
    }

    public MatrixParser(Reader reader) throws IOException {
        this(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader));
    }

    public MatrixParser(BufferedReader reader) throws IOException {
        int cols = -1;
        Token token = new Token(reader);
        if (token.eof()) {
            throw token.createIOException("unexpected end of file, expected at least one matrix row");
        }
        ArrayList<DataType> rowTypes = new ArrayList<DataType>();
        ArrayList<Object> rowData = new ArrayList<Object>();
        DataType matrixType = DataType.Int;
        boolean needsConversion = false;
        while (!token.eof()) {
            String[] parts = token.split();
            if (cols < 0) {
                cols = parts.length;
            } else if (cols != parts.length) {
                throw token.createIOException("expected " + cols + " values, but found " + parts.length);
            }
            DataType rowType = matrixType;
            BigFraction[] vals = new BigFraction[parts.length];
            int i = 0;
            while (i < vals.length) {
                try {
                    vals[i] = BigFraction.valueOf(parts[i]);
                    DataType valType = DataType.getTightestFit(vals[i]);
                    rowType = DataType.getLoosestType(rowType, valType);
                }
                catch (Exception e) {
                    throw token.createIOException("cannot parse number \"" + parts[i] + "\", e=" + e);
                }
                ++i;
            }
            if (matrixType.isTighterThan(rowType)) {
                matrixType = rowType;
                needsConversion = !rowTypes.isEmpty();
            }
            rowTypes.add(rowType);
            rowData.add(matrixType.asVector(vals));
            token.readNextLine();
        }
        if (needsConversion) {
            int i = 0;
            while (i < rowData.size()) {
                DataType rowType = (DataType)((Object)rowTypes.get(i));
                if (rowType.isTighterThan(matrixType)) {
                    Object looser = rowType.asLooserVector(matrixType, rowData.get(i));
                    rowData.set(i, looser);
                } else if (matrixType.isTighterThan(rowType)) {
                    throw new RuntimeException("internal error: matrix type tighter than row type");
                }
                ++i;
            }
        }
        this.matrixData = new DefaultMatrixData(matrixType, rowData);
    }

    public MatrixData getData() {
        return this.matrixData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("matrix = { ");
        sb.append(this.matrixData);
        sb.append(" }");
        return sb.toString();
    }

    private static class Token {
        final BufferedReader reader;
        String line;
        int lineNo = 0;

        Token(BufferedReader reader) throws IOException {
            this.reader = reader;
            this.readNextLine();
        }

        boolean eof() {
            return this.line == null;
        }

        String readNextLine() throws IOException {
            this.line = this.reader.readLine();
            ++this.lineNo;
            return this.line;
        }

        String[] split() {
            return this.line.trim().split("\\s+");
        }

        IOException createIOException(String msg) {
            return new IOException("[" + this.lineNo + "] " + msg + ": " + (this.line == null ? "<end of file>" : this.line));
        }
    }
}

