/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.array.impl;

import ch.javasoft.math.array.impl.AbstractArrayOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleArrayOperations
extends AbstractArrayOperations<double[]> {
    public static final DoubleArrayOperations INSTANCE = new DoubleArrayOperations();

    protected DoubleArrayOperations() {
        super(double[].class);
    }

    @Override
    public double[] newVector(int size) {
        return new double[size];
    }

    public double[][] newMatrix(int rows, int columns) {
        return new double[rows][columns];
    }

    @Override
    public int getLength(double[] array) {
        return array.length;
    }

    public int getColumnCount(double[][] matrix) {
        return matrix.length == 0 ? 0 : matrix[0].length;
    }

    @Override
    public String getAsString(double[] vector, int index) {
        return String.valueOf(vector[index]);
    }

    @Override
    public void swapVectorElements(double[] v, int index1, int index2) {
        double tmp = v[index1];
        v[index1] = v[index2];
        v[index2] = tmp;
    }

    public void swapMatrixElements(double[][] matrix, int row1, int col1, int row2, int col2) {
        double tmp = matrix[row1][col1];
        matrix[row1][col1] = matrix[row2][col2];
        matrix[row2][col2] = tmp;
    }

    public void swapMatrixRows(double[][] matrix, int row1, int row2) {
        int cols = this.getColumnCount(matrix);
        int c = 0;
        while (c < cols) {
            double tmp = matrix[row1][c];
            matrix[row1][c] = matrix[row2][c];
            matrix[row2][c] = tmp;
            ++c;
        }
    }

    public void swapMatrixColumns(double[][] matrix, int col1, int col2) {
        int rows = this.getRowCount((A[])matrix);
        int r = 0;
        while (r < rows) {
            double tmp = matrix[r][col1];
            matrix[r][col1] = matrix[r][col2];
            matrix[r][col2] = tmp;
            ++r;
        }
    }

    @Override
    public void swapVectorVectorElements(double[] v1, int index1, double[] v2, int index2) {
        double tmp = v1[index1];
        v1[index1] = v2[index2];
        v2[index2] = tmp;
    }

    public void swapVectorMatrixElements(double[] v, int index, double[][] m, int row, int col) {
        double tmp = v[index];
        v[index] = m[row][col];
        m[row][col] = tmp;
    }

    public void swapMatrixMatrixElements(double[][] m1, int row1, int col1, double[][] m2, int row2, int col2) {
        double tmp = m1[row1][col1];
        m1[row1][col1] = m2[row2][col2];
        m2[row2][col2] = tmp;
    }

    @Override
    public void copyVectorElement(double[] src, int srcIndex, double[] dst, int dstIndex) {
        dst[dstIndex] = src[srcIndex];
    }

    @Override
    public void copyVectorElements(double[] src, int[] srcIndices, double[] dst, int[] dstIndices) {
        if (srcIndices.length != dstIndices.length) {
            throw new IllegalArgumentException("size of source and destination indices must match: " + srcIndices.length + " != " + dstIndices.length);
        }
        int i = 0;
        while (i < srcIndices.length) {
            src[srcIndices[i]] = dst[dstIndices[i]];
            ++i;
        }
    }

    public void copyVectorElementsToMatrixColumn(double[] src, int srcStart, double[][] dst, int dstRowStart, int dstCol, int length) {
        int i = 0;
        while (i < length) {
            dst[dstRowStart + i][dstCol] = src[srcStart + i];
            ++i;
        }
    }

    public void copyMatrixElement(double[][] src, int srcRow, int srcCol, double[][] dst, int dstRow, int dstCol) {
        dst[dstRow][dstCol] = src[srcRow][srcCol];
    }

    public void copyMatrixRowElementsToColumn(double[][] src, int srcRow, int srcColStart, double[][] dst, int dstRowStart, int dstCol, int length) {
        int i = 0;
        while (i < length) {
            dst[dstRowStart + i][dstCol] = src[srcRow][srcColStart + i];
            ++i;
        }
    }

    public void copyMatrixColumnElements(double[][] src, int srcRowStart, int srcCol, double[][] dst, int dstRowStart, int dstCol, int length) {
        int i = 0;
        while (i < length) {
            dst[dstRowStart + i][dstCol] = src[srcRowStart + i][srcCol];
            ++i;
        }
    }

    public void copyMatrixColumnElementsToVector(double[][] src, int srcRowStart, int srcCol, double[] dst, int dstStart, int length) {
        int i = 0;
        while (i < length) {
            dst[dstStart + i] = src[srcRowStart + i][srcCol];
            ++i;
        }
    }

    public void copyMatrixColumnElementsToRow(double[][] src, int srcRowStart, int srcCol, double[][] dst, int dstRow, int dstColStart, int length) {
        int i = 0;
        while (i < length) {
            dst[dstRow][dstColStart + i] = src[srcRowStart + i][srcCol];
            ++i;
        }
    }

    public double[] copyOfMatrixColumn(double[][] matrix, int column) {
        int rows = this.getRowCount((A[])matrix);
        double[] col = this.newVector(rows);
        int r = 0;
        while (r < rows) {
            col[r] = matrix[r][column];
            ++r;
        }
        return col;
    }

    public double[] copyOfMatrixColumnRange(double[][] matrix, int rowFrom, int rowTo, int column) {
        int rows = rowTo - rowFrom;
        double[] col = this.newVector(rows);
        int r = 0;
        while (r < rows) {
            col[r] = matrix[rowFrom + r][column];
            ++r;
        }
        return col;
    }

    public double[][] copyOfColumnSubMatrix(double[][] matrix, int ... columnIndices) {
        if (columnIndices == null) {
            return (double[][])this.copyOfMatrix((A[])matrix);
        }
        int rows = this.getRowCount((A[])matrix);
        int cols = columnIndices.length;
        double[][] copy = this.newMatrix(rows, cols);
        int r = 0;
        while (r < rows) {
            int i = 0;
            while (i < cols) {
                copy[r][i] = matrix[r][columnIndices[i]];
                ++i;
            }
            ++r;
        }
        return copy;
    }

    public double[][] copyOfSubMatrix(double[][] matrix, int rowIndexFrom, int rowIndexTo, int colIndexFrom, int colIndexTo) {
        int rows = rowIndexTo - rowIndexFrom;
        int cols = colIndexTo - colIndexFrom;
        double[][] copy = this.newMatrix(rows, cols);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                copy[i][j] = matrix[rowIndexFrom + i][colIndexFrom + j];
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public double[][] copyOfSubMatrix(double[][] matrix, int[] rowIndices, int[] columnIndices) {
        if (rowIndices == null) {
            return this.copyOfColumnSubMatrix(matrix, columnIndices);
        }
        if (columnIndices == null) {
            return (double[][])this.copyOfRowSubMatrix((A[])matrix, rowIndices);
        }
        int rows = rowIndices.length;
        int cols = columnIndices.length;
        double[][] copy = this.newMatrix(rows, cols);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                copy[i][j] = matrix[rowIndices[i]][columnIndices[j]];
                ++j;
            }
            ++i;
        }
        return copy;
    }

    public double[][] transpose(double[][] matrix) {
        int rows = this.getRowCount((A[])matrix);
        int cols = this.getColumnCount(matrix);
        double[][] trans = this.newMatrix(cols, rows);
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                trans[c][r] = matrix[r][c];
                ++c;
            }
            ++r;
        }
        return trans;
    }

    public void copyVectorElementsToMatrixDiagonal(double[] src, double[][] dst) {
        int cols;
        int rows;
        int len = this.getLength(src);
        if (len != Math.min(rows = this.getRowCount((A[])dst), cols = this.getColumnCount(dst))) {
            throw new IllegalArgumentException("vector length must be equal to minimum dimension of matrix: " + len + " != min(" + rows + ", " + cols + ")");
        }
        int i = 0;
        while (i < len) {
            dst[i][i] = src[i];
            ++i;
        }
    }

    public void copyMatrixDiagonalElementsToVector(double[][] src, double[] dst) {
        int cols;
        int rows;
        int len = this.getLength(dst);
        if (len != Math.min(rows = this.getRowCount((A[])src), cols = this.getColumnCount(src))) {
            throw new IllegalArgumentException("vector length must be equal to minimum dimension of matrix: " + len + " != min(" + rows + ", " + cols + ")");
        }
        int i = 0;
        while (i < len) {
            dst[i] = src[i][i];
            ++i;
        }
    }

    public double[] copyOfMatrixDiagonal(double[][] matrix) {
        int rows = this.getRowCount((A[])matrix);
        int cols = this.getColumnCount(matrix);
        int len = Math.min(rows, cols);
        double[] diag = this.newVector(len);
        int i = 0;
        while (i < len) {
            diag[i] = matrix[i][i];
            ++i;
        }
        return diag;
    }

    public double[][] newDiagonalMatrix(double[] diagonal) {
        int len = diagonal.length;
        double[][] matrix = this.newMatrix(len, len);
        int i = 0;
        while (i < len) {
            matrix[i][i] = diagonal[i];
            ++i;
        }
        return matrix;
    }
}

