/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.array.impl;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.Converter;
import ch.javasoft.math.array.ExpressionComposer;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.operator.AggregatingBinaryOperator;
import ch.javasoft.math.operator.AggregatingUnaryOperator;
import ch.javasoft.math.operator.BinaryOperator;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import ch.javasoft.math.operator.IntUnaryOperator;
import ch.javasoft.math.operator.NullaryOperator;
import ch.javasoft.math.operator.UnaryOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNumberArrayOperations<N extends Number, A>
implements NumberArrayOperations<N, A> {
    private final NumberOperators<N, A> operators;
    private final ArrayOperations<A> arrayOps;
    private final ExpressionComposer<N, A> expressionComposer;

    public DefaultNumberArrayOperations(NumberOperators<N, A> operators, ArrayOperations<A> arrayOps) {
        this.operators = operators;
        this.arrayOps = arrayOps;
        this.expressionComposer = new ExpressionComposer<N, A>(arrayOps, operators);
    }

    @Override
    public final NumberOperators<N, A> getNumberOperators() {
        return this.operators;
    }

    @Override
    public final ArrayOperations<A> getArrayOperations() {
        return this.arrayOps;
    }

    @Override
    public <IN extends Number, IA> Converter<IN, IA, N, A> getConverterFrom(NumberArrayOperations<IN, IA> fromOps) {
        return new Converter(fromOps, this);
    }

    @Override
    public <RN extends Number, RA> Converter<N, A, RN, RA> getConverterTo(NumberArrayOperations<RN, RA> toOps) {
        return new Converter(this, toOps);
    }

    @Override
    public ExpressionComposer<N, A> getExpressionComposer() {
        return this.expressionComposer;
    }

    @Override
    public N convertNumber(Number value) {
        return (N)((Number)this.operators.converter().operate(value));
    }

    @Override
    public Class<N> numberClass() {
        return this.operators.numberClass();
    }

    @Override
    public Class<A> arrayClass() {
        return this.operators.arrayClass();
    }

    @Override
    public A newZeroVector(int length) {
        return this.newVector(length, this.operators.zero());
    }

    @Override
    public A newOneVector(int length) {
        return this.newVector(length, this.operators.one());
    }

    @Override
    public A newVector(int length, N initialValue) {
        A vec = this.arrayOps.newVector(length);
        if (this.initializationNeeded(initialValue)) {
            this.setAll(vec, initialValue);
        }
        return vec;
    }

    @Override
    public A[] newZeroMatrix(int rows, int columns) {
        return this.newMatrix(rows, columns, this.operators.zero());
    }

    @Override
    public A[] newOneMatrix(int rows, int columns) {
        return this.newMatrix(rows, columns, this.operators.one());
    }

    @Override
    public A[] newMatrix(int rows, int columns, N initialValue) {
        A[] mat = this.arrayOps.newMatrix(rows, columns);
        if (this.initializationNeeded(initialValue)) {
            this.setAll(mat, initialValue);
        }
        return mat;
    }

    @Override
    public A[] newIdentityMatrix(int size) {
        return this.newDiagonalMatrix(size, this.operators.one());
    }

    @Override
    public A[] newDiagonalMatrix(int size, N diagonalValue) {
        A[] mat = this.newZeroMatrix(size, size);
        NullaryOperator<N, A> op = this.operators.constant(diagonalValue);
        int i = 0;
        while (i < size) {
            op.operate(mat[i], i);
            ++i;
        }
        return mat;
    }

    @Override
    public A[] newDiagonalMatrix(A diagonalValues) {
        int size = this.arrayOps.getLength(diagonalValues);
        A[] mat = this.newZeroMatrix(size, size);
        this.arrayOps.copyVectorElementsToMatrixDiagonal(diagonalValues, mat);
        return mat;
    }

    @Override
    public boolean allBoolean(A v, BooleanUnaryOperator<N, A> operator) {
        int len = this.arrayOps.getLength(v);
        int i = 0;
        while (i < len) {
            if (!this.evalBoolean(v, i, operator)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean allBoolean(A v, int[] indices, BooleanUnaryOperator<N, A> operator) {
        int i = 0;
        while (i < indices.length) {
            if (!this.evalBoolean(v, indices[i], operator)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean allBoolean(A[] matrix, BooleanUnaryOperator<N, A> operator) {
        int rows = this.arrayOps.getRowCount(matrix);
        int cols = this.arrayOps.getColumnCount(matrix);
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                if (!this.evalBoolean(matrix, r, c, operator)) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    @Override
    public boolean allBoolean(A[] matrix, int[] rowIndices, int[] colIndices, BooleanUnaryOperator<N, A> operator) {
        int r = 0;
        while (r < rowIndices.length) {
            int c = 0;
            while (c < colIndices.length) {
                if (!this.evalBoolean(matrix, rowIndices[r], colIndices[c], operator)) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    @Override
    public boolean allBooleanInColumn(A[] matrix, int col, BooleanUnaryOperator<N, A> operator) {
        int rows = this.arrayOps.getRowCount(matrix);
        int r = 0;
        while (r < rows) {
            if (!this.evalBoolean(matrix, r, col, operator)) {
                return false;
            }
            ++r;
        }
        return true;
    }

    @Override
    public boolean allBooleanInRange(A v, int from, int to, BooleanUnaryOperator<N, A> operator) {
        int i = from;
        while (i < to) {
            if (!this.evalBoolean(v, i, operator)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean allBooleanInRange(A[] matrix, int rowFrom, int rowTo, int colFrom, int colTo, BooleanUnaryOperator<N, A> operator) {
        int r = rowFrom;
        while (r < rowTo) {
            int c = colFrom;
            while (c < colTo) {
                if (!this.evalBoolean(matrix, r, c, operator)) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    @Override
    public boolean allBooleanInRow(A[] matrix, int row, BooleanUnaryOperator<N, A> operator) {
        int cols = this.arrayOps.getColumnCount(matrix);
        int c = 0;
        while (c < cols) {
            if (!this.evalBoolean(matrix, row, c, operator)) {
                return false;
            }
            ++c;
        }
        return true;
    }

    @Override
    public boolean anyBoolean(A v, BooleanUnaryOperator<N, A> operator) {
        int len = this.arrayOps.getLength(v);
        int i = 0;
        while (i < len) {
            if (this.evalBoolean(v, i, operator)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean anyBoolean(A v, int[] indices, BooleanUnaryOperator<N, A> operator) {
        int i = 0;
        while (i < indices.length) {
            if (this.evalBoolean(v, indices[i], operator)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean anyBoolean(A[] matrix, BooleanUnaryOperator<N, A> operator) {
        int rows = this.arrayOps.getRowCount(matrix);
        int cols = this.arrayOps.getColumnCount(matrix);
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                if (this.evalBoolean(matrix, r, c, operator)) {
                    return true;
                }
                ++c;
            }
            ++r;
        }
        return false;
    }

    @Override
    public boolean anyBoolean(A[] matrix, int[] rowIndices, int[] colIndices, BooleanUnaryOperator<N, A> operator) {
        int r = 0;
        while (r < rowIndices.length) {
            int c = 0;
            while (c < colIndices.length) {
                if (this.evalBoolean(matrix, rowIndices[r], colIndices[c], operator)) {
                    return true;
                }
                ++c;
            }
            ++r;
        }
        return false;
    }

    @Override
    public boolean anyBooleanInColumn(A[] matrix, int col, BooleanUnaryOperator<N, A> operator) {
        int rows = this.arrayOps.getRowCount(matrix);
        int r = 0;
        while (r < rows) {
            if (this.evalBoolean(matrix, r, col, operator)) {
                return true;
            }
            ++r;
        }
        return false;
    }

    @Override
    public boolean anyBooleanInRange(A v, int from, int to, BooleanUnaryOperator<N, A> operator) {
        int i = from;
        while (i < to) {
            if (this.evalBoolean(v, i, operator)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean anyBooleanInRange(A[] matrix, int rowFrom, int rowTo, int colFrom, int colTo, BooleanUnaryOperator<N, A> operator) {
        int r = rowFrom;
        while (r < rowTo) {
            int c = colFrom;
            while (c < colTo) {
                if (this.evalBoolean(matrix, r, c, operator)) {
                    return true;
                }
                ++c;
            }
            ++r;
        }
        return false;
    }

    @Override
    public boolean anyBooleanInRow(A[] matrix, int row, BooleanUnaryOperator<N, A> operator) {
        int cols = this.arrayOps.getColumnCount(matrix);
        int c = 0;
        while (c < cols) {
            if (this.evalBoolean(matrix, row, c, operator)) {
                return true;
            }
            ++c;
        }
        return false;
    }

    @Override
    public boolean allBooleanInDiagonal(A[] matrix, BooleanUnaryOperator<N, A> operator) {
        int rows = this.arrayOps.getRowCount(matrix);
        int cols = this.arrayOps.getColumnCount(matrix);
        int len = Math.min(rows, cols);
        int i = 0;
        while (i < len) {
            if (!this.evalBoolean(matrix, i, i, operator)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean anyBooleanInDiagonal(A[] matrix, BooleanUnaryOperator<N, A> operator) {
        int rows = this.arrayOps.getRowCount(matrix);
        int cols = this.arrayOps.getColumnCount(matrix);
        int len = Math.min(rows, cols);
        int i = 0;
        while (i < len) {
            if (this.evalBoolean(matrix, i, i, operator)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public A applyToEachElement(A v, UnaryOperator<N, A> operator) {
        int len = this.arrayOps.getLength(v);
        A res = this.arrayOps.newVector(len);
        int i = 0;
        while (i < len) {
            operator.operate(v, i, res, i);
            ++i;
        }
        return res;
    }

    @Override
    public void applyToEachElement(A src, A dst, UnaryOperator<N, A> operator) {
        int len = this.getAndCheckEqualVectorLength(src, dst, "source and destination vector must have same length: ");
        int i = 0;
        while (i < len) {
            operator.operate(src, i, dst, i);
            ++i;
        }
    }

    @Override
    public A[] applyToEachElement(A[] matrix, UnaryOperator<N, A> operator) {
        int rows = this.arrayOps.getRowCount(matrix);
        int cols = this.arrayOps.getColumnCount(matrix);
        A[] res = this.arrayOps.newMatrix(rows, cols);
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                operator.operate(matrix[r], c, res[r], c);
                ++c;
            }
            ++r;
        }
        return res;
    }

    @Override
    public void applyToEachElement(A[] src, A[] dst, UnaryOperator<N, A> operator) {
        int rows = this.getAndCheckEqualMatrixRowCount(src, dst, "source and destination matrix must have same row count: ");
        int cols = this.getAndCheckEqualMatrixColumnCount(src, dst, "source and destination matrix must have same column count: ");
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                operator.operate(src[r], c, dst[r], c);
                ++c;
            }
            ++r;
        }
    }

    @Override
    public A applyToElementByElement(A v, A u, BinaryOperator<N, A> operator) {
        int len = this.getAndCheckEqualVectorLength(u, v, "source vectors must have same length: ");
        A res = this.arrayOps.newVector(len);
        int i = 0;
        while (i < len) {
            operator.operate(v, i, u, i, res, i);
            ++i;
        }
        return res;
    }

    @Override
    public void applyToElementByElement(A src1, A src2, A dst, BinaryOperator<N, A> operator) {
        int len = this.getAndCheckEqualVectorLength(src1, src2, dst, "source vectors and destination vector must have same length: ");
        int i = 0;
        while (i < len) {
            operator.operate(src1, i, src2, i, dst, i);
            ++i;
        }
    }

    @Override
    public A[] applyToElementByElement(A[] src1, A[] src2, BinaryOperator<N, A> operator) {
        int rows = this.getAndCheckEqualMatrixRowCount(src1, src2, "source matrices must have same row count: ");
        int cols = this.getAndCheckEqualMatrixColumnCount(src1, src2, "source matrices must have same column count: ");
        A[] res = this.arrayOps.newMatrix(rows, cols);
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                operator.operate(src1[r], c, src2[r], c, res[r], c);
                ++c;
            }
            ++r;
        }
        return res;
    }

    @Override
    public void applyToElementByElement(A[] src1, A[] src2, A[] dst, BinaryOperator<N, A> operator) {
        int rows = this.getAndCheckEqualMatrixRowCount(src1, src2, dst, "source matrices and destination matrix must have same row count: ");
        int cols = this.getAndCheckEqualMatrixColumnCount(src1, src2, dst, "source matrices and destination matrix must have same column count: ");
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                operator.operate(src1[r], c, src2[r], c, dst[r], c);
                ++c;
            }
            ++r;
        }
    }

    @Override
    public boolean evalBoolean(A v, int index, BooleanUnaryOperator<N, A> operator) {
        return operator.booleanOperate(v, index);
    }

    @Override
    public boolean evalBoolean(A[] matrix, int row, int col, BooleanUnaryOperator<N, A> operator) {
        return operator.booleanOperate(matrix[row], col);
    }

    @Override
    public int evalInt(A v, int index, IntUnaryOperator<N, A> operator) {
        return operator.intOperate(v, index);
    }

    @Override
    public int evalInt(A[] matrix, int row, int col, IntUnaryOperator<N, A> operator) {
        return operator.intOperate(matrix[row], col);
    }

    @Override
    public N get(A vector, int index) {
        return (N)((Number)this.operators.unary(UnaryOperator.Id.identity).operate(vector, index));
    }

    @Override
    public N get(A[] matrix, int row, int col) {
        return (N)((Number)this.operators.unary(UnaryOperator.Id.identity).operate(matrix[row], col));
    }

    @Override
    public int getSignum(A vector, int index) {
        return this.operators.intUnary(IntUnaryOperator.Id.signum).intOperate(vector, index);
    }

    @Override
    public int getSignum(A[] matrix, int row, int col) {
        return this.operators.intUnary(IntUnaryOperator.Id.signum).intOperate(matrix[row], col);
    }

    @Override
    public long[] getVectorSupportAsLongBits(A vector) {
        int len = this.arrayOps.getLength(vector);
        long[] support = new long[(len + 63) / 64];
        int i = 0;
        while (i < len) {
            if (this.getSignum(vector, i) != 0) {
                int n = i / 64;
                support[n] = support[n] | 1L << i % 64;
            }
            ++i;
        }
        return support;
    }

    @Override
    public long[][] getMatrixSupportAsLongBits(A[] matrix) {
        int rows = this.arrayOps.getRowCount(matrix);
        int cols = this.arrayOps.getColumnCount(matrix);
        long[][] support = new long[rows][(cols + 63) / 64];
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                if (this.getSignum(matrix, r, c) != 0) {
                    long[] lArray = support[r];
                    int n = c / 64;
                    lArray[n] = lArray[n] | 1L << c % 64;
                }
                ++c;
            }
            ++r;
        }
        return support;
    }

    @Override
    public long[] getMatrixRowSupportAsLongBits(A[] matrix, int row) {
        return this.getVectorSupportAsLongBits(matrix[row]);
    }

    @Override
    public long[] getMatrixColumnSupportAsLongBits(A[] matrix, int col) {
        int rows = this.arrayOps.getRowCount(matrix);
        long[] support = new long[(rows + 63) / 64];
        int r = 0;
        while (r < rows) {
            if (this.getSignum(matrix, r, col) != 0) {
                int n = r / 64;
                support[n] = support[n] | 1L << r % 64;
            }
            ++r;
        }
        return support;
    }

    @Override
    public N applyTo(A v, AggregatingUnaryOperator<N, A> operator) {
        return (N)((Number)operator.operate(v, 0, this.arrayOps.getLength(v)));
    }

    @Override
    public N applyToRow(A[] matrix, int row, AggregatingUnaryOperator<N, A> operator) {
        return (N)((Number)operator.operate(matrix[row], 0, this.arrayOps.getColumnCount(matrix)));
    }

    @Override
    public N applyToColumn(A[] matrix, int col, AggregatingUnaryOperator<N, A> operator) {
        return (N)((Number)operator.operate(matrix, 0, col, this.arrayOps.getRowCount(matrix), 1));
    }

    @Override
    public A applyToEachRow(A[] matrix, AggregatingUnaryOperator<N, A> operator) {
        int rows = this.arrayOps.getRowCount(matrix);
        int cols = this.arrayOps.getColumnCount(matrix);
        A res = this.arrayOps.newVector(rows);
        int r = 0;
        while (r < rows) {
            operator.operate(matrix[r], 0, cols, res, r);
            ++r;
        }
        return res;
    }

    @Override
    public void applyToEachRow(A[] matrix, A dst, AggregatingUnaryOperator<N, A> operator) {
        int rows = this.arrayOps.getRowCount(matrix);
        int cols = this.arrayOps.getColumnCount(matrix);
        int len = this.arrayOps.getLength(dst);
        if (rows != len) {
            throw new IllegalArgumentException("matrix row count and destination vector length must be equal: " + rows + " != " + len);
        }
        int r = 0;
        while (r < rows) {
            operator.operate(matrix[r], 0, cols, dst, r);
            ++r;
        }
    }

    @Override
    public A applyToEachColumn(A[] matrix, AggregatingUnaryOperator<N, A> operator) {
        int rows = this.arrayOps.getRowCount(matrix);
        int cols = this.arrayOps.getColumnCount(matrix);
        A res = this.arrayOps.newVector(cols);
        int c = 0;
        while (c < cols) {
            operator.operate(matrix, 0, c, rows, 1, res, c);
            ++c;
        }
        return res;
    }

    @Override
    public void applyToEachColumn(A[] matrix, A dst, AggregatingUnaryOperator<N, A> operator) {
        int len;
        int rows = this.arrayOps.getRowCount(matrix);
        int cols = this.arrayOps.getColumnCount(matrix);
        if (cols != (len = this.arrayOps.getLength(dst))) {
            throw new IllegalArgumentException("matrix column count and destination vector length must be equal: " + cols + " != " + len);
        }
        int c = 0;
        while (c < cols) {
            operator.operate(matrix, 0, c, rows, 1, dst, c);
            ++c;
        }
    }

    @Override
    public N applyTo(A v, A u, AggregatingBinaryOperator<N, A> operator) {
        int len = this.getAndCheckEqualVectorLength(u, v, "source vectors must have same length: ");
        return (N)((Number)operator.operate(v, 0, u, 0, len));
    }

    private int getAndCheckEqualVectorLength(A v, A u, String errMsg) {
        int chk;
        int len = this.arrayOps.getLength(v);
        if (len == (chk = this.arrayOps.getLength(u))) {
            return len;
        }
        throw new IllegalArgumentException(String.valueOf(errMsg) + len + " != " + chk);
    }

    private int getAndCheckEqualVectorLength(A v, A u, A w, String errMsg) {
        int len = this.arrayOps.getLength(v);
        int ck1 = this.arrayOps.getLength(u);
        int ck2 = this.arrayOps.getLength(w);
        if (len == ck1 && len == ck2) {
            return len;
        }
        throw new IllegalArgumentException(String.valueOf(errMsg) + len + ", " + ck1 + ", " + ck2);
    }

    private int getAndCheckEqualMatrixRowCount(A[] mx1, A[] mx2, String errMsg) {
        int chk;
        int len = this.arrayOps.getRowCount(mx1);
        if (len == (chk = this.arrayOps.getRowCount(mx2))) {
            return len;
        }
        throw new IllegalArgumentException(String.valueOf(errMsg) + len + " != " + chk);
    }

    private int getAndCheckEqualMatrixColumnCount(A[] mx1, A[] mx2, String errMsg) {
        int chk;
        int len = this.arrayOps.getColumnCount(mx1);
        if (len == (chk = this.arrayOps.getColumnCount(mx2))) {
            return len;
        }
        throw new IllegalArgumentException(String.valueOf(errMsg) + len + " != " + chk);
    }

    private int getAndCheckEqualMatrixRowCount(A[] mx1, A[] mx2, A[] mx3, String errMsg) {
        int len = this.arrayOps.getRowCount(mx1);
        int ck1 = this.arrayOps.getRowCount(mx2);
        int ck2 = this.arrayOps.getRowCount(mx3);
        if (len == ck1 && len == ck2) {
            return len;
        }
        throw new IllegalArgumentException(String.valueOf(errMsg) + len + ", " + ck1 + ", " + ck2);
    }

    private int getAndCheckEqualMatrixColumnCount(A[] mx1, A[] mx2, A[] mx3, String errMsg) {
        int len = this.arrayOps.getColumnCount(mx1);
        int ck1 = this.arrayOps.getColumnCount(mx2);
        int ck2 = this.arrayOps.getColumnCount(mx3);
        if (len == ck1 && len == ck2) {
            return len;
        }
        throw new IllegalArgumentException(String.valueOf(errMsg) + len + ", " + ck1 + ", " + ck2);
    }

    @Override
    public void applyToEachColumnElement(A[] src, int srcCol, A[] dst, int dstCol, UnaryOperator<N, A> operator) {
        int rows = this.getAndCheckEqualMatrixRowCount(src, dst, "source and destination matrix must have the same number of rows: ");
        int r = 0;
        while (r < rows) {
            operator.operate(src[r], srcCol, dst[r], dstCol);
            ++r;
        }
    }

    @Override
    public void applyToEachColumnElement(A[] src, int srcRowStart, int srcCol, A[] dst, int dstRowStart, int dstCol, int length, UnaryOperator<N, A> operator) {
        int r = 0;
        while (r < length) {
            operator.operate(src[srcRowStart + r], srcCol, dst[dstRowStart + r], dstCol);
            ++r;
        }
    }

    @Override
    public void applyToEachDiagonalElement(A[] src, A[] dst, UnaryOperator<N, A> operator) {
        int rows = this.getAndCheckEqualMatrixRowCount(src, dst, "source and destination matrix must have the same number of rows: ");
        int cols = this.getAndCheckEqualMatrixColumnCount(src, dst, "source and destination matrix must have the same number of columns: ");
        int len = Math.min(rows, cols);
        int i = 0;
        while (i < len) {
            operator.operate(src[i], i, dst[i], i);
            ++i;
        }
    }

    @Override
    public void applyToEachElement(A src, int srcStart, A dst, int dstStart, int length, UnaryOperator<N, A> operator) {
        int i = 0;
        while (i < length) {
            operator.operate(src, srcStart + i, dst, dstStart + i);
            ++i;
        }
    }

    @Override
    public void applyToEachRowElement(A[] src, int srcRow, A[] dst, int dstRow, UnaryOperator<N, A> operator) {
        int cols = this.getAndCheckEqualMatrixColumnCount(src, dst, "source and destination matrix must have the same number of columns: ");
        int c = 0;
        while (c < cols) {
            operator.operate(src[srcRow], c, dst[dstRow], c);
            ++c;
        }
    }

    @Override
    public void applyToEachRowElement(A[] src, int srcRow, int srcColStart, A[] dst, int dstRow, int dstColStart, int length, UnaryOperator<N, A> operator) {
        int c = 0;
        while (c < length) {
            operator.operate(src[srcRow], srcColStart + c, dst[dstRow], dstColStart + c);
            ++c;
        }
    }

    @Override
    public void set(A vector, int index, N value) {
        NullaryOperator<N, A> op = this.operators.constant(value);
        op.operate(vector, index);
    }

    @Override
    public void set(A[] matrix, int row, int col, N value) {
        this.set(matrix[row], col, value);
    }

    @Override
    public void setAll(A vector, N value) {
        NullaryOperator<N, A> op = this.operators.constant(value);
        int len = this.arrayOps.getLength(vector);
        int i = 0;
        while (i < len) {
            op.operate(vector, i);
            ++i;
        }
    }

    @Override
    public void setAll(A[] matrix, N value) {
        NullaryOperator<N, A> op = this.operators.constant(value);
        int rows = this.arrayOps.getRowCount(matrix);
        int cols = this.arrayOps.getColumnCount(matrix);
        int r = 0;
        while (r < rows) {
            A row = matrix[r];
            int c = 0;
            while (c < cols) {
                op.operate(row, c);
                ++c;
            }
            ++r;
        }
    }

    private boolean initializationNeeded(N value) {
        return this.operators.booleanUnary(BooleanUnaryOperator.Id.isNonZero).booleanOperate(value) || !this.numberClass().isPrimitive();
    }
}

