/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math;

import ch.javasoft.util.IntArray;

public class Prime {
    private static final int MAX_CACHE_SIZE = 4096;
    private static final long POW_2_TO_63 = Long.MIN_VALUE;
    private static final long POW_2_TO_32 = 0x100000000L;
    private static final int POW_2_TO_31 = Integer.MIN_VALUE;
    private static final int POW_2_TO_30 = 0x40000000;
    private static final int POW_2_TO_16 = 65536;
    private static final int POW_2_TO_15 = 32768;
    private static final int POW_2_TO_08 = 256;
    private static final int POW_2_TO_07 = 128;
    private static final int[] POW_2_TO_63_OFFSETS = new int[]{25, 165, 259, 301, 375, 387, 391, 409, 457, 471};
    private static final int[] POW_2_TO_32_OFFSETS = new int[]{5, 17, 65, 99, 107, 135, 153, 185, 209, 267};
    private static final int[] POW_2_TO_31_OFFSETS = new int[]{1, 19, 61, 69, 85, 99, 105, 151, 159, 171};
    private static final int[] POW_2_TO_30_OFFSETS = new int[]{35, 41, 83, 101, 105, 107, 135, 153, 161, 173};
    private static final int[] POW_2_TO_16_OFFSETS = new int[]{15, 17, 39, 57, 87, 89, 99, 113, 117, 123};
    private static final int[] POW_2_TO_15_OFFSETS = new int[]{19, 49, 51, 55, 61, 75, 81, 115, 121, 135};
    private static final int[] POW_2_TO_08_OFFSETS = new int[]{5, 15, 17, 23, 27, 29, 33, 45, 57, 59};
    private static final int[] POW_2_TO_07_OFFSETS = new int[]{1, 15, 21, 25, 27, 31, 39, 45, 49, 55};

    public static long getPrime63(int index) {
        return Long.MIN_VALUE - (long)POW_2_TO_63_OFFSETS[index];
    }

    public static long getPrime32(int index) {
        return 0x100000000L - (long)POW_2_TO_32_OFFSETS[index];
    }

    public static int getPrime31(int index) {
        return Integer.MIN_VALUE - POW_2_TO_31_OFFSETS[index];
    }

    public static int getPrime30(int index) {
        return 0x40000000 - POW_2_TO_30_OFFSETS[index];
    }

    public static int getPrime16(int index) {
        return 65536 - POW_2_TO_16_OFFSETS[index];
    }

    public static int getPrime15(int index) {
        return 32768 - POW_2_TO_15_OFFSETS[index];
    }

    public static int getPrime08(int index) {
        return 256 - POW_2_TO_08_OFFSETS[index];
    }

    public static int getPrime07(int index) {
        return 128 - POW_2_TO_07_OFFSETS[index];
    }

    public static int getPrime(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index must be non-negative: " + index);
        }
        if (index == 0) {
            return 2;
        }
        int cacheSizeLog2 = Math.max(2, 32 - Integer.numberOfLeadingZeros(index) / 2);
        int n = (index + 1) * 25;
        int cacheSize = Math.min(4096, 1 << cacheSizeLog2);
        float sq = (float)Math.sqrt(n);
        int[] offsetPtr = new int[]{-1};
        IntArray[] uncached = new IntArray[]{new IntArray(), new IntArray()};
        int[] cache = new int[cacheSize];
        int curIndex = 0;
        int prime = Prime.nextPrime(cache, uncached, offsetPtr, n, sq, 1);
        while (prime <= n) {
            if (++curIndex == index) {
                return prime;
            }
            prime = Prime.nextPrime(cache, uncached, offsetPtr, n, sq, prime);
        }
        throw new RuntimeException("internal error: n is too small, n=" + n + ", cur prime has index " + curIndex + ", desired is " + index);
    }

    public static int getPrimeBelow(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("no primes below " + n);
        }
        if (n == 3) {
            return 2;
        }
        int cacheSizeLog2 = Math.max(2, 32 - Integer.numberOfLeadingZeros(n) / 2);
        int cacheSize = Math.min(4096, 1 << cacheSizeLog2);
        float sq = (float)Math.sqrt(n);
        int[] offsetPtr = new int[]{-1};
        IntArray[] uncached = new IntArray[]{new IntArray(), new IntArray()};
        int[] cache = new int[cacheSize];
        int curIndex = 0;
        int last = 2;
        int prime = Prime.nextPrime(cache, uncached, offsetPtr, n, sq, 1);
        while (prime < n) {
            ++curIndex;
            last = prime;
            prime = Prime.nextPrime(cache, uncached, offsetPtr, n, sq, prime);
        }
        return last;
    }

    private static void put(int[] cache, IntArray[] uncached, int offset, int end, int multiple, int prime) {
        int cacheSize = cache.length;
        int prime2x = prime << 1;
        while (multiple <= end) {
            if (multiple / cacheSize == offset) {
                int pos = multiple % cache.length;
                if (cache[pos] == 0) {
                    cache[pos] = prime;
                    return;
                }
                multiple += prime2x;
                continue;
            }
            uncached[0].add(multiple);
            uncached[1].add(prime);
            return;
        }
    }

    private static void refillCache(int[] cache, IntArray[] uncached, int[] offsetPtr, int end) {
        int cacheSize = cache.length;
        int offset = offsetPtr[0] = offsetPtr[0] + 1;
        int index = uncached[0].length() - 1;
        while (index >= 0) {
            int mul = uncached[0].get(index);
            if (mul / cacheSize == offset) {
                int prime = uncached[1].get(index);
                if (index == uncached[0].length() - 1) {
                    uncached[0].removeLast();
                    uncached[1].removeLast();
                } else {
                    uncached[0].set(index, uncached[0].removeLast());
                    uncached[1].set(index, uncached[1].removeLast());
                }
                Prime.put(cache, uncached, offset, end, mul, prime);
            }
            --index;
        }
    }

    private static boolean sieve(int[] cache, IntArray[] uncached, int offset, int end, int value) {
        int pos = value % cache.length;
        int prime = cache[pos];
        if (prime == 0) {
            return false;
        }
        cache[pos] = 0;
        Prime.put(cache, uncached, offset, end, value + (prime << 1), prime);
        return true;
    }

    private static int nextPrime(int[] cache, IntArray[] uncached, int[] offsetPtr, int end, float sq, int previous) {
        int cacheSize = cache.length;
        int offset = offsetPtr[0];
        int prime = previous;
        do {
            if ((prime += 2) / cacheSize == offset) continue;
            Prime.refillCache(cache, uncached, offsetPtr, end);
            offset = offsetPtr[0];
        } while (Prime.sieve(cache, uncached, offset, end, prime));
        if ((float)prime < sq) {
            Prime.put(cache, uncached, offset, end, prime * prime, prime);
        }
        return prime;
    }

    public static int countPrimes(int till, boolean trace, boolean traceAllPrimes) {
        int cacheSize = Math.min(4096, Math.max(4, 1 << 32 - Integer.numberOfLeadingZeros(till) / 2));
        return Prime.countPrimes(till, cacheSize, trace, traceAllPrimes);
    }

    public static int countPrimes(int till, int cacheSize, boolean trace, boolean traceAllPrimes) {
        if (trace) {
            System.out.printf("enumerating primes till %d\n", till);
        }
        if (cacheSize < 3) {
            throw new IllegalArgumentException("cacheSize must be at least 3");
        }
        float sq = (float)Math.sqrt(till);
        int[] offsetPtr = new int[]{-1};
        IntArray[] uncached = new IntArray[]{new IntArray(), new IntArray()};
        int[] cache = new int[cacheSize];
        long tStart = System.currentTimeMillis();
        int count = 1;
        if (traceAllPrimes) {
            System.out.printf("%d", 2);
        }
        int last = 2;
        int prime = Prime.nextPrime(cache, uncached, offsetPtr, till, sq, 1);
        while (prime <= till) {
            ++count;
            if (traceAllPrimes) {
                if (prime / 100 != last / 100) {
                    System.out.printf("\n", new Object[0]);
                } else {
                    System.out.printf(", ", new Object[0]);
                }
                System.out.printf("%d", prime);
            } else if (trace && prime / 1000000 != last / 1000000) {
                System.out.printf("primes till %d: %d (cache size is %d)\n", 1000000 * (prime / 1000000), count - 1, uncached[0].length());
            }
            last = prime;
            prime = Prime.nextPrime(cache, uncached, offsetPtr, till, sq, prime);
        }
        long tEnd = System.currentTimeMillis();
        if (trace) {
            System.out.printf("\n", new Object[0]);
            System.out.printf("cache after all: %d\n", uncached[0].length());
            System.out.printf("\n", new Object[0]);
            System.out.printf("\n", new Object[0]);
            System.out.printf("%d primes found in %dms.\n", count, tEnd - tStart);
        }
        return count;
    }
}

