/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jsmat.variable;

import ch.javasoft.jsmat.common.MatClass;
import ch.javasoft.jsmat.common.MatType;
import ch.javasoft.jsmat.primitive.MatPrimitive;
import ch.javasoft.jsmat.variable.MatAllocated;
import java.io.DataOutput;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MatMatrix<A>
extends MatAllocated {
    protected final MatType mMatType;

    public MatMatrix(MatClass matClass, MatType matType, int[] dims) {
        super(matClass, dims);
        this.mMatType = matType;
        this.checkRawDataSizeOverflow(matType.size);
    }

    @Override
    protected int getRawDataSize() {
        return this.mMatType.size * this.getMatrixSize();
    }

    protected abstract int getMatrixSize();

    @Override
    public abstract void writeRawData(DataOutput var1) throws IOException;

    public static MatMatrix<double[]> createDoubleMatrix(double[] values, int rows, int cols) {
        return MatMatrix.createDoubleMatrix(values, new int[]{rows, cols});
    }

    public static MatMatrix<double[]> createDoubleMatrix(final double[] values, int[] dims) {
        return new MatGenericMatrix<double[]>(MatClass.DOUBLE, MatType.DOUBLE, dims){

            @Override
            protected void writeStart(String name, DataOutput out) throws IOException {
                super.writeStart(name, out);
            }

            @Override
            protected int getMatrixSize() {
                return values.length;
            }

            @Override
            public void writeRawData(DataOutput out) throws IOException {
                int i = 0;
                while (i < values.length) {
                    out.writeDouble(values[i]);
                    ++i;
                }
            }
        };
    }

    public static MatMatrix<int[]> createIntMatrix(int[] values, int rows, int cols) {
        return MatMatrix.createIntMatrix(values, new int[]{rows, cols});
    }

    public static MatMatrix<int[]> createIntMatrix(final int[] values, int[] dims) {
        return new MatGenericMatrix<int[]>(MatClass.INT32, MatType.INT32, dims){

            @Override
            protected int getMatrixSize() {
                return values.length;
            }

            @Override
            public void writeRawData(DataOutput out) throws IOException {
                int i = 0;
                while (i < values.length) {
                    out.writeInt(values[i]);
                    ++i;
                }
            }
        };
    }

    public MatMatrix<char[]> createUtf8Matrix(byte[] values) {
        return this.createUtf8Matrix(values, new int[]{1, values.length});
    }

    public MatMatrix<char[]> createUtf8Matrix(final byte[] values, int[] dims) {
        return new MatGenericMatrix<char[]>(MatClass.CHAR, MatType.UTF8, dims){

            @Override
            protected int getMatrixSize() {
                return values.length;
            }

            @Override
            public void writeRawData(DataOutput out) throws IOException {
                int i = 0;
                while (i < values.length) {
                    out.write(values[i]);
                    ++i;
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class MatGenericMatrix<A>
    extends MatMatrix<A> {
        public MatGenericMatrix(MatClass matClass, MatType matType, int[] dims) {
            super(matClass, matType, dims);
        }

        @Override
        public void write(String name, DataOutput out) throws IOException {
            int rawDataSize = this.getRawDataSize();
            this.writeStart(name, out);
            MatPrimitive.writeStart(this.mMatType, out, rawDataSize);
            this.writeRawData(out);
            MatPrimitive.writeEnd(this.mMatType, out, rawDataSize);
        }
    }
}

